/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.templates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.templates.TextTemplateBinding;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BindingUtils {
    public static void instantiateOperation(Element actual, Operation operation) {
        try {
            TransformationContext.current.classifier = operation.getClass_();
            String newName = TextTemplateBinding.bind(operation.getName(), actual, null);
            operation.setName(newName);
            ConstInit cppConstInit = (ConstInit)UMLUtil.getStereotypeApplication((Element)operation, ConstInit.class);
            if (cppConstInit != null) {
                String init = cppConstInit.getInitialisation();
                String newInit = TextTemplateBinding.bind(init, actual);
                cppConstInit.setInitialisation(newInit);
            }
        }
        catch (TransformationException e) {
            throw new RuntimeException(String.format(Messages.TemplateInstantiationListener_TrafoException, e.getMessage()));
        }
    }

    public static void instantiateBehavior(Element actual, OpaqueBehavior opaqueBehavior) throws TransformationException {
        String newName;
        if (actual instanceof NamedElement && (newName = TextTemplateBinding.bind(opaqueBehavior.getName(), actual, null)) != null && !newName.equals(opaqueBehavior.getName())) {
            opaqueBehavior.setName(newName);
        }
        EList bodyList = opaqueBehavior.getBodies();
        int i = 0;
        while (i < bodyList.size()) {
            String body = (String)bodyList.get(i);
            TransformationContext.current.classifier = (Classifier)opaqueBehavior.getOwner();
            String newBody = TextTemplateBinding.bind(body, actual);
            if (newBody != null && !newBody.equals(body)) {
                bodyList.set(i, (Object)newBody);
            }
            ++i;
        }
    }
}

