/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resource.UMLResource;

public class UCMContentProvider
extends AbstractStaticContentProvider
implements IStaticContentProvider {
    protected Package rootPkg;
    protected EClass metaClass;
    Class<? extends EObject> stereoApp;

    public UCMContentProvider(Package rootPkg, EClass metaClass) {
        this(rootPkg, metaClass, null);
    }

    public UCMContentProvider(Package rootPkg, EClass metaClass, Class<? extends EObject> stereoAppFilter) {
        this.rootPkg = rootPkg;
        this.metaClass = metaClass;
        this.stereoApp = stereoAppFilter;
    }

    public Object[] getElements() {
        ArrayList<Element> results = new ArrayList<Element>();
        ArrayList<Package> visitedPkgs = new ArrayList<Package>();
        if (this.rootPkg.eResource() != null) {
            ResourceSet rs = this.rootPkg.eResource().getResourceSet();
            for (Resource resource : rs.getResources()) {
                EObject topLevelElem;
                if (!(resource instanceof UMLResource) || resource.getContents().size() <= 0 || !((topLevelElem = (EObject)resource.getContents().get(0)) instanceof Package) || topLevelElem instanceof Profile) continue;
                this.getElements((Package)topLevelElem, results, visitedPkgs);
            }
        } else {
            this.getElements(this.rootPkg, results, visitedPkgs);
        }
        return results.toArray();
    }

    public void getElements(Package pkg, List<Element> results, List<Package> visitedPkgs) {
        if (!visitedPkgs.contains(pkg)) {
            visitedPkgs.add(pkg);
            for (Element el : pkg.getPackagedElements()) {
                Dependency dep;
                if (el instanceof Dependency && (dep = (Dependency)el).getTargets().size() > 0 && dep.getTargets().get(0) instanceof Package) {
                    this.getElements((Package)dep.getTargets().get(0), results, visitedPkgs);
                }
                if (el instanceof Package) {
                    this.getElements((Package)el, results, visitedPkgs);
                }
                if (!this.metaClass.isInstance((Object)el)) continue;
                if (this.stereoApp != null) {
                    if (!StereotypeUtil.isApplied((Element)el, this.stereoApp)) continue;
                    results.add(el);
                    continue;
                }
                results.add(el);
            }
        }
    }
}

