/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.transformations;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.components.FCM.Connector;
import org.eclipse.papyrus.designer.components.FCM.InteractionComponent;
import org.eclipse.papyrus.designer.components.modellibs.core.Activator;
import org.eclipse.papyrus.designer.components.modellibs.core.Messages;
import org.eclipse.papyrus.designer.components.modellibs.core.utils.CompDepUtils;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.sync.CompImplSync;
import org.eclipse.papyrus.designer.components.transformation.templates.ComponentTemplateUtils;
import org.eclipse.papyrus.designer.components.transformation.templates.ConnectorBinding;
import org.eclipse.papyrus.designer.deployment.tools.AllocUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateInstantiation;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConnectorReification
implements IM2MTrafoCDP {
    public static Port getConnectorPort(EncapsulatedClassifier connectorType, Port otherPort, boolean isAssembly) {
        EList ports = PortUtils.getAllPorts((EncapsulatedClassifier)connectorType);
        for (Port port : ports) {
            if (!PortUtils.isCompatible((Port)port, (Port)otherPort, (boolean)isAssembly)) continue;
            return port;
        }
        throw new RuntimeException(String.format(Messages.ConnectorReification_CannotFindMatchingPort, connectorType.getName(), otherPort.getQualifiedName()));
    }

    public static ConnectorEnd oppositeConnEnd(org.eclipse.uml2.uml.Connector connector, ConnectorEnd myEnd) {
        for (ConnectorEnd end : connector.getEnds()) {
            if (end == myEnd) continue;
            return end;
        }
        return null;
    }

    public Property reifyConnector(Class composite, Property connectorPart, InstanceSpecification compositeIS) throws TransformationException {
        Class connectorImplem;
        if (!(connectorPart.getType() instanceof Class)) {
            return null;
        }
        Class connImplementation = (Class)connectorPart.getType();
        if (!StereotypeUtil.isApplied((Element)connImplementation, InteractionComponent.class)) {
            return null;
        }
        Class connectorImplemTemplate = CompDepUtils.chooseImplementation(connImplementation, (EList<InstanceSpecification>)AllocUtils.getAllNodes((InstanceSpecification)compositeIS), null);
        if (connectorImplemTemplate == null) {
            if (AllocUtils.getAllNodes((InstanceSpecification)compositeIS).size() > 1) {
                throw new TransformationException(String.format(Messages.ConnectorReification_CANT_FIND_IMPLEMENTATION_DIST, connImplementation.getName()));
            }
            throw new TransformationException(String.format(Messages.ConnectorReification_CANT_FIND_IMPLEMENTATION, connImplementation.getName()));
        }
        TemplateBinding binding = ConnectorBinding.obtainBinding((Class)composite, (Feature)connectorPart, (Class)connectorImplemTemplate, (boolean)true);
        if (binding != null) {
            TemplateInstantiation ti = new TemplateInstantiation(binding);
            connectorImplem = (Class)ti.bindElement((Element)connectorImplemTemplate);
        } else {
            connectorImplem = connectorImplemTemplate;
        }
        connectorPart.setType((Type)connectorImplem);
        ComponentTemplateUtils.retargetConnectors((StructuredClassifier)composite, (Property)connectorPart);
        return connectorPart;
    }

    public Property reifyConnector(Class composite, org.eclipse.uml2.uml.Connector connector, InstanceSpecification compositeIS) throws TransformationException {
        Class connectorImplem;
        InteractionComponent connType = null;
        Connector fcmConn = (Connector)UMLUtil.getStereotypeApplication((Element)connector, Connector.class);
        if (fcmConn != null) {
            connType = fcmConn.getIc();
        }
        if (connType == null) {
            return null;
        }
        LazyCopier copier = TransformationContext.current.copier;
        String name = ElementUtils.varName((NamedElement)connector);
        Class connectorImplemTemplate = CompDepUtils.chooseImplementation(connType.getBase_Class(), (EList<InstanceSpecification>)AllocUtils.getAllNodes((InstanceSpecification)compositeIS), null);
        TemplateBinding binding = ConnectorBinding.obtainBinding((Class)composite, (Feature)connector, (Class)connectorImplemTemplate, (boolean)true);
        if (binding != null) {
            TemplateInstantiation ti = new TemplateInstantiation(binding);
            connectorImplem = (Class)ti.bindElement((Element)connectorImplemTemplate);
        } else {
            connectorImplem = (Class)copier.getCopy((Element)connectorImplemTemplate);
        }
        if (connectorImplem == null) {
            throw new TransformationException(String.format(Messages.ConnectorReification_CouldNotBind, connectorImplemTemplate.getName()));
        }
        Property tmConnectorPart = composite.createOwnedAttribute(name, (Type)connectorImplemTemplate);
        CopyUtils.copyID((EObject)connector, (EObject)tmConnectorPart, (String)"p");
        tmConnectorPart.setIsComposite(true);
        Activator.log.info(String.format(Messages.ConnectorReification_InfoAddConnectorPart, connectorImplemTemplate.getName(), connectorImplem.getName()));
        int i = 0;
        for (ConnectorEnd smEnd : connector.getEnds()) {
            org.eclipse.uml2.uml.Connector tmConnector = composite.createOwnedConnector("c " + name + " " + String.valueOf(i));
            CopyUtils.copyID((EObject)connector, (EObject)tmConnector);
            ++i;
            ConnectorEnd tmEnd1 = tmConnector.createEnd();
            Property smPartWithPort = smEnd.getPartWithPort();
            ConnectableElement smRole = smEnd.getRole();
            tmEnd1.setPartWithPort(smPartWithPort);
            tmEnd1.setRole(smRole);
            ConnectorEnd tmEnd2 = tmConnector.createEnd();
            tmEnd2.setPartWithPort(tmConnectorPart);
            if (smRole instanceof Port) {
                tmEnd2.setRole((ConnectableElement)ConnectorReification.getConnectorPort((EncapsulatedClassifier)connectorImplem, (Port)smRole, smPartWithPort != null));
                continue;
            }
            throw new TransformationException(Messages.ConnectorReification_RequiresUseOfPorts);
        }
        tmConnectorPart.setType((Type)connectorImplem);
        connector.destroy();
        return tmConnectorPart;
    }

    public void connectContainerPorts(Class composite, Property reifiedConnector) {
        BasicEList connSubset = new BasicEList();
        for (org.eclipse.uml2.uml.Connector connector : composite.getOwnedConnectors()) {
            if (!ConnectorUtil.connectsPart((org.eclipse.uml2.uml.Connector)connector, (Property)reifiedConnector)) continue;
            connSubset.add((Object)connector);
        }
        for (Port port : PortUtils.getAllPorts((EncapsulatedClassifier)((Class)reifiedConnector.getType()))) {
            boolean connected = false;
            for (org.eclipse.uml2.uml.Connector connector : connSubset) {
                if (!ConnectorUtil.connectsPort((org.eclipse.uml2.uml.Connector)connector, (Port)port)) continue;
                connected = true;
            }
            if (connected) continue;
            for (org.eclipse.uml2.uml.Connector connector : connSubset) {
                ConnectorEnd connEnd = ConnectorUtil.connEndNotPart((org.eclipse.uml2.uml.Connector)connector, (Property)reifiedConnector);
                Property otherPart = connEnd.getPartWithPort();
                if (!(otherPart.getType() instanceof EncapsulatedClassifier)) continue;
                for (Port otherPort : PortUtils.getAllPorts((EncapsulatedClassifier)((EncapsulatedClassifier)otherPart.getType()))) {
                    Activator.log.info(String.format(Messages.ConnectorReification_InfoPortTypes, otherPort.getType().getQualifiedName(), port.getType().getQualifiedName()));
                    if (otherPort.getType() != port.getType()) continue;
                    org.eclipse.uml2.uml.Connector newConnector = composite.createOwnedConnector("connector - container of " + otherPart.getName());
                    ConnectorEnd end1 = newConnector.createEnd();
                    ConnectorEnd end2 = newConnector.createEnd();
                    end1.setPartWithPort(reifiedConnector);
                    end1.setRole((ConnectableElement)port);
                    end2.setPartWithPort(otherPart);
                    end2.setRole((ConnectableElement)otherPort);
                    connected = true;
                    break;
                }
                if (connected) break;
            }
            if (connected) continue;
            if (port.getType() == null) {
                Activator.log.debug(String.format(Messages.ConnectorReification_CouldNotConnectPort, port.getName()));
                continue;
            }
            Activator.log.debug(String.format(Messages.ConnectorReification_CouldNotConnectPortOfType, port.getName(), port.getType().getName()));
        }
    }

    protected void updateImplementation(InstanceSpecification is, Class implementation) {
        CompImplSync.updatePorts((Class)implementation);
        CompImplSync.syncRealizations((Class)implementation);
    }

    protected void updateDepPlan(InstanceSpecification is, Class implementation) {
        if (is != null) {
            is.getClassifiers().set(0, (Object)implementation);
        }
        for (Slot slot : is.getSlots()) {
            String name = slot.getDefiningFeature().getName();
            Property subAttr = implementation.getOwnedAttribute(name, null);
            slot.setDefiningFeature((StructuralFeature)subAttr);
            InstanceSpecification subIS = DepUtils.getInstance((Slot)slot);
            if (subIS == null || !(subAttr.getType() instanceof Class)) continue;
            this.updateDepPlan(subIS, (Class)subAttr.getType());
        }
    }

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        for (InstanceSpecification is : DepUtils.getInstances((Package)deploymentPlan)) {
            Type implCandidate;
            Class tmComponent;
            Classifier cl = DepUtils.getClassifier((InstanceSpecification)is);
            if (!(cl instanceof Class)) continue;
            Class clazz = (Class)cl;
            BasicEList connectorListCopy = new BasicEList();
            connectorListCopy.addAll((Collection)clazz.getOwnedConnectors());
            BasicEList attributeListCopy = new BasicEList();
            attributeListCopy.addAll((Collection)clazz.getAttributes());
            for (org.eclipse.uml2.uml.Connector connector : connectorListCopy) {
                tmComponent = (Class)connector.getOwner();
                Property newPart = this.reifyConnector(tmComponent, connector, is);
                if (newPart == null || !((implCandidate = newPart.getType()) instanceof Class)) continue;
                InstanceSpecification partIS = (InstanceSpecification)is.getNearestPackage().getMember(String.valueOf(is.getName()) + "." + connector.getName(), false, UMLPackage.eINSTANCE.getInstanceSpecification());
                if (partIS != null) {
                    this.updateImplementation(partIS, (Class)implCandidate);
                    DepCreation.createSlot((InstanceSpecification)is, (InstanceSpecification)partIS, (Property)newPart);
                    this.updateDepPlan(partIS, (Class)newPart.getType());
                    continue;
                }
                Activator.log.debug("Can not update instance specification after connector reification");
            }
            for (Property attribute : attributeListCopy) {
                tmComponent = (Class)attribute.getOwner();
                Property updatedPart = this.reifyConnector(tmComponent, attribute, is);
                if (updatedPart == null) continue;
                implCandidate = updatedPart.getType();
                Slot partSlot = DepUtils.getSlot((InstanceSpecification)is, (Property)updatedPart);
                if (!(implCandidate instanceof Class) || partSlot == null) continue;
                InstanceSpecification partIS = DepUtils.getInstance((Slot)partSlot);
                this.updateImplementation(partIS, (Class)implCandidate);
                this.updateDepPlan(partIS, (Class)implCandidate);
            }
        }
    }
}

