/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.resource.ClasspathUriUtil;

public class ClasspathURIHandler
extends URIHandlerImpl {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private final @NonNull ClassloaderClasspathUriResolver resolver = new ClassloaderClasspathUriResolver();

    public static void init(@NonNull ResourceSet resourceSet) {
        resourceSet.getURIConverter().getURIHandlers().add(0, (Object)new ClasspathURIHandler());
    }

    public boolean canHandle(URI uri) {
        return ClasspathUriUtil.isClasspathUri((URI)uri);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            URI resolvedURI = this.resolver.findResourceOnClasspath(((Object)((Object)this)).getClass().getClassLoader(), uri);
            return super.createInputStream(resolvedURI, options);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.log.info((Object)"Setup classpath URI protocol");
        EList uriHandlers = resourceSet.getURIConverter().getURIHandlers();
        if (!uriHandlers.contains((Object)this)) {
            uriHandlers.add(0, (Object)this);
        }
    }
}

