/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotFruitTestSuite;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.osgi.util.NLS;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateNameVisibilityTest4
extends PivotFruitTestSuite {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EvaluateNameVisibilityTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    @Override
    protected @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getName(), (ProjectManager)(useCodeGen ? EvaluateNameVisibilityTest4.getProjectMap() : OCL.NO_PROJECTS), null);
    }

    protected @NonNull TestOCL createOCLWithProjectMap() {
        return new TestOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getName(), (ProjectManager)EvaluateNameVisibilityTest4.getProjectMap(), null);
    }

    @Override
    protected @NonNull String getTestPackageName() {
        return "EvaluateNameVisibility";
    }

    @BeforeClass
    public static void resetCounter() throws Exception {
        PivotTestSuite.resetCounter();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        UMLStandaloneSetup.init();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_bad_navigation() throws InvocationTargetException {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.assertQueryEquals(standardLibrary.getPackage(), "Boolean", "let types = self.ownedClasses?->select(name = 'Boolean') in let type = if types->notEmpty() then types->any(true) else null endif in type?.name");
        ocl.assertQueryNull(standardLibrary.getPackage(), "let types = self.ownedClasses?->select(name = 'notAclass') in let type = if types->notEmpty() then types->any(true) else null endif in type?.name");
        ocl.assertSemanticErrorQuery(null, "let a : Type = null in a.Package", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Type", "Package");
        ocl.assertQueryNull(null, "let a : Type = null in a?.isClass()");
        ocl.assertSemanticErrorQuery(null, "let a : Type = null in a.Package()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Type", "Package");
        ocl.assertSemanticErrorQuery(null, "let a : Set(Type) = null in a.Package", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "let a : Set(Type) = null in a.Package()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "Type.Package", PivotMessagesInternal.UnresolvedStaticProperty_ERROR_, "Type", "Package");
        ocl.assertSemanticErrorQuery(null, "Type.Package()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Type", "Package", "");
        ocl.assertSemanticErrorQuery(null, "Set(Type).Package", PivotMessagesInternal.UnresolvedStaticProperty_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "Set(Type).Package()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Set(Type)", "Package", "");
        ocl.assertSemanticErrorQuery(null, "let a : Type = null in a->Package", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "let a : Type = null in a->Package()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "let a : Set(Type) = null in a->Package", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "let a : Set(Type) = null in a->Package()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Type)", "Package");
        ocl.assertSemanticErrorQuery(null, "Type->Package", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Set(Class)", "Package");
        ocl.assertSemanticErrorQuery(null, "Type->Package()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Class)", "Package");
        ocl.assertSemanticErrorQuery(null, "Set(Type)->Package", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Set(Class)", "Package");
        ocl.assertSemanticErrorQuery(null, "Set(Type)->Package()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Class)", "Package");
        ocl.assertSemanticErrorQuery(null, "let a : Type = null in a.if", "no viable alternative following input ''if''", new Object[0]);
        ocl.assertSemanticErrorQuery(null, "let a : Type = null in a->if", "no viable alternative following input ''if''", new Object[0]);
        ocl.assertQueryEquals(standardLibrary.getPackage(), 0, "let types = self.ownedClasses?->select(name = 'notAclass') in let type = if types->notEmpty() then types->any(true) else null endif in type->size()");
        ocl.assertQueryEquals(standardLibrary.getPackage(), 0, "let types = self.ownedClasses?->select(name = 'notAclass') in let type = if types->notEmpty() then types->any(true) else null endif in type?->size()");
        ocl.assertQueryEquals(standardLibrary.getPackage(), 1, "let types = self.ownedClasses?->select(name = 'Boolean') in let type = if types->notEmpty() then types->any(true) else null endif in type->size()");
        ocl.assertQueryEquals(standardLibrary.getPackage(), 1, "let types = self.ownedClasses?->select(name = 'Boolean') in let type = if types->notEmpty() then types->any(true) else null endif in type?->size()");
        ocl.assertQueryEquals(standardLibrary.getPackage(), 1, "let types = self.ownedClasses?->select(name = 'Boolean') in let type = if types->notEmpty() then types->any(true) else null endif in type?->size()?->size()");
        ocl.dispose();
    }

    @Test
    public void test_implicit_source() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        if (!useCodeGen) {
            ocl.assertQueryTrue(standardLibrary.getPackage(), "ownedClasses?->select(name = 'Integer') = Set{Integer}");
            ocl.assertQueryTrue(standardLibrary.getPackage(), "let name : String = 'String' in ownedClasses?->select(name = 'Integer') = Set{Integer}");
            ocl.assertQueryTrue(-1, "let type : Class = oclType() in type.owningPackage?.ownedClasses?->select(name = type.name) = Set{Integer}");
        }
        ocl.assertQueryTrue(standardLibrary.getPackage(), "ownedPackages->select(oclIsKindOf(Integer))->isEmpty()");
        ocl.assertQueryTrue(standardLibrary.getPackage(), "ownedPackages->select(oclIsKindOf(Package))->isEmpty()");
        ocl.dispose();
    }

    @Test
    public void test_safe_aggregate_navigation() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.assertQueryInvalid(standardLibrary.getPackage(), "ownedClasses->including(null)->select(name = 'Integer')", StringUtil.bind((String)PivotMessages.NullNavigation, (Object[])new Object[]{"source", "NamedElement::name"}), InvalidValueException.class);
        ocl.assertQueryResults(standardLibrary.getPackage(), "Set{Integer}", "ownedClasses?->select(name = 'Integer')");
        if (!useCodeGen) {
            ocl.assertQueryTrue(standardLibrary.getPackage(), "ownedClasses?->select(name = 'Integer') = Set{Integer}");
        }
        ocl.assertQueryInvalid(standardLibrary.getPackage(), "ownedClasses->including(null)->select(name = 'Integer') = Set{Integer}", StringUtil.bind((String)PivotMessages.NullNavigation, (Object[])new Object[]{"source", "NamedElement::name"}), InvalidValueException.class);
        ocl.assertQueryResults(standardLibrary.getPackage(), "Set{Integer}", "ownedClasses->including(null)?->select(name = 'Integer')");
        ocl.assertQueryTrue(standardLibrary.getPackage(), "ownedClasses->including(null)?->select(name = 'Integer')?.name = Bag{'Integer'}");
        ocl.assertQueryResults(standardLibrary.getPackage(), "Bag{'Integer', null}", "ownedClasses?->select(name = 'Integer')->including(null)->collect(c | c?.name)");
        ocl.assertQueryInvalid(standardLibrary.getPackage(), "ownedClasses->including(null)->select(name = 'Integer').name = Bag{'Integer'}", StringUtil.bind((String)PivotMessages.NullNavigation, (Object[])new Object[]{"source", "NamedElement::name"}), InvalidValueException.class);
        ocl.dispose();
    }

    @Test
    public void test_safe_object_navigation() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.assertValidationErrorQuery(ocl.getContextType(standardLibrary.getPackage()), "let parent : OclElement[1] = oclContainer()?.oclAsType(OclElement) in parent", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "LetVariable::CompatibleNullityForInitializer", "parent : OclElement[1] = self.oclContainer()?.oclAsType(OclElement)");
        ocl.assertQueryEquals(standardLibrary.getPackage(), standardLibrary.getPackage().eContainer(), "let parent : OclElement[?] = oclContainer()?.oclAsType(OclElement) in parent");
        ocl.assertQueryNull(standardLibrary.getPackage(), "let grandparent : OclElement[?] = oclContainer()?.oclContainer()?.oclAsType(OclElement) in grandparent");
        ocl.dispose();
    }

    @Test
    public void test_iterator_scope() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 6, "Set{1, 2, 3 }->iterate(i : Integer; sum : Integer = 0 | sum + i)");
        ocl.assertQueryInvalid(null, "let s : Set(String) = invalid in Set{'a'}->union(s)");
        ocl.dispose();
    }

    @Test
    public void test_compatibility_names() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 6, "Set{1, 2, 3 }->_iterate(i : Integer; sum : Integer = 0 | _sum + _i)");
        ocl.assertQueryInvalid(null, "let s : Set(String) = invalid in Set{'a'}->_union(_s)");
        ocl.dispose();
    }

    @Test
    public void test_self_scope() {
        TestOCL ocl = this.createOCL();
        ExpressionInOCL query = ocl.assertQuery(null, "Sequence{1}");
        CollectionLiteralExp coll = (CollectionLiteralExp)query.getOwnedBody();
        CollectionItem item = (CollectionItem)coll.getOwnedParts().get(0);
        ocl.assertQueryTrue(item, "type = ownedItem.type");
        ocl.assertQueryInvalid(null, "let item : CollectionItem = null in item.type = item");
        ocl.assertQueryInvalid(null, "let item : CollectionItem = invalid in item.type = item");
        ocl.dispose();
    }

    @Test
    public void test_caught_and_uncaught() {
        TestOCL ocl = this.createOCL();
        this.initFruitPackage((OCL)ocl);
        EObject context = this.fruitEFactory.create(this.tree);
        ocl.assertQueryTrue(context, "let myName : String = name in myName.oclIsKindOf(String) and myName = null");
        ocl.dispose();
    }

    @Test
    public void test_double_exists_407817() {
        TestOCL ocl = this.createOCL();
        String textQuery = "Set{'a','1'}->exists(s | Set{1,2}->exists(i | i.toString() = s.toUpper()))";
        ocl.assertQueryTrue(null, textQuery);
        ocl.dispose();
    }

    @Test
    public void test_double_get() {
        TestOCL ocl = this.createOCL();
        this.initFruitPackage((OCL)ocl);
        EObject context = this.fruitEFactory.create(this.tree);
        ocl.assertQueryEquals(context, null, "if true then name else name endif");
        ocl.dispose();
    }

    @Test
    public void test_cg_let_implies() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        String textQuery = "let bodyConstraint : Constraint = null\nin bodyConstraint <> null implies\nbodyConstraint?.ownedSpecification = null";
        Class testType = standardLibrary.getIntegerType();
        assert (testType.getOwnedInvariants().isEmpty());
        ocl.assertQueryTrue(testType, textQuery);
        ocl.dispose();
    }

    @Test
    public void test_let_implies_let_implies() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        String textQuery = "let bodyConstraint : Constraint = oclType().ownedInvariants?->any(name = 'body')\nin bodyConstraint <> null implies\nlet bodySpecification : ValueSpecification = bodyConstraint?.ownedSpecification\nin bodySpecification <> null and\nbodySpecification?.oclIsKindOf(ExpressionInOCL) implies\ntrue";
        Class testType = standardLibrary.getIntegerType();
        assert (testType.getOwnedInvariants().isEmpty());
        ocl.assertQueryTrue(-1, textQuery);
        ocl.dispose();
    }

    @Test
    public void test_no_self() throws ParserException {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "self->any(true)", PivotMessages.UnspecifiedSelfContext, new Object[0]);
        ocl.dispose();
    }

    @Test
    public void test_cg_implies_calls() throws ParserException {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ExpressionInOCL query = ocl.createQuery((EObject)standardLibrary.getOclVoidType(), "self->any(true)");
        String textQuery = "name = 'closure' implies\ntype.oclAsType(CollectionType).elementType = null";
        ocl.assertQueryTrue(query.getOwnedBody(), textQuery);
        ocl.dispose();
    }

    @Test
    public void test_cg_caught_if() throws ParserException {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ExpressionInOCL query = ocl.createQuery((EObject)standardLibrary.getOclVoidType(), "self->any(true)");
        String textQuery = "name = 'closure' implies\nif self.ownedSource?.type.oclIsKindOf(SequenceType) or self.ownedSource?.type.oclIsKindOf(OrderedSetType)then self.type.oclIsKindOf(OrderedSetType) else self.type.oclIsKindOf(SetType) endif";
        ocl.assertQueryTrue(query.getOwnedBody(), textQuery);
        ocl.dispose();
    }

    @Test
    public void test_cg_equals_528829() throws Exception {
        TestOCL ocl = this.createOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        }
        String metamodelText = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage pkg : pkg = 'pkg' {\n  class A {\n    property kind : Kind;\n  }\n  enum Kind {\n    literal X;\n  }\n}\n";
        Resource metamodel = EvaluateNameVisibilityTest4.cs2as((OCL)ocl, metamodelText);
        Model pivotModel = (Model)metamodel.getContents().get(0);
        Package pivotPackage = (Package)pivotModel.getOwnedPackages().get(0);
        Class pivotType = (Class)pivotPackage.getOwnedClasses().get(0);
        EClass eClass = (EClass)ClassUtil.nonNullState((Object)((EClass)ocl.getMetamodelManager().getEcoreOfPivot(EClass.class, (Element)pivotType)));
        EObject testObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        ocl.assertQueryFalse(testObject, "kind = 'kind'");
        ocl.assertQueryFalse(testObject, "'kind' = kind");
        ocl.dispose();
    }

    @Test
    public void test_cg_loop_source_self_or() throws ParserException, IOException {
        TestOCL ocl = this.createOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        }
        String metamodelText = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage pkg : pkg = 'pkg' {\n  class A {\n    invariant True : true;\n  }\n}\n";
        Resource metamodel = EvaluateNameVisibilityTest4.cs2as((OCL)ocl, metamodelText);
        Model pivotModel = (Model)metamodel.getContents().get(0);
        Package pivotPackage = (Package)pivotModel.getOwnedPackages().get(0);
        Class pivotType = (Class)pivotPackage.getOwnedClasses().get(0);
        Constraint pivotConstraint = (Constraint)pivotType.getOwnedInvariants().get(0);
        String textQuery = "context.oclAsType(Class).ownedInvariants->excluding(self)?->forAll(name <> self.name or isCallable <> self.isCallable)";
        ocl.assertQueryTrue(pivotConstraint, textQuery);
        ocl.dispose();
    }

    @Test
    public void test_cg_derived_property() throws ParserException, IOException {
        TestOCL ocl = this.createOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        }
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        String metamodelText = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage pkg : pkg = 'pkg' {\n  class A {\n    property derivedInteger : Integer { derivation: 99; }\n    property derivedDerivedInteger : Integer { derivation: 2 * derivedInteger;}\n  }\n}\n";
        Resource metamodel = EvaluateNameVisibilityTest4.cs2as((OCL)ocl, metamodelText);
        Model pivotModel = (Model)metamodel.getContents().get(0);
        Package pivotPackage = (Package)pivotModel.getOwnedPackages().get(0);
        Class pivotType = (Class)pivotPackage.getOwnedClasses().get(0);
        EClass eClass = (EClass)ClassUtil.nonNullState((Object)((EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotType)));
        EObject testObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        String textQuery = "self.derivedDerivedInteger";
        ocl.assertQueryEquals(testObject, 198, textQuery);
        ocl.dispose();
    }

    @Test
    public void test_cg_name_occlusion_401692() throws ParserException, IOException {
        if (useCodeGen) {
            return;
        }
        TestOCL ocl = this.createOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        }
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        String metamodelText = "package scope = 'abc'\n{\n\tclass A\n\t{\n\t\tattribute d : String;\n\t\tattribute e : String;\n\t}\n\tclass B\n\t{\n\t\toperation findA(e : String) : A[?]\n\t\t{\n\t\t\tbody:\n\t\t\t\tlet found : OrderedSet(A) = as?->select(a : A | a.d = e) in if found->size() > 0 then found->first() else null endif;\n\t\t}\n\t\tproperty as : A[*] { ordered composes };\n\t}\n}\n";
        Resource metamodel = EvaluateNameVisibilityTest4.cs2as((OCL)ocl, metamodelText);
        Model pivotModel = (Model)metamodel.getContents().get(0);
        Package pivotPackage = (Package)pivotModel.getOwnedPackages().get(0);
        Class pivotTypeA = (Class)ClassUtil.nonNullState((Object)((Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"A")));
        Class pivotTypeB = (Class)ClassUtil.nonNullState((Object)((Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"B")));
        EPackage ePackage = (EPackage)ClassUtil.nonNullState((Object)((EPackage)metamodelManager.getEcoreOfPivot(EPackage.class, (Element)pivotPackage)));
        EClass eClassA = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeA);
        EClass eClassB = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeB);
        EAttribute eAttributeAd = (EAttribute)metamodelManager.getEcoreOfPivot(EAttribute.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeA.getOwnedProperties(), (String)"d"))));
        EAttribute eAttributeAe = (EAttribute)metamodelManager.getEcoreOfPivot(EAttribute.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeA.getOwnedProperties(), (String)"e"))));
        EReference eReferenceBas = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeB.getOwnedProperties(), (String)"as"))));
        EFactory eFactory = ePackage.getEFactoryInstance();
        ResourceImpl resource = new ResourceImpl();
        EObject testObjectA1 = eFactory.create(eClassA);
        testObjectA1.eSet((EStructuralFeature)eAttributeAd, (Object)"d1");
        testObjectA1.eSet((EStructuralFeature)eAttributeAe, (Object)"e1");
        EObject testObjectA2 = eFactory.create(eClassA);
        testObjectA2.eSet((EStructuralFeature)eAttributeAd, (Object)"d2");
        testObjectA2.eSet((EStructuralFeature)eAttributeAe, (Object)"e2");
        EObject testObjectB = eFactory.create(eClassB);
        resource.getContents().add((Object)testObjectB);
        List as = (List)testObjectB.eGet((EStructuralFeature)eReferenceBas);
        as.add(testObjectA1);
        as.add(testObjectA2);
        ocl.assertQueryEquals(testObjectB, testObjectA1, "self.findA('d1')");
        ocl.assertQueryEquals(testObjectB, null, "self.findA('e2')");
        ocl.dispose();
    }

    @Test
    public void test_cg_tuple_access() throws ParserException, IOException {
        TestOCL ocl = this.createOCL();
        String textQuery = "let\n  table : Set(Tuple(range : Sequence(Integer), size : String)) = Set{\n    Tuple{range = Sequence{0..49}, size = 'small'},\n    Tuple{range = Sequence{50..999}, size = 'medium'},\n    Tuple{range = Sequence{1000..1000000}, size = 'large'}\n  }\nin\n  table?->any(range->includes(200000))?.size";
        ocl.assertQueryEquals(null, "large", textQuery);
        ocl.dispose();
    }

    @Test
    public void test_container_navigation() throws InvocationTargetException {
        TestOCL ocl = this.createOCL();
        this.initFruitPackage((OCL)ocl);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        IdResolver idResolver = ocl.getIdResolver();
        metamodelManager.addGlobalNamespace("fruit", (Namespace)this.fruitPackage);
        EObject redApple = this.fruitEFactory.create(this.apple);
        redApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
        EObject aTree = this.fruitEFactory.create(this.tree);
        List treeFruits = (List)aTree.eGet((EStructuralFeature)this.tree_fruits);
        treeFruits.add(redApple);
        Type pivotTree = (Type)metamodelManager.getASOfEcore(Type.class, (EObject)this.tree);
        ocl.assertQueryEquals(redApple, this.color_red, "let aFruit : fruit::Fruit = self in aFruit.color");
        ocl.assertQueryEquals(aTree, idResolver.createOrderedSetOfEach(TypeId.SET, new Object[]{redApple}), "let aTree : fruit::Tree = self in aTree.fruits");
        ocl.assertQueryEquals(aTree, idResolver.createOrderedSetOfEach(TypeId.SET, new Object[]{redApple}), "self.fruits");
        ocl.assertQueryEquals(aTree, idResolver.createOrderedSetOfEach(TypeId.SET, new Object[]{redApple}), "fruits");
        ocl.assertQueryEquals(redApple, aTree, "self.oclContainer()");
        ocl.assertQueryEquals(redApple, aTree, "self.Tree");
        ocl.assertQueryEquals(redApple, pivotTree, "Tree");
        ocl.assertQueryInvalid(redApple, "self.oclAsType(Tree)");
        ocl.dispose();
    }

    @Test
    public void test_nested_names() throws InvocationTargetException {
        TestOCL ocl = this.createOCLWithProjectMap();
        this.initFruitPackage((OCL)ocl);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        IdResolver idResolver = ocl.getIdResolver();
        Class appleType = (Class)metamodelManager.getASOfEcore(Class.class, (EObject)this.apple);
        EObject redApple = this.fruitEFactory.create(this.apple);
        redApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
        redApple.eSet((EStructuralFeature)this.fruit_name, (Object)"RedApple");
        EObject appleTree = this.fruitEFactory.create(this.tree);
        appleTree.eSet((EStructuralFeature)this.tree_name, (Object)"AppleTree");
        List treeFruits = (List)appleTree.eGet((EStructuralFeature)this.tree_fruits);
        treeFruits.add(redApple);
        ocl.assertQueryEquals(redApple, "RedApple", "self.name");
        ocl.assertQueryEquals(redApple, "RedApple", "self.Fruit::name");
        ocl.assertQueryEquals(redApple, "RedApple", "self.Apple::name");
        ocl.assertValidationErrorQuery(appleType, "self.Tree::name", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "PropertyCallExp::NonStaticSourceTypeIsConformant", "self.name");
        ocl.assertQueryFalse(redApple, "self.color = Color::green");
        ocl.assertQueryTrue(redApple, "self.color = Color::red");
        ocl.assertQueryFalse(redApple, "self.color = 'red'");
        ocl.assertQueryEquals(redApple, redApple, "self.oclAsType(Apple)");
        ocl.assertQueryEquals(redApple, redApple, "self.oclAsType(fruit::Apple)");
        ocl.assertQueryEquals(redApple, idResolver.createSetOfEach(TypeId.SET, new Object[]{redApple}), "self->oclAsType(Set(Fruit))");
        ocl.assertQueryEquals(redApple, idResolver.createSetOfEach(TypeId.SET, new Object[]{redApple}), "self->oclAsType(Set(fruit::Apple))");
        ocl.assertSemanticErrorQuery(appleType, "self.oclAsType(fruit::fruit::Apple)", PivotMessagesInternal.UnresolvedNamespace_ERROR_, "", "fruit");
        ocl.assertSemanticErrorQuery(appleType, "self->oclAsType(Set(fruit::apple::BadApple))", PivotMessagesInternal.UnresolvedType_ERROR_, "", "BadApple");
        ocl.assertSemanticErrorQuery(appleType, "self->oclAsType(Set(fruit::apple::BadApple))", PivotMessagesInternal.UnresolvedType_ERROR_, "", "BadApple");
        ocl.assertSemanticErrorQuery(appleType, "self->oclAsType(Set(fruit::badapple::BadApple))", PivotMessagesInternal.UnresolvedNamespace_ERROR_, "", "badapple");
        ocl.assertSemanticErrorQuery(appleType, "self->oclAsType(Set(badfruit::badapple::BadApple))", PivotMessagesInternal.UnresolvedNamespace_ERROR_, "", "badfruit");
        ocl.assertQueryInvalid(redApple, "self->oclAsType(Set(fruit::apple::EatingApple))");
        ocl.assertQueryInvalid(redApple, "self->oclAsType(Set(fruit::Tree))");
        ocl.assertQueryEquals(redApple, idResolver.createSetOfEach(TypeId.SET, new Object[]{appleTree}), "Tree.allInstances()");
        ocl.assertQueryEquals(redApple, idResolver.createSetOfEach(TypeId.SET, new Object[]{appleTree}), "fruit::Tree.allInstances()");
        EObject orphanFruit = this.fruitEFactory.create(this.apple);
        ocl.assertQueryEquals(orphanFruit, ocl.getEmptySetValue(), "fruit::Tree.allInstances()");
        metamodelManager.addGlobalNamespace("zz", (Namespace)this.fruitPackage);
        ocl.assertQueryEquals(redApple, idResolver.createSetOfEach(TypeId.SET, new Object[]{appleTree}), "zz::Tree.allInstances()");
        ocl.assertQueryEquals(redApple, idResolver.createBagOfEach(TypeId.BAG, new Object[]{redApple}), "Fruit.allInstances().oclAsType(Apple)");
        ocl.assertQueryEquals(redApple, idResolver.createSetOfEach(TypeId.SET, new Object[]{redApple}), "Fruit.allInstances()->oclAsType(Set(Apple))");
        ocl.dispose();
    }

    @Test
    public void test_reservedNames() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "Boolean.allInstances()->forAll(_'if' | _'if' <> null)");
        ocl.assertQueryTrue(null, "let _'if' = true in _'if'");
        ocl.dispose();
    }

    @Test
    public void test_type_construction() throws InvocationTargetException {
        TestOCL ocl = this.createOCL();
        this.initFruitPackage((OCL)ocl);
        EObject context = this.fruitEFactory.create(this.tree);
        ocl.assertValidationErrorQuery(ocl.getContextType(context), "Apple{stem=null}.label", "Missing initializers: color", new Object[0]);
        ocl.assertValidationErrorQuery(ocl.getContextType(context), "Apple{name=null}.label", "Unexpected initializers: name", new Object[0]);
        ocl.assertQueryEquals(context, null, "Apple{color=null,label=null,stem=null}.label");
        ocl.assertQueryEquals(context, "RedApple", "Apple{color=Color::red,label='RedApple',stem=null}.label");
        ocl.assertQueryEquals(context, this.color_red, "Apple{color=Color::red,label='RedApple',stem=null}.color");
        ocl.assertQueryTrue(context, "Apple{color=Color::red,label='RedApple',stem=null} = Apple{color=Color::red,label='RedApple',stem=null}");
        ocl.assertQueryTrue(context, "let thisApple = Apple{stem=null,label='AnApple',color=Color::red}, thatApple = Apple{label='AnApple',color=Color::red,stem=null} in thisApple = thatApple");
        ocl.assertQueryTrue(context, "let thisApple = Apple{stem=null,label='AnApple',color=Color::red}, thatApple = Apple{stem=null,color=Color::red,label='AnApple'} in thisApple = thatApple");
        ocl.assertQueryTrue(context, "let thisApple = Apple{stem=null,label='AnApple',color=Color::red}, thatApple = Apple{stem=null,label='AnApple',color=Color::red} in thisApple.label = thatApple.label");
        ocl.assertQueryTrue(context, "let thisApple = Apple{stem=null,label='AnApple',color=Color::red}, thatApple = Apple{stem=null,label='AnApple',color=Color::red} in thisApple.color = thatApple.color");
        ocl.assertQueryTrue(context, "let thisApple = Apple{stem=null,label='AnApple',color=Color::red}, thatApple = Apple{stem=null,label='AnApple',color=Color::red} in thisApple.label = thatApple.label and thisApple.color = thatApple.color");
        ocl.assertQueryFalse(context, "let thisApple = Apple{stem=null,label='ThisApple',color=Color::red}, thatApple = Apple{stem=null,label='ThatApple',color=Color::red} in thisApple.label = thatApple.label and thisApple.color = thatApple.color");
        ocl.assertQueryFalse(context, "let thisApple = Apple{stem=null,label='AnApple',color=Color::red}, thatApple = Apple{stem=null,label='AnApple',color=Color::black} in thisApple.label = thatApple.label and thisApple.color = thatApple.color");
        ocl.dispose();
    }

    @Test
    public void test_uml_primitives_399378() throws ParserException {
        TestOCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        UML2AS.initialize((ResourceSet)resourceSet);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        URI uri = EvaluateNameVisibilityTest4.getTestModelURI("models/uml/Fruit.uml");
        Element element = (Element)ClassUtil.nonNullState((Object)metamodelManager.loadResource(uri, null, resourceSet));
        Package fruitPackage = (Package)((Model)element).getOwnedPackages().get(0);
        Class treeClass = (Class)NameUtil.getNameable((Iterable)fruitPackage.getOwnedClasses(), (String)"Tree");
        ExpressionInOCL query = ocl.createQuery((EObject)treeClass, "self.height>20");
        EvaluateNameVisibilityTest4.assertNotNull((Object)query);
        ocl.dispose();
    }

    @Test
    public void test_dynamic_dispatch_411154() throws ParserException, IOException {
        if (useCodeGen) {
            return;
        }
        TestOCL ocl = this.createOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        }
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        String metamodelText = "package Bug411154 : pfx = 'Bug411154.ecore'\n{\n\tclass Domain {\n\t\tproperty types : T1[*] { ordered composes };\n\t\tproperty t1_2a : T1;\n\t\tproperty t1_3a : T1;\n\t\tproperty t1_3b : T1;\n\t\tproperty t1_4 : T1;\n\t\tproperty t2a_2a : T2a;\n\t\tproperty t2a_3a : T2a;\n\t\tproperty t2b_2b : T2b;\n\t\tproperty t3a : T3a;\n\t}\n\tabstract class T1 {\n\t\toperation op1() : String { body: 'T1::op1'; }\n\t\toperation op4() : String { body: 'T1::op4'; }\n\t\toperation op5() : String { body: 'T1::op5'; }\n\t\toperation op6() : String { body: 'T1::op6'; }\n\t}\n\tclass T2a extends T1 {\n\t\toperation op1() : String { body: 'T2a::op1'; }\n\t\toperation op2() : String { body: 'T2a::op2'; }\n\t\toperation op4() : String { body: 'T2a::op4'; }\n\t\toperation op6() : String { body: 'T2a::op6'; }\n\t\toperation op7() : String { body: 'T2a::op7'; }\n\t\toperation op9() : String { body: 'T2a::op9'; }\n\t}\n\tclass T2b extends T1 {\n\t\toperation op6() : String { body: 'T2b::op6'; }\n\t\toperation op7() : String { body: 'T2b::op7'; }\n\t\toperation op9() : String { body: 'T2b::op9'; }\n\t}\n\tclass T3a extends T2a,T2b {\n\t\toperation op1() : String { body: 'T3a::op1'; }\n\t\toperation op2() : String { body: 'T3a::op2'; }\n\t\toperation op3() : String { body: 'T3a::op3'; }\n\t\toperation op6() : String { body: 'T3a::op6'; }\n\t\toperation op7() : String { body: 'T3a::op7'; }\n\t}\n\tclass T3b extends T2a,T2b {\n\t}\n\tclass T4 extends T3a,T3b {\n\t\toperation op6() : String { body: 'T4::op6'; }\n\t\toperation op7() : String { body: 'T4::op7'; }\n\t}\n}\n";
        Resource metamodel = EvaluateNameVisibilityTest4.cs2as((OCL)ocl, metamodelText);
        Model pivotModel = (Model)metamodel.getContents().get(0);
        Package pivotPackage = (Package)pivotModel.getOwnedPackages().get(0);
        Class pivotTypeDomain = (Class)ClassUtil.nonNullState((Object)((Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"Domain")));
        Class pivotTypeT2a = (Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"T2a");
        Class pivotTypeT2b = (Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"T2b");
        Class pivotTypeT3a = (Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"T3a");
        Class pivotTypeT3b = (Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"T3b");
        Class pivotTypeT4 = (Class)NameUtil.getNameable((Iterable)pivotPackage.getOwnedClasses(), (String)"T4");
        EPackage ePackage = (EPackage)ClassUtil.nonNullState((Object)((EPackage)metamodelManager.getEcoreOfPivot(EPackage.class, (Element)pivotPackage)));
        EClass eClassDomain = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeDomain);
        EClass eClassT2a = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeT2a);
        EClass eClassT2b = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeT2b);
        EClass eClassT3a = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeT3a);
        EClass eClassT3b = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeT3b);
        EClass eClassT4 = (EClass)metamodelManager.getEcoreOfPivot(EClass.class, (Element)pivotTypeT4);
        EReference eReferenceDomain_types = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"types"))));
        EReference eReferenceDomain_t1_2a = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t1_2a"))));
        EReference eReferenceDomain_t1_3a = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t1_3a"))));
        EReference eReferenceDomain_t1_3b = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t1_3b"))));
        EReference eReferenceDomain_t1_4 = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t1_4"))));
        EReference eReferenceDomain_t2a_2a = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t2a_2a"))));
        EReference eReferenceDomain_t2a_3a = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t2a_3a"))));
        EReference eReferenceDomain_t2b_2b = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t2b_2b"))));
        EReference eReferenceDomain_t3a = (EReference)metamodelManager.getEcoreOfPivot(EReference.class, (Element)ClassUtil.nonNullState((Object)((Property)NameUtil.getNameable((Iterable)pivotTypeDomain.getOwnedProperties(), (String)"t3a"))));
        EFactory eFactory = ePackage.getEFactoryInstance();
        ResourceImpl resource = new ResourceImpl();
        EObject testObjectDomain = eFactory.create(eClassDomain);
        resource.getContents().add((Object)testObjectDomain);
        EObject testObjectT2a = eFactory.create(eClassT2a);
        EObject testObjectT2b = eFactory.create(eClassT2b);
        EObject testObjectT3a = eFactory.create(eClassT3a);
        EObject testObjectT3b = eFactory.create(eClassT3b);
        EObject testObjectT4 = eFactory.create(eClassT4);
        List list = (List)testObjectDomain.eGet((EStructuralFeature)eReferenceDomain_types);
        list.add(testObjectT2a);
        list.add(testObjectT2b);
        list.add(testObjectT3a);
        list.add(testObjectT3b);
        list.add(testObjectT4);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t1_2a, (Object)testObjectT2a);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t1_3a, (Object)testObjectT3a);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t1_3b, (Object)testObjectT3b);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t1_4, (Object)testObjectT4);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t2a_2a, (Object)testObjectT2a);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t2a_3a, (Object)testObjectT3a);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t2b_2b, (Object)testObjectT2b);
        testObjectDomain.eSet((EStructuralFeature)eReferenceDomain_t3a, (Object)testObjectT3a);
        ocl.assertQueryEquals(testObjectT2a, "T2a::op1", "self.op1()");
        ocl.assertQueryEquals(testObjectT2a, "T2a::op2", "self.op2()");
        ocl.assertSemanticErrorQuery(pivotTypeT2a, "self.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T2a::op3");
        ocl.assertQueryEquals(testObjectT2a, "T2a::op4", "self.op4()");
        ocl.assertQueryEquals(testObjectT2a, "T1::op5", "self.op5()");
        ocl.assertQueryEquals(testObjectT2a, "T2a::op6", "self.op6()");
        ocl.assertQueryEquals(testObjectT2a, "T2a::op7", "self.op7()");
        ocl.assertSemanticErrorQuery(pivotTypeT2a, "self.op8()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T2a::op8");
        ocl.assertQueryEquals(testObjectT2a, "T2a::op9", "self.op9()");
        ocl.assertQueryEquals(testObjectT3a, "T3a::op1", "self.op1()");
        ocl.assertQueryEquals(testObjectT3a, "T3a::op2", "self.op2()");
        ocl.assertQueryEquals(testObjectT3a, "T3a::op3", "self.op3()");
        ocl.assertQueryEquals(testObjectT3a, "T2a::op4", "self.op4()");
        ocl.assertQueryEquals(testObjectT3a, "T1::op5", "self.op5()");
        ocl.assertQueryEquals(testObjectT3a, "T3a::op6", "self.op6()");
        ocl.assertQueryEquals(testObjectT3a, "T3a::op7", "self.op7()");
        ocl.assertSemanticErrorQuery(pivotTypeT3a, "self.op8()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T3a::op8");
        ocl.assertSemanticErrorQuery(pivotTypeT3a, "self.op9()", "Ambiguous resolution:\n\tOperation : Bug411154::T2a::op9() : String[?]\n\tOperation : Bug411154::T2b::op9() : String[?]", new Object[0]);
        ocl.assertQueryEquals(testObjectDomain, "T2a::op1", "t1_2a.op1()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_2a.op2()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op2");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_2a.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op3");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t1_2a.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t1_2a.op5()");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op1", "t1_3a.op1()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_3a.op2()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op2");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_3a.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op3");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t1_3a.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t1_3a.op5()");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op1", "t1_3b.op1()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_3b.op2()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op2");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_3b.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op3");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t1_3b.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t1_3b.op5()");
        ocl.assertQueryInvalid(testObjectDomain, "t1_3b.op6()", NLS.bind((String)PivotMessages.AmbiguousOperation, (Object)"Bug411154::T1::op6() : String[?]", (Object)"Bug411154::T3b"), InvalidValueException.class);
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_3b.op7()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op7");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op1", "t1_4.op1()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_4.op2()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op2");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_4.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op3");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t1_4.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t1_4.op5()");
        ocl.assertQueryEquals(testObjectDomain, "T4::op6", "t1_4.op6()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t1_4.op7()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T1::op7");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op1", "t2a_2a.op1()");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op2", "t2a_2a.op2()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t2a_2a.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T2a::op3");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t2a_2a.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t2a_2a.op5()");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op6", "t2a_2a.op6()");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op7", "t2a_2a.op7()");
        ocl.assertQueryEquals(testObjectDomain, "T2b::op6", "t2b_2b.op6()");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op1", "t2a_3a.op1()");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op2", "t2a_3a.op2()");
        ocl.assertSemanticErrorQuery(pivotTypeDomain, "t2a_3a.op3()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bug411154", "T2a::op3");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t2a_3a.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t2a_3a.op5()");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op1", "t3a.op1()");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op2", "t3a.op2()");
        ocl.assertQueryEquals(testObjectDomain, "T3a::op3", "t3a.op3()");
        ocl.assertQueryEquals(testObjectDomain, "T2a::op4", "t3a.op4()");
        ocl.assertQueryEquals(testObjectDomain, "T1::op5", "t3a.op5()");
        ocl.dispose();
    }
}

