/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.prefuse.examples.radialgraphview;

import org.eclipse.gmt.modisco.infra.prefuse.examples.radialgraphview.NodeColorAction;
import org.eclipse.gmt.modisco.infra.prefuse.examples.radialgraphview.TextColorAction;
import org.eclipse.gmt.modisco.infra.prefuse.examples.radialgraphview.TreeRootAction;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.PolarLocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.HoverActionControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class RadialGraphView
extends Display {
    private LabelRenderer m_nodeRenderer;
    private EdgeRenderer m_edgeRenderer;
    private String m_label = "label";

    public RadialGraphView(Graph g, String label) {
        super(new Visualization());
        this.m_label = label;
        this.m_vis.add("tree", (TupleSet)g);
        this.m_vis.setInteractive("tree.edges", null, false);
        this.m_nodeRenderer = new LabelRenderer(this.m_label);
        this.m_nodeRenderer.setRenderType(2);
        this.m_nodeRenderer.setHorizontalAlignment(2);
        this.m_nodeRenderer.setRoundedCorner(8, 8);
        this.m_edgeRenderer = new EdgeRenderer();
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.m_nodeRenderer);
        rf.add((Predicate)new InGroupPredicate("tree.edges"), (Renderer)this.m_edgeRenderer);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        NodeColorAction nodeColor = new NodeColorAction("tree.nodes");
        TextColorAction textColor = new TextColorAction("tree.nodes");
        this.m_vis.putAction("textColor", (Action)textColor);
        ColorAction edgeColor = new ColorAction("tree.edges", VisualItem.STROKECOLOR, ColorLib.rgb((int)200, (int)200, (int)200));
        FontAction fonts = new FontAction("tree.nodes", FontLib.getFont((String)"Tahoma", (double)10.0));
        fonts.add("ingroup('_focus_')", FontLib.getFont((String)"Tahoma", (double)11.0));
        ActionList recolor = new ActionList();
        recolor.add((Action)nodeColor);
        recolor.add((Action)textColor);
        this.m_vis.putAction("recolor", (Action)recolor);
        ActionList repaint = new ActionList();
        repaint.add((Action)recolor);
        repaint.add((Action)new RepaintAction());
        this.m_vis.putAction("repaint", (Action)repaint);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator("tree.nodes"));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        RadialTreeLayout treeLayout = new RadialTreeLayout("tree");
        this.m_vis.putAction("treeLayout", (Action)treeLayout);
        CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout("tree");
        this.m_vis.putAction("subLayout", (Action)subLayout);
        ActionList filter = new ActionList();
        filter.add((Action)new TreeRootAction("tree"));
        filter.add((Action)fonts);
        filter.add((Action)treeLayout);
        filter.add((Action)subLayout);
        filter.add((Action)textColor);
        filter.add((Action)nodeColor);
        filter.add((Action)edgeColor);
        this.m_vis.putAction("filter", (Action)filter);
        ActionList animate = new ActionList(1250L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)new QualityControlAnimator());
        animate.add((Action)new VisibilityAnimator("tree"));
        animate.add((Action)new PolarLocationAnimator("tree.nodes", "linear"));
        animate.add((Action)new ColorAnimator("tree.nodes"));
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("animate", (Action)animate);
        this.m_vis.alwaysRunAfter("filter", "animate");
        this.setSize(700, 600);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new FocusControl(1, "filter"));
        this.addControlListener((Control)new HoverActionControl("repaint"));
        this.m_vis.run("filter");
        this.m_vis.addFocusGroup("linear", (TupleSet)new DefaultTupleSet());
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TupleSet linearInterp = RadialGraphView.this.m_vis.getGroup("linear");
                if (add.length < 1) {
                    return;
                }
                linearInterp.clear();
                Node n = (Node)add[0];
                while (n != null) {
                    linearInterp.addTuple((Tuple)n);
                    n = n.getParent();
                }
            }
        });
        PrefixSearchTupleSet search = new PrefixSearchTupleSet();
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)search);
        search.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                RadialGraphView.this.m_vis.cancel("animatePaint");
                RadialGraphView.this.m_vis.run("recolor");
                RadialGraphView.this.m_vis.run("animatePaint");
            }
        });
    }
}

