/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

public class ColorMap {
    private int[] palette;
    private double minValue;
    private double maxValue;

    public ColorMap(int[] map, double min, double max) {
        this.palette = map;
        this.minValue = min;
        this.maxValue = max;
    }

    public int getColor(double val) {
        if (val < this.minValue) {
            return this.palette[0];
        }
        if (val >= this.maxValue) {
            return this.palette[this.palette.length - 1];
        }
        int idx = (int)((double)this.palette.length * (val - this.minValue) / (this.maxValue - this.minValue));
        return this.palette[idx];
    }

    public int[] getColorPalette() {
        return this.palette;
    }

    public void setColorPalette(int[] palette) {
        this.palette = palette;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }
}

