/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.io.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.Comment;
import org.eclipse.gmt.modisco.java.CompilationUnit;
import org.eclipse.gmt.modisco.java.Javadoc;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.modisco.java.discoverer.internal.io.java.JDTVisitor;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.PendingElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentsManager {
    private final boolean debug = false;
    private static CommentsManager instance = new CommentsManager();

    private CommentsManager() {
    }

    public static void resolveCommentPositions(JDTVisitor visitor) {
        org.eclipse.jdt.core.dom.CompilationUnit cuJdtNode = visitor.getCuNode();
        CompilationUnit moDiscoCuNode = (CompilationUnit)visitor.getBijectiveMap().getValue((ASTNode)cuJdtNode);
        ArrayList<Comment> commentsList = new ArrayList<Comment>(visitor.getCommentsBinding().getValues());
        CommentsManager manager = instance;
        List<Comment> unLocatedComments = manager.jdtLocationSearch(visitor, cuJdtNode, moDiscoCuNode, commentsList);
        instance.getClass();
        unLocatedComments.addAll((Collection<Comment>)moDiscoCuNode.getComments());
        for (AbstractTypeDeclaration type : moDiscoCuNode.getTypes()) {
            for (Comment comment : type.getComments()) {
                if (!comment.isEnclosedByParent()) continue;
                unLocatedComments.add(comment);
            }
        }
        for (Comment comment : unLocatedComments) {
            instance.getClass();
            boolean locationFound = CommentsManager.alternateLocationSearch(comment, visitor, moDiscoCuNode);
            if (locationFound) continue;
            instance.getClass();
            if (visitor.getRootTypeOrEnum() != null) {
                visitor.getRootTypeOrEnum().getComments().add((Object)comment);
                continue;
            }
            EcoreUtil.delete((EObject)comment);
        }
    }

    private List<Comment> jdtLocationSearch(JDTVisitor visitor, org.eclipse.jdt.core.dom.CompilationUnit cuJdtNode, CompilationUnit moDiscoCuNode, List<Comment> commentsList) {
        ArrayList<Comment> localCommentList = new ArrayList<Comment>(commentsList);
        TreeMap<Integer, ASTNode> nodesMap = new TreeMap<Integer, ASTNode>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (ASTNode node : visitor.getBijectiveMap().getKeys()) {
            int position = node.getStartPosition();
            if (cuJdtNode.firstLeadingCommentIndex(node) != -1) {
                nodesMap.put(position, node);
                continue;
            }
            if (cuJdtNode.lastTrailingCommentIndex(node) == -1) continue;
            nodesMap.put(position, node);
        }
        for (Integer indexMap : nodesMap.keySet()) {
            ASTNode jdtNode = (ASTNode)nodesMap.get(indexMap);
            org.eclipse.gmt.modisco.java.ASTNode element = visitor.getBijectiveMap().getValue(jdtNode);
            if (element instanceof PendingElement) {
                element = ((PendingElement)element).getClientNode() != null ? ((PendingElement)element).getClientNode() : visitor.getBijectiveMap().getValue(jdtNode.getParent());
            }
            if (element instanceof Package) {
                element = moDiscoCuNode;
            } else {
                ListIterator listIterator = element.getComments().listIterator();
                while (listIterator.hasNext()) {
                    Comment comment = (Comment)listIterator.next();
                    if (!(comment instanceof Javadoc)) continue;
                    listIterator.remove();
                }
            }
            instance.getClass();
            List<Comment> commentsToLink = this.computeListOfcommentsBefore(jdtNode, cuJdtNode, visitor);
            this.addComments(commentsToLink, element, false, true, localCommentList);
            commentsToLink = this.computeListOfcommentsAfter(jdtNode, cuJdtNode, visitor);
            this.addComments(commentsToLink, element, false, false, localCommentList);
        }
        return localCommentList;
    }

    private List<Comment> computeListOfcommentsAfter(ASTNode jdtNode, org.eclipse.jdt.core.dom.CompilationUnit cuJdtNode, JDTVisitor visitor) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        int index = cuJdtNode.lastTrailingCommentIndex(jdtNode);
        if (index != -1) {
            int endPosition = cuJdtNode.getExtendedStartPosition(jdtNode) + cuJdtNode.getExtendedLength(jdtNode);
            int i = index;
            while (i > -1) {
                ASTNode jdtComment = (ASTNode)cuJdtNode.getCommentList().get(i);
                int commentEndPosition = cuJdtNode.getExtendedStartPosition(jdtComment) + cuJdtNode.getExtendedLength(jdtComment);
                String whitespaces = null;
                if (endPosition > commentEndPosition) {
                    whitespaces = visitor.getJavaContent().substring(commentEndPosition, endPosition).trim();
                }
                if (whitespaces == null || whitespaces.length() == 0) {
                    endPosition = cuJdtNode.getExtendedStartPosition(jdtComment);
                    Comment comment = visitor.getCommentsBinding().get(jdtComment);
                    if (comment != null) {
                        result.add(0, comment);
                    }
                } else {
                    i = -1;
                }
                --i;
            }
        }
        return result;
    }

    private void addComments(List<Comment> commentsBefore, org.eclipse.gmt.modisco.java.ASTNode element, boolean enclosedByElement, boolean prefixOfElement, List<Comment> localCommentsList) {
        for (Comment comment : commentsBefore) {
            if (!localCommentsList.contains(comment)) continue;
            comment.setEnclosedByParent(enclosedByElement);
            comment.setPrefixOfParent(prefixOfElement);
            element.getComments().add((Object)comment);
            localCommentsList.remove(comment);
        }
    }

    private List<Comment> computeListOfcommentsBefore(ASTNode jdtNode, org.eclipse.jdt.core.dom.CompilationUnit cuJdtNode, JDTVisitor visitor) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        int index = cuJdtNode.firstLeadingCommentIndex(jdtNode);
        if (index != -1) {
            int size = cuJdtNode.getCommentList().size();
            int startPosition = cuJdtNode.getExtendedStartPosition(jdtNode);
            int i = index;
            while (i < size) {
                ASTNode jdtComment = (ASTNode)cuJdtNode.getCommentList().get(i);
                int commentPosition = cuJdtNode.getExtendedStartPosition(jdtComment);
                String whitespaces = null;
                if (commentPosition > startPosition) {
                    whitespaces = visitor.getJavaContent().substring(startPosition, commentPosition).trim();
                }
                if (whitespaces == null || whitespaces.length() == 0) {
                    startPosition = commentPosition + cuJdtNode.getExtendedLength(jdtComment);
                    Comment comment = visitor.getCommentsBinding().get(jdtComment);
                    if (comment != null) {
                        result.add(comment);
                    }
                } else {
                    i = size;
                }
                ++i;
            }
        }
        return result;
    }

    public static String extractCommentContent(org.eclipse.jdt.core.dom.Comment comment, String originalFileContent) {
        String result = originalFileContent.substring(comment.getStartPosition(), comment.getStartPosition() + comment.getLength());
        return result;
    }

    private static boolean alternateLocationSearch(Comment comment, JDTVisitor visitor, CompilationUnit moDiscoCuNode) {
        CompilationUnit bestParent = null;
        ASTNode jdtComment = visitor.getCommentsBinding().getKey(comment);
        int bestFollowingNodeStart = Integer.MAX_VALUE;
        int bestFollowingNodeEnd = Integer.MIN_VALUE;
        int bestEnclosingNodeStart = Integer.MIN_VALUE;
        int bestEnclosingNodeEnd = Integer.MAX_VALUE;
        for (ASTNode jdtNode : visitor.getBijectiveMap().getKeys()) {
            org.eclipse.gmt.modisco.java.ASTNode modiscoNode = visitor.getBijectiveMap().get(jdtNode);
            if (!CommentsManager.mayOwnComment(jdtNode) || modiscoNode instanceof PendingElement) continue;
            int sp = jdtNode.getStartPosition();
            int ep = jdtNode.getStartPosition() + jdtNode.getLength();
            if (sp >= jdtComment.getStartPosition() + jdtComment.getLength() && (sp < bestFollowingNodeStart || sp == bestFollowingNodeStart && ep > bestFollowingNodeEnd) && sp < bestEnclosingNodeEnd) {
                bestFollowingNodeStart = sp;
                bestFollowingNodeEnd = ep;
                bestParent = modiscoNode;
                comment.setEnclosedByParent(false);
                comment.setPrefixOfParent(true);
            }
            if (sp > jdtComment.getStartPosition() || ep <= jdtComment.getStartPosition() || ep >= bestFollowingNodeStart || ep > bestEnclosingNodeEnd || sp < bestEnclosingNodeStart) continue;
            bestEnclosingNodeEnd = ep;
            bestEnclosingNodeStart = sp;
            bestParent = modiscoNode;
            comment.setEnclosedByParent(true);
            comment.setPrefixOfParent(false);
        }
        if (bestParent != null) {
            if (bestParent instanceof Package) {
                bestParent = moDiscoCuNode;
                comment.setEnclosedByParent(false);
                comment.setPrefixOfParent(true);
            }
            CommentsManager.attachComment(comment, jdtComment, (org.eclipse.gmt.modisco.java.ASTNode)bestParent, visitor);
            return true;
        }
        return false;
    }

    private static void attachComment(Comment comment, ASTNode jdtComment, org.eclipse.gmt.modisco.java.ASTNode receiver, JDTVisitor visitor) {
        if (receiver.getComments().contains((Object)comment)) {
            return;
        }
        int insertIndex = 0;
        while (insertIndex < receiver.getComments().size()) {
            ASTNode jdtOtherComment = visitor.getCommentsBinding().getKey((Comment)receiver.getComments().get(insertIndex));
            if (jdtOtherComment != null && jdtOtherComment.getStartPosition() > jdtComment.getStartPosition()) break;
            ++insertIndex;
        }
        receiver.getComments().add(insertIndex, (Object)comment);
    }

    private static boolean mayOwnComment(ASTNode element) {
        return !(element instanceof org.eclipse.jdt.core.dom.Comment) && !(element instanceof TagElement) && !(element instanceof TextElement) && !(element instanceof MemberRef) && !(element instanceof MethodRef);
    }
}

