/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.composition.discoverer.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.eclipse.modisco.java.composition.javaapplication.JavaapplicationFactory;
import org.eclipse.modisco.kdm.source.extension.discovery.SourceVisitListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompositionSourceVisitListener
implements SourceVisitListener {
    private Map<CompilationUnit, List<JavaNodeSourceRegion>> compilationUnitMap;

    public JavaCompositionSourceVisitListener(Map<CompilationUnit, List<JavaNodeSourceRegion>> compilationUnitMap) {
        this.compilationUnitMap = compilationUnitMap;
    }

    public void sourceRegionVisited(String filePath, int startPosition, int endPosition, int startLine, int endLine, EObject targetNode) {
        CompilationUnit parent = this.getCuParent(targetNode);
        JavaNodeSourceRegion javaSrcRegion = JavaapplicationFactory.eINSTANCE.createJavaNodeSourceRegion();
        javaSrcRegion.setStartPosition(new Integer(startPosition));
        javaSrcRegion.setEndPosition(new Integer(endPosition));
        javaSrcRegion.setStartLine(new Integer(startLine));
        javaSrcRegion.setEndLine(new Integer(endLine));
        javaSrcRegion.setNode(targetNode);
        if (parent != null) {
            if (this.compilationUnitMap.get(parent) == null) {
                ArrayList<JavaNodeSourceRegion> list = new ArrayList<JavaNodeSourceRegion>();
                list.add(javaSrcRegion);
                this.compilationUnitMap.put(parent, list);
            } else {
                this.compilationUnitMap.get(parent).add(javaSrcRegion);
            }
        }
    }

    protected CompilationUnit getCuParent(EObject targetNode) {
        CompilationUnit cu = null;
        if (targetNode instanceof ASTNode && (cu = ((ASTNode)targetNode).getOriginalCompilationUnit()) == null && targetNode.eContainer() != null) {
            cu = this.getCuParent(targetNode.eContainer());
        }
        return cu;
    }

    protected Map<CompilationUnit, List<JavaNodeSourceRegion>> getCompilationUnitMap() {
        return this.compilationUnitMap;
    }
}

