/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.api;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSet;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IProjectSetSerializer
implements ISerializer<IProjectSet> {
    public Class<IProjectSet> getType() {
        return IProjectSet.class;
    }

    public String serialize(IProjectSet value) {
        StringBuilder sb = new StringBuilder("");
        for (IProject iproject : value.getProjects()) {
            sb.append(iproject.getFullPath().toPortableString());
            sb.append("|");
        }
        return sb.toString();
    }

    public IProjectSet deserialize(String serializedValue) {
        IProjectSet result = IProjectSetFactory.INSTANCE.createProjectSet();
        String[] stringArray = serializedValue.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IResource proj = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (proj instanceof IProject) {
                result.add((IProject)proj);
            }
            ++n2;
        }
        return result;
    }
}

