/*******************************************************************************
* Copyright (c) 2006 Eclipse.org
* 
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.gmf.internal.xpand.parser;

public class XpandLexerprs implements lpg.lpgjavaruntime.ParseTable, XpandLexersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,3,3,1,3,1,1,1,1,1,
            2,2,1,1,1,1,1,2,2,2,
            2,1,1,1,1,2,1,1,1,2,
            1,1,1,1,5,1,1,2,3,1,
            2,2,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,2,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,2,2,1,1,1,1,1,
            1,1,1,1,1,1,1,1,3,2,
            2,0,1,2,1,2,0,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,6,2,2,2,2,2,2,2,2,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,3,0,2,1,1,
            1,1,1,0,1,12,0,2,3,4,
            5,6,7,8,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,2
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            20,20,20,20,20,20,20,20,20,20,
            20,20,20,20,20,20,20,20,20,20,
            20,20,20,20,20,20,20,20,20,20,
            20,20,20,20,20,20,20,16,16,21,
            14,14,14,5,5,5,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,2,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,1,1,
            1,1,1,1,1,1,1,1,4,4,
            4,4,4,22,22,6,6,6,6,6,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,6,25,25,26,26,26,26,
            26,26,26,26,26,10,10,10,10,23,
            23,23,23,24,24,17,17,15,15,12,
            12,12,12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,11,11,11,
            11,11,11,13,13,13,13,13,13,13,
            13,9,9,9,9,9,9,9,9,9,
            9,9,9,8,8,20,20,27,27,29,
            29,29,29,29,28,28,20,30,30,30,
            30,30,30,30,30,32,32,7,7,7,
            7,7,7,7,7,7,7,18,18,33,
            33,34,34,35,35,36,36,19,19,19,
            19,19,19,19,19,19,19,19,19,19,
            19,19,19,19,19,19,19,19,19,19,
            19,19,37,37,37,37,37,37,37,37,
            37,37,37,37,37,37,37,37,37,37,
            37,37,37,37,37,37,37,38,38,38,
            38,38,38,38,38,38,38,38,38,38,
            38,38,38,38,38,38,38,38,38,38,
            38,38,39,39,39,39,39,39,39,39,
            39,39,39,39,39,39,39,39,39,39,
            39,39,39,39,39,39,39,40,40,40,
            40,40,40,40,40,40,40,40,40,40,
            40,40,40,40,40,40,40,40,40,40,
            40,40,31,31,1840,37,43,44,113,40,
            205,105,156,43,44,158,155,157,579,2158,
            417,230,1266,114,426,6,409,2166,38,551,
            1644,198,43,44,1163,197,1935,401,2160,226,
            228,165,199,201,2167,472,2190,476,1644,198,
            43,44,467,197,2178,38,2194,456,2195,165,
            199,201,2161,482,2193,476,1342,156,43,44,
            158,155,157,2196,2159,1640,161,1,248,255,
            246,250,2202,249,245,2179,1742,198,43,44,
            490,197,2203,2205,1816,1830,2206,166,199,201,
            1442,156,43,44,158,155,157,1718,485,238,
            159,209,248,255,2204,250,1930,249,257,312,
            248,255,2209,250,624,249,259,624,624,239,
            258,415,248,255,624,250,624,249,261,518,
            248,255,624,250,624,249,263,624,624,624,
            624,624,240,621,248,255,260,250,624,249,
            257,1542,147,43,44,241,146,151,624,262,
            624,243,258,624,242,1136,248,255,264,250,
            624,249,265,2009,37,43,44,145,40,1944,
            42,43,44,624,41,624,624,590,624,444,
            2074,42,43,44,624,41,624,624,2139,223,
            624,244,2139,223,624,266,602,224,2139,223,
            608,224,2139,223,624,624,612,224,624,624,
            202,224,624,624
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,101,102,103,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,99,0,101,102,103,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,97,98,99,100,101,
            102,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,100,101,102,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,99,100,101,102,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,91,92,
            93,94,95,96,97,98,99,100,101,102,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,101,102,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            97,98,99,100,101,102,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,100,101,102,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,100,
            101,102,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,99,100,101,102,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,0,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,97,98,99,100,101,102,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,0,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,97,98,99,100,101,
            102,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,0,
            1,0,101,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,0,0,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,14,0,90,91,92,93,94,95,96,
            97,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,0,0,75,76,77,78,
            79,80,81,82,83,84,85,86,87,0,
            1,90,91,92,93,94,95,96,97,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,100,77,78,79,80,
            81,82,83,84,85,86,87,88,89,0,
            1,0,103,0,0,0,0,98,99,100,
            0,0,103,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,0,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,104,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,0,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,0,0,0,
            0,23,24,25,26,0,0,2,3,4,
            5,6,7,8,9,10,11,0,0,2,
            3,4,5,6,7,8,9,10,11,0,
            12,13,0,0,0,0,30,19,20,21,
            22,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,30,
            0,0,65,30,30,0,66,68,0,71,
            72,27,29,28,69,27,27,0,0,0,
            0,0,0,0,0,88,89,0,0,0,
            0,73,74,0,76,98,99,0,0,67,
            0,0,0,0,0,70,0,0,0,0,
            0,0,0,0,73,0,74,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,100,0,0,0,
            0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            624,700,722,723,724,725,726,727,728,729,
            730,731,671,675,699,670,672,673,674,683,
            687,689,690,696,697,698,701,708,709,713,
            765,676,677,678,679,680,681,682,684,685,
            686,688,691,692,693,694,695,880,702,703,
            704,705,706,707,710,711,712,714,715,716,
            717,718,719,720,721,732,755,749,751,762,
            764,877,876,743,753,744,754,756,757,758,
            759,760,761,763,739,740,741,742,735,736,
            748,745,746,747,766,767,750,752,733,734,
            875,878,871,501,234,700,722,723,724,725,
            726,727,728,729,730,731,671,675,699,670,
            672,673,674,683,687,689,690,696,697,698,
            701,708,709,713,765,676,677,678,679,680,
            681,682,684,685,686,688,691,692,693,694,
            695,669,702,703,704,705,706,707,710,711,
            712,714,715,716,717,718,719,720,721,732,
            755,749,751,762,764,856,855,743,753,744,
            754,756,757,758,759,760,761,763,739,740,
            741,742,735,736,748,745,746,747,766,767,
            750,752,733,734,227,857,853,859,392,2050,
            722,723,724,725,726,727,728,729,730,731,
            671,675,894,670,672,673,674,683,687,689,
            690,891,892,893,895,902,903,907,765,676,
            677,678,679,680,681,682,684,685,686,688,
            691,692,693,694,695,880,896,897,898,899,
            900,901,904,905,906,908,909,910,911,912,
            913,914,915,732,755,749,751,762,764,877,
            876,743,753,744,754,756,757,758,759,760,
            761,763,739,740,741,742,735,736,748,745,
            746,747,766,767,750,752,733,734,875,878,
            871,624,920,722,723,724,725,726,727,728,
            729,730,731,671,675,919,670,672,673,674,
            683,687,689,690,916,917,918,921,928,521,
            932,765,676,677,678,679,680,681,682,684,
            685,686,688,691,692,693,694,695,880,922,
            923,924,925,926,927,929,930,931,933,934,
            935,936,937,938,939,940,732,755,749,751,
            762,764,877,876,743,753,744,754,756,757,
            758,759,760,761,763,739,740,741,742,735,
            736,748,745,746,747,766,767,750,752,733,
            734,875,878,871,624,944,722,723,724,725,
            726,727,728,729,730,731,671,675,529,670,
            672,673,674,683,687,689,690,941,942,943,
            945,952,953,957,765,676,677,678,679,680,
            681,682,684,685,686,688,691,692,693,694,
            695,880,946,947,948,949,950,951,954,955,
            956,958,959,960,961,962,963,964,965,732,
            755,749,751,762,764,877,876,743,753,744,
            754,756,757,758,759,760,761,763,739,740,
            741,742,735,736,748,745,746,747,766,767,
            750,752,733,734,875,878,871,624,970,722,
            723,724,725,726,727,728,729,730,731,671,
            675,969,670,672,673,674,683,687,689,690,
            966,967,968,971,978,979,543,765,676,677,
            678,679,680,681,682,684,685,686,688,691,
            692,693,694,695,880,972,973,974,975,976,
            977,980,981,982,983,984,985,986,987,988,
            989,990,732,755,749,751,762,764,877,876,
            743,753,744,754,756,757,758,759,760,761,
            763,739,740,741,742,735,736,748,745,746,
            747,766,767,750,752,733,734,875,878,871,
            624,565,722,723,724,725,726,727,728,729,
            730,731,671,675,894,670,672,673,674,683,
            687,689,690,891,892,893,895,902,903,907,
            765,676,677,678,679,680,681,682,684,685,
            686,688,691,692,693,694,695,880,896,897,
            898,899,900,901,904,905,906,908,909,910,
            911,912,913,914,915,732,755,749,751,762,
            764,877,876,743,753,744,754,756,757,758,
            759,760,761,763,739,740,741,742,735,736,
            748,745,746,747,766,767,750,752,733,734,
            875,878,871,624,2256,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,624,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,1741,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,624,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,1844,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,624,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            1947,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,624,995,722,723,724,
            725,726,727,728,729,730,731,671,675,994,
            670,672,673,674,683,687,689,690,991,992,
            993,996,162,1003,1007,765,676,677,678,679,
            680,681,682,684,685,686,688,691,692,693,
            694,695,880,997,998,999,1000,1001,1002,1004,
            1005,1006,1008,1009,1010,1011,1012,1013,1014,1015,
            732,755,749,751,762,764,877,876,743,753,
            744,754,756,757,758,759,760,761,763,739,
            740,741,742,735,736,748,745,746,747,766,
            767,750,752,733,734,875,878,871,392,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,237,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,509,509,509,509,509,509,509,509,509,
            509,624,700,722,723,724,725,726,727,728,
            729,730,731,671,675,699,670,672,673,674,
            683,687,689,690,696,697,698,701,708,709,
            713,765,676,677,678,679,680,681,682,684,
            685,686,688,691,692,693,694,695,669,702,
            703,704,705,706,707,710,711,712,714,715,
            716,717,718,719,720,721,732,755,749,751,
            762,764,784,787,743,753,744,754,756,757,
            758,759,760,761,763,739,740,741,742,735,
            736,748,745,746,747,766,767,750,752,733,
            734,624,700,722,723,724,725,726,727,728,
            729,730,731,671,675,699,670,672,673,674,
            683,687,689,690,696,697,698,701,708,709,
            713,765,676,677,678,679,680,681,682,684,
            685,686,688,691,692,693,694,695,669,702,
            703,704,705,706,707,710,711,712,714,715,
            716,717,718,719,720,721,732,755,749,751,
            762,764,659,788,743,753,744,754,756,757,
            758,759,760,761,763,739,740,741,742,735,
            736,748,745,746,747,766,767,750,752,733,
            734,36,700,722,723,724,725,726,727,728,
            729,730,731,671,675,699,670,672,673,674,
            683,687,689,690,696,697,698,701,708,709,
            713,765,676,677,678,679,680,681,682,684,
            685,686,688,691,692,693,694,695,669,702,
            703,704,705,706,707,710,711,712,714,715,
            716,717,718,719,720,721,772,755,749,751,
            762,764,774,773,743,753,744,754,756,757,
            758,759,760,761,763,739,740,741,742,776,
            777,748,745,746,747,766,767,750,752,89,
            3227,624,778,167,700,722,723,724,725,726,
            727,728,729,730,731,671,675,699,670,672,
            673,674,683,687,689,690,696,697,698,701,
            708,709,713,818,676,677,678,679,680,681,
            682,684,685,686,688,691,692,693,694,695,
            669,702,703,704,705,706,707,710,711,712,
            714,715,716,717,718,719,720,721,824,808,
            804,806,815,817,795,798,624,624,799,475,
            809,810,811,812,813,814,816,793,794,796,
            797,504,624,803,800,801,802,819,820,805,
            807,168,700,722,723,724,725,726,727,728,
            729,730,731,671,675,699,670,672,673,674,
            683,687,689,690,696,697,698,701,708,709,
            713,818,676,677,678,679,680,681,682,684,
            685,686,688,691,692,693,694,695,669,702,
            703,704,705,706,707,710,711,712,714,715,
            716,717,718,719,720,721,824,808,804,806,
            815,817,795,798,624,624,799,475,809,810,
            811,812,813,814,816,793,794,796,797,624,
            486,803,800,801,802,819,820,805,807,624,
            700,722,723,724,725,726,727,728,729,730,
            731,671,675,699,670,672,673,674,683,687,
            689,690,696,697,698,701,708,709,465,434,
            676,677,678,679,680,681,682,684,685,686,
            688,691,692,693,694,695,669,702,703,704,
            705,706,707,710,711,712,714,715,716,717,
            718,719,720,721,732,452,454,428,655,446,
            464,633,420,438,448,412,648,649,646,647,
            657,652,436,631,463,638,639,735,736,624,
            512,624,1017,624,624,624,624,733,734,400,
            624,624,849,1,700,722,723,724,725,726,
            727,728,729,730,731,671,675,699,670,672,
            673,674,683,687,689,690,696,697,698,701,
            708,709,713,624,676,677,678,679,680,681,
            682,684,685,686,688,691,692,693,694,695,
            669,702,703,704,705,706,707,710,711,712,
            714,715,716,717,718,719,720,721,624,700,
            722,723,724,725,726,727,728,729,730,731,
            671,675,699,670,672,673,674,683,687,689,
            690,696,697,698,701,708,709,713,623,676,
            677,678,679,680,681,682,684,685,686,688,
            691,692,693,694,695,669,702,703,704,705,
            706,707,710,711,712,714,715,716,717,718,
            719,720,721,5,700,722,723,724,725,726,
            727,728,729,730,731,671,675,699,670,672,
            673,674,683,687,689,690,696,697,698,701,
            708,709,713,624,676,677,678,679,680,681,
            682,684,685,686,688,691,692,693,694,695,
            669,702,703,704,705,706,707,710,711,712,
            714,715,716,717,718,719,720,721,624,845,
            722,723,724,725,726,727,728,729,730,731,
            836,840,844,835,837,838,839,34,10,29,
            27,841,842,843,846,4,32,722,723,724,
            725,726,727,728,729,730,731,39,624,722,
            723,724,725,726,727,728,729,730,731,17,
            827,830,624,16,13,8,642,829,831,828,
            598,624,624,624,624,624,89,624,624,89,
            624,624,624,624,624,624,624,624,624,644,
            624,624,732,643,645,624,636,654,624,768,
            424,484,506,497,573,860,3224,624,624,624,
            624,624,624,624,624,735,736,624,624,624,
            624,832,833,624,834,733,734,624,624,635,
            624,624,624,624,624,650,624,624,624,624,
            624,624,624,624,627,624,626,624,624,624,
            624,624,624,624,624,624,624,624,624,624,
            624,624,624,624,624,624,624,624,624,624,
            624,624,624,624,624,624,483
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int getErrorSymbol() { return 0; }
    public final int getScopeUbound() { return 0; }
    public final int getScopeSize() { return 0; }
    public final int getMaxNameLength() { return 0; }

    public final static int
           NUM_STATES        = 50,
           NT_OFFSET         = 105,
           LA_STATE_OFFSET   = 1017,
           MAX_LA            = 6,
           NUM_RULES         = 393,
           NUM_NONTERMINALS  = 41,
           NUM_SYMBOLS       = 146,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 394,
           IDENTIFIER_SYMBOL = 0,
           EOFT_SYMBOL       = 104,
           EOLT_SYMBOL       = 106,
           ACCEPT_ACTION     = 623,
           ERROR_ACTION      = 624;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
