/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInitializerTest
extends RuntimeDiagramTestBase {
    private EObject nodeAElement;
    private EObject nodeBElement;

    public ElementInitializerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Node nodeA = this.createNode((GenCommonBase)this.getGenModel().getNodeA(), (View)this.getDiagram());
        this.nodeAElement = nodeA.getElement();
        Node nodeB = this.createNode((GenCommonBase)this.getGenModel().getNodeB(), (View)this.getDiagram());
        this.nodeBElement = nodeB.getElement();
        ElementInitializerTest.assertNotNull((String)"Tested node A element not available", (Object)this.nodeAElement);
        ElementInitializerTest.assertNotNull((String)"Tested node B element not available", (Object)this.nodeBElement);
    }

    public void testNewElementInitializer() throws Exception {
        EStructuralFeature feature = this.nodeAElement.eClass().getEStructuralFeature("refNewElement");
        ElementInitializerTest.assertNotNull((String)"feature not found in the intializer class", (Object)feature);
        Object val = this.nodeAElement.eGet(feature);
        ElementInitializerTest.assertTrue((boolean)(val instanceof EClass));
        EClass newEClass = (EClass)val;
        ElementInitializerTest.assertEquals((String)"Only one attribute expected", (int)1, (int)newEClass.getEAllAttributes().size());
        EAttribute attribute = (EAttribute)newEClass.getEAllAttributes().iterator().next();
        ElementInitializerTest.assertEquals((String)"attribute should be named by its EClass name", (String)attribute.eClass().getName(), (String)attribute.getName());
        ElementInitializerTest.assertEquals((String)"attribute must be of String type", (Object)EcorePackage.eINSTANCE.getEString(), (Object)attribute.getEType());
        ElementInitializerTest.assertEquals((String)"Only one operation expected", (int)1, (int)newEClass.getEOperations().size());
        EOperation operation = (EOperation)newEClass.getEOperations().iterator().next();
        ElementInitializerTest.assertEquals((String)"operation should be named by its metaclass", (String)operation.eClass().getName(), (String)operation.getName());
        EClass expectedType = this.nodeAElement.eClass();
        ElementInitializerTest.assertEquals((String)"operation should return type of its containing class", (Object)expectedType, (Object)operation.getEType());
    }

    public void testSeveralNewElementInitializers() {
        EStructuralFeature feature = this.nodeAElement.eClass().getEStructuralFeature("nestedNodes1");
        ElementInitializerTest.assertNotNull((String)"feature not found in the intializer class", (Object)feature);
        Object val = this.nodeAElement.eGet(feature);
        ElementInitializerTest.assertTrue((boolean)(val instanceof Collection));
        Collection children = (Collection)val;
        ElementInitializerTest.assertEquals((String)"2 child nodes expected", (int)2, (int)children.size());
        int index = 0;
        for (Object nextChild : children) {
            ElementInitializerTest.assertTrue((String)"Incorrect child present", (boolean)(nextChild instanceof EObject));
            EObject nextEObject = (EObject)nextChild;
            EStructuralFeature nameFeature = nextEObject.eClass().getEStructuralFeature("name");
            ElementInitializerTest.assertNotNull((String)"feature 'name' was not found in child node", (Object)nameFeature);
            Object name = nextEObject.eGet(nameFeature);
            ElementInitializerTest.assertTrue((String)"Incorrect name value returned", (boolean)(name instanceof String));
            ElementInitializerTest.assertEquals((String)"Name feature was not correctly initialized", (String)(String.valueOf(nextEObject.eClass().getName()) + "_" + index), (String)((String)name));
            ++index;
        }
    }

    public void testDeepNewElementInitializers() {
        EObject child = this.getFirstChildNode1(this.nodeAElement);
        child = this.getFirstChildNode1(child);
        child = this.getFirstChildNode1(child);
        child = this.getFirstChildNode1(child);
        child = this.getFirstChildNode1(child);
    }

    private EObject getFirstChildNode1(EObject parent) {
        EStructuralFeature feature = parent.eClass().getEStructuralFeature("nestedNodes1");
        ElementInitializerTest.assertNotNull((String)"feature not found in the intializer class", (Object)feature);
        Object val = parent.eGet(feature);
        ElementInitializerTest.assertTrue((boolean)(val instanceof Collection));
        Collection children = (Collection)val;
        ElementInitializerTest.assertTrue((String)"At least one child node expected", (children.size() > 0 ? 1 : 0) != 0);
        Object child = children.iterator().next();
        ElementInitializerTest.assertTrue((String)"Child element dhould be EObject", (boolean)(child instanceof EObject));
        return (EObject)child;
    }

    public void testJavaInitializers() throws Exception {
        Class<?> javaContainerClass = this.loadJavaContainerClass();
        ElementInitializerTest.assertNotNull((String)"Could not find generated java initializer class", javaContainerClass);
        GenJavaExpressionProvider javaProvider = null;
        GenExpressionProviderContainer container = this.getGenModel().getGenDiagram().getEditorGen().getExpressionProviders();
        for (GenExpressionProviderBase nextProvider : container.getProviders()) {
            if (!(nextProvider instanceof GenJavaExpressionProvider)) continue;
            javaProvider = (GenJavaExpressionProvider)nextProvider;
        }
        ElementInitializerTest.assertNotNull(javaProvider);
        boolean primitiveTypeAttrTested = false;
        boolean objValTypeAttrTested = false;
        boolean refTested = false;
        boolean multiValPrimitiveTypeAttrTested = false;
        boolean multiObjValTypeAttrTested = false;
        boolean multiRefTested = false;
        TreeIterator it = this.getGenModel().getGenDiagram().eAllContents();
        while (it.hasNext()) {
            Object element = it.next();
            if (!(element instanceof GenFeatureSeqInitializer)) continue;
            GenFeatureSeqInitializer fsInitializer = (GenFeatureSeqInitializer)element;
            for (GenFeatureInitializer featureInitializer : fsInitializer.getInitializers()) {
                GenFeatureValueSpec nextFtValSpec;
                if (!(featureInitializer instanceof GenFeatureValueSpec) || (nextFtValSpec = (GenFeatureValueSpec)featureInitializer).getValue().getProvider() != javaProvider) continue;
                GenCommonBase diagramElement = null;
                if (fsInitializer.getTypeModelFacet().eContainer() instanceof GenCommonBase) {
                    diagramElement = (GenCommonBase)fsInitializer.getTypeModelFacet().eContainer();
                }
                if (diagramElement == null) continue;
                String operationName = String.valueOf(nextFtValSpec.getFeature().getEcoreFeature().getName()) + "_" + diagramElement.getUniqueIdentifier();
                Method method = this.findMethod(javaContainerClass, operationName, fsInitializer.getElementClass());
                ElementInitializerTest.assertNotNull((String)("Can't find Java method:" + operationName), (Object)method);
                GenFeature genFeature = nextFtValSpec.getFeature();
                if (genFeature.isPrimitiveType() && !genFeature.isListType()) {
                    ElementInitializerTest.assertTrue((String)"Use wrapper class for primitive return type", (!method.getReturnType().isPrimitive() && genFeature.isPrimitiveType() ? 1 : 0) != 0);
                    ElementInitializerTest.assertEquals(method.getReturnType(), (Object)EcoreUtil.wrapperClassFor((Class)genFeature.getEcoreFeature().getEType().getInstanceClass()));
                    primitiveTypeAttrTested = true;
                    continue;
                }
                if (!genFeature.isReferenceType() && genFeature.getEcoreFeature().isMany() && genFeature.getEcoreFeature().getEType().getInstanceClass().isPrimitive()) {
                    ElementInitializerTest.assertEquals((String)List.class.getName(), (String)method.getReturnType().getName());
                    multiValPrimitiveTypeAttrTested = true;
                    continue;
                }
                if (!(genFeature.isReferenceType() || genFeature.isPrimitiveType() || genFeature.isListType())) {
                    ElementInitializerTest.assertEquals((String)genFeature.getType(), (String)method.getReturnType().getName());
                    objValTypeAttrTested = true;
                    continue;
                }
                if (!genFeature.isReferenceType() && !genFeature.isPrimitiveType() && genFeature.isListType()) {
                    ElementInitializerTest.assertEquals((String)List.class.getName(), (String)method.getReturnType().getName());
                    multiObjValTypeAttrTested = true;
                    continue;
                }
                if (genFeature.isReferenceType() && !genFeature.isListType()) {
                    ElementInitializerTest.assertEquals((String)genFeature.getTypeGenClass().getQualifiedInterfaceName(), (String)method.getReturnType().getName());
                    refTested = true;
                    continue;
                }
                if (!genFeature.isReferenceType() || !genFeature.isListType()) continue;
                ElementInitializerTest.assertEquals((String)List.class.getName(), (String)method.getReturnType().getName());
                multiRefTested = true;
            }
        }
        ElementInitializerTest.assertTrue((boolean)primitiveTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)objValTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)refTested);
        ElementInitializerTest.assertTrue((boolean)multiValPrimitiveTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)multiObjValTypeAttrTested);
        ElementInitializerTest.assertTrue((boolean)multiRefTested);
    }

    protected Class<?> loadJavaContainerClass() {
        try {
            return this.loadGeneratedClass(String.valueOf(this.getGenModel().getGenDiagram().getProvidersPackageName()) + ".ElementInitializers");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void testAttrMany() throws Exception {
        EStructuralFeature attrManyFeature = this.nodeBElement.eClass().getEStructuralFeature("integers_Init");
        ElementInitializerTest.assertNotNull((String)"field not found in tested class", (Object)attrManyFeature);
        Object value = this.nodeBElement.eGet(attrManyFeature);
        ElementInitializerTest.assertEquals((Object)value, Arrays.asList(new Integer(10), new Integer(20)));
    }

    public void testReferenceToMany() throws Exception {
        EStructuralFeature refToManyFeature = this.nodeAElement.eClass().getEStructuralFeature("reference_Init");
        ElementInitializerTest.assertNotNull((String)"field not found in tested class", (Object)refToManyFeature);
        Object value = this.nodeAElement.eGet(refToManyFeature);
        ElementInitializerTest.assertEquals((Object)value, Arrays.asList(this.nodeAElement));
    }

    public void testEnumLiteralAttr() throws Exception {
        EStructuralFeature enumField = this.nodeAElement.eClass().getEStructuralFeature("enumAttr_Init");
        ElementInitializerTest.assertNotNull((String)"enum field not found in tested class", (Object)enumField);
        ElementInitializerTest.assertTrue((boolean)(enumField.getEType() instanceof EEnum));
        EEnum testEnum = (EEnum)enumField.getEType();
        EEnumLiteral literal = testEnum.getEEnumLiteral("LIT1");
        Object literalValue = this.nodeAElement.eGet(enumField);
        ElementInitializerTest.assertNotNull((Object)literalValue);
        ElementInitializerTest.assertFalse((String)"Should be set to different from default", (boolean)literalValue.equals(enumField.getDefaultValue()));
        ElementInitializerTest.assertSame((String)"Expected literal set by initializer", (Object)literal.getInstance(), (Object)literalValue);
    }

    public void testManyEnumLiteralAttr() throws Exception {
        EStructuralFeature enumField = this.nodeAElement.eClass().getEStructuralFeature("manyEnumAttr_Init");
        ElementInitializerTest.assertNotNull((String)"enum field not found in tested class", (Object)enumField);
        ElementInitializerTest.assertTrue((boolean)(enumField.getEType() instanceof EEnum));
        EEnum testEnum = (EEnum)enumField.getEType();
        ArrayList<Enumerator> expectedValues = new ArrayList<Enumerator>();
        expectedValues.add(this.getEnumLiteralInstance(testEnum, "LIT0"));
        expectedValues.add(this.getEnumLiteralInstance(testEnum, "LIT1"));
        Object literalValues = this.nodeAElement.eGet(enumField);
        ElementInitializerTest.assertTrue((boolean)(literalValues instanceof Collection));
        Collection retrivedValues = (Collection)literalValues;
        ElementInitializerTest.assertEquals(expectedValues, (Object)retrivedValues);
    }

    public void testManyRealAttr() throws Exception {
        EStructuralFeature realField = this.nodeAElement.eClass().getEStructuralFeature("manyRealAttr_Init");
        ElementInitializerTest.assertNotNull((String)"Float type attribute not found in tested class", (Object)realField);
        Object realValues = this.nodeAElement.eGet(realField);
        ElementInitializerTest.assertTrue((boolean)(realValues instanceof Collection));
        Collection retrivedValues = (Collection)realValues;
        ArrayList<Float> expectedValues = new ArrayList<Float>();
        expectedValues.add(new Float(1.0));
        expectedValues.add(new Float(1.5));
        ElementInitializerTest.assertEquals(expectedValues, (Object)retrivedValues);
    }

    private Enumerator getEnumLiteralInstance(EEnum eEnum, String literalName) {
        EEnumLiteral literal = eEnum.getEEnumLiteral(literalName);
        ElementInitializerTest.assertNotNull((String)"Enum literal not found", (Object)literal);
        ElementInitializerTest.assertNotNull((String)"Enum literal has no instance", (Object)literal.getInstance());
        return literal.getInstance();
    }

    private Method findMethod(Class<?> clazz, String methodName, GenClass contextClass) {
        try {
            Object[] params = new Class[]{this.loadGeneratedClass(contextClass.getQualifiedInterfaceName())};
            int i = 0;
            while (i < clazz.getDeclaredMethods().length) {
                Method method = clazz.getDeclaredMethods()[i];
                if (method.getName().equals(methodName) && Arrays.equals(params, method.getParameterTypes())) {
                    return method;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            ElementInitializerTest.fail((String)("Expected class not generated. " + e.toString()));
        }
        return null;
    }
}

