/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.AbstractCanvasTest;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.figures.GenericFigureCheck;
import org.eclipse.swt.graphics.RGB;

public class DiagramNodeTest
extends GeneratedCanvasTest {
    private final GenericFigureCheck.ColorTransformer ourColorTransformer = new GenericFigureCheck.ColorTransformer();
    private final Point myMoveDelta = new Point(10, 20);
    private final Dimension mySizeDelta = new Dimension(100, 50);

    public DiagramNodeTest(String name) {
        super(name);
    }

    public void testCanCreateLink() {
        Node nodeA = this.getNotation(this.getNodeEditPartA());
        Node nodeB = this.getNotation(this.getNodeEditPartB());
        ConnectionEditPart linkByClass = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkC());
        DiagramNodeTest.assertNotNull((Object)linkByClass);
        nodeB = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        ConnectionEditPart linkByRef = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkD());
        DiagramNodeTest.assertNotNull((Object)linkByRef);
    }

    public void testNotColoredLink() {
        Node nodeA = this.getNotation(this.getNodeEditPartA());
        Node nodeB = this.getNotation(this.getNodeEditPartB());
        ConnectionEditPart linkByClass = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkC());
        this.checkLinkColor(linkByClass, this.getSetup().getMapModel().getClassLink().getDiagramLink());
    }

    public void testColoredLink() {
        Node nodeA = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)this.getDiagram());
        Node nodeB = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        ConnectionEditPart linkByRef = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkD());
        this.checkLinkColor(linkByRef, this.getSetup().getMapModel().getReferenceLink().getDiagramLink());
    }

    public void testLabelFonts() {
        class FontChecker
        extends GenericFigureCheck {
            public FontChecker() {
                super(null);
            }

            public void createAndCheckLabels(GenNode prototype, DiagramLabel eLabel, View notationContainer) {
                FontChecker.assertFalse((boolean)prototype.getLabels().isEmpty());
                Node node = DiagramNodeTest.this.createNode((GenCommonBase)prototype, notationContainer);
                for (GenNodeLabel nextLabelType : prototype.getLabels()) {
                    View notationLabel = DiagramNodeTest.access$1((View)node, (GenCommonBase)nextLabelType);
                    FontChecker.assertNotNull((Object)notationLabel);
                    GraphicalEditPart labelEditPart = (GraphicalEditPart)DiagramNodeTest.this.findEditPart(notationLabel);
                    FontChecker.assertNotNull((Object)labelEditPart);
                    this.checkFont(labelEditPart, eLabel.getFigure().getActualFigure());
                }
            }

            public void checkFont(GraphicalEditPart editPart, Figure eFigure) {
                IFigure d2dFgure = editPart.getFigure();
                FontChecker.assertNotNull((Object)d2dFgure);
                Font font = eFigure.getFont();
                if (font == null) {
                    font = DiagramNodeTest.this.getViewerConfiguration().getDefaultFont();
                }
                this.checkFont(font, d2dFgure.getFont());
            }
        }
        FontChecker fontChecker = new FontChecker();
        DiaGenSource gmfGen = this.getSetup().getGenModel();
        DiaDefSetup gmfGraph = (DiaDefSetup)this.getSetup().getGraphDefModel();
        fontChecker.createAndCheckLabels(gmfGen.getNodeB(), gmfGraph.getDecoratedLabelDef(), (View)this.getDiagram());
    }

    private ConnectionEditPart createAndCheckLink(View source, View target, GenLink genLinkType) {
        Edge newLink = this.createLink(genLinkType, source, target);
        DiagramNodeTest.assertNotNull((Object)newLink);
        DiagramNodeTest.assertEquals((Object)source, (Object)newLink.getSource());
        DiagramNodeTest.assertEquals((Object)target, (Object)newLink.getTarget());
        this.getDiagramEditPart().refresh();
        ConnectionEditPart newLinkEditPart = (ConnectionEditPart)this.findEditPart((View)newLink);
        DiagramNodeTest.assertNotNull((Object)newLinkEditPart);
        return newLinkEditPart;
    }

    private void checkLinkColor(ConnectionEditPart newLinkEditPart, Connection gmfGraphConnection) {
        IFigure actual = newLinkEditPart.getFigure();
        DiagramNodeTest.assertTrue((boolean)(actual instanceof PolylineConnection));
        Figure gmfFigure = gmfGraphConnection.getFigure().getActualFigure();
        Color gmfColor = gmfFigure.getForegroundColor();
        RGB expectedRGB = gmfColor == null ? this.getViewerConfiguration().getDefaultLinkColor() : this.ourColorTransformer.gmf2swt(gmfColor);
        DiagramNodeTest.assertEquals((Object)expectedRGB, (Object)actual.getForegroundColor().getRGB());
    }

    public void testChangeBounds() {
        EditPart editPart = this.getNodeEditPartA();
        Node notation = this.getNotation(editPart);
        Point originalLocation = this.getLocation(notation);
        Dimension originalSize = this.getSize(notation);
        Point expectedLocation = originalLocation.getTranslated(this.myMoveDelta);
        Dimension expectedNewSize = originalSize.getExpanded(this.mySizeDelta);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setMoveDelta(this.myMoveDelta);
        req.setSizeDelta(this.mySizeDelta);
        req.setEditParts(editPart);
        req.setResizeDirection(9);
        Command cmd = editPart.getCommand((Request)req);
        DiagramNodeTest.assertNotNull((String)"No resize command", (Object)cmd);
        DiagramNodeTest.assertTrue((String)"Can't execute resize command", (boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.assertBoundValues(notation, expectedLocation, expectedNewSize, "exec");
        DiagramNodeTest.assertTrue((String)"Can't undo resize command", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.assertBoundValues(notation, originalLocation, originalSize, "undo");
        DiagramNodeTest.assertTrue((String)"Can't redo resize command", (boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.assertBoundValues(notation, expectedLocation, expectedNewSize, "redo");
    }

    private void assertBoundValues(Node notation, Point expectedLocation, Dimension expectedSize, String assertTag) {
        DiagramNodeTest.assertEquals((String)("Location doesn't match one set after [" + assertTag + ']'), (Object)expectedLocation, (Object)this.getLocation(notation));
        DiagramNodeTest.assertEquals((String)("Size doesn't match one set after [" + assertTag + ']'), (Object)expectedSize, (Object)this.getSize(notation));
    }

    private int getForegroundColor(Node notation) {
        LineStyle ls = (LineStyle)notation.getStyle(NotationPackage.eINSTANCE.getLineStyle());
        return ls.getLineColor();
    }

    private int getBackgroundColor(Node notation) {
        FillStyle fs = (FillStyle)notation.getStyle(NotationPackage.eINSTANCE.getFillStyle());
        return fs.getFillColor();
    }

    private Dimension getSize(Node notation) {
        Size b = (Size)notation.getLayoutConstraint();
        return new Dimension(b.getWidth(), b.getHeight());
    }

    private Point getLocation(Node notation) {
        Location l = (Location)notation.getLayoutConstraint();
        return new Point(l.getX(), l.getY());
    }

    public void testChangeColors() {
        Node notation = this.getNotation(this.getNodeEditPartA());
        int originalBackgroundColor = this.getBackgroundColor(notation);
        int originalForegroundColor = this.getForegroundColor(notation);
        int newBackgroundColor = FigureUtilities.RGBToInteger((RGB)new RGB(255, 0, 0));
        int newForegroundColor = FigureUtilities.RGBToInteger((RGB)new RGB(0, 255, 255));
        assert (newBackgroundColor != originalBackgroundColor);
        assert (newForegroundColor != originalForegroundColor);
        Command foreCmd = this.createChangeColorCommand(notation, newForegroundColor, true);
        DiagramNodeTest.assertNotNull((String)"No changeForegroundColor command", (Object)foreCmd);
        DiagramNodeTest.assertTrue((String)"Can't execute changeForegroundColor command", (boolean)foreCmd.canExecute());
        this.getCommandStack().execute(foreCmd);
        this.assertColorValues(notation, newForegroundColor, originalBackgroundColor, "exec(fore)");
        DiagramNodeTest.assertTrue((String)"Can't undo changeForegroundColor command", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.assertColorValues(notation, originalForegroundColor, originalBackgroundColor, "undo(fore)");
        DiagramNodeTest.assertTrue((String)"Can't redo changeForegroundColor command", (boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.assertColorValues(notation, newForegroundColor, originalBackgroundColor, "redo(fore)");
        Command backCmd = this.createChangeColorCommand(notation, newBackgroundColor, false);
        DiagramNodeTest.assertNotNull((String)"No changeBackgroundColor command", (Object)backCmd);
        DiagramNodeTest.assertTrue((String)"Can't execute changeBackgroundColor command", (boolean)backCmd.canExecute());
        this.getCommandStack().execute(backCmd);
        this.assertColorValues(notation, newForegroundColor, newBackgroundColor, "exec(back)");
        DiagramNodeTest.assertTrue((String)"Can't undo changeBackgroundColor command", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.assertColorValues(notation, newForegroundColor, originalBackgroundColor, "undo(back)");
        DiagramNodeTest.assertTrue((String)"Can't redo changeBackgroundColor command", (boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.assertColorValues(notation, newForegroundColor, newBackgroundColor, "redo(back)");
    }

    private Command createChangeColorCommand(Node notation, int newColor, boolean isForeground) {
        return this.getViewerConfiguration().getSetNotationalElementStructuralFeature((View)notation, (EStructuralFeature)(isForeground ? NotationPackage.eINSTANCE.getLineStyle_LineColor() : NotationPackage.eINSTANCE.getFillStyle_FillColor()), new Integer(newColor));
    }

    private void assertColorValues(Node notation, int expectedForegroundColor, int expectedBackgroundColor, String assertTag) {
        DiagramNodeTest.assertEquals((String)("Foreground color doesn't match after [" + assertTag + ']'), (int)expectedForegroundColor, (int)this.getForegroundColor(notation));
        DiagramNodeTest.assertEquals((String)("Background color doesn't match after [" + assertTag + ']'), (int)expectedBackgroundColor, (int)this.getBackgroundColor(notation));
    }

    public void testCreateTopLevelNodeNotationElements() {
        GenNode genNode = this.getSetup().getGenModel().getNodeA();
        Node node = this.createNode((GenCommonBase)genNode, (View)this.getCanvasInstance().getCanvas());
        DiagramNodeTest.assertNotNull((String)"Notation model Node was not created", (Object)node);
        for (GenNodeLabel nextLabel : genNode.getLabels()) {
            DiagramNodeTest.assertNotNull((String)("Notation model element was not created for label: " + nextLabel.getVisualID()), (Object)DiagramNodeTest.findChildView((View)node, (GenCommonBase)nextLabel));
        }
        for (GenCompartment nextCompartment : genNode.getCompartments()) {
            DiagramNodeTest.assertNotNull((String)("Notation model element was not created for compartment: " + nextCompartment.getVisualID()), (Object)DiagramNodeTest.findChildView((View)node, (GenCommonBase)nextCompartment));
        }
    }

    public void testCreateLeafChildNodeNotationElements() {
        GenNode nodeA = this.getSetup().getGenModel().getNodeA();
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: passed node has no compartments", (nodeA.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)nodeA.getCompartments().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genCompartment.getChildNodes().size() > 1 ? 1 : 0) != 0);
        GenNode leafGenChildNodeLabelOnly = (GenNode)genCompartment.getChildNodes().get(1);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not leaf label-only node", (leafGenChildNodeLabelOnly.getChildNodes().size() == 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not leaf label-only node", (leafGenChildNodeLabelOnly.getCompartments().size() == 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not leaf label-only node", (leafGenChildNodeLabelOnly.getLabels().size() == 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not leaf label-only node", (boolean)(leafGenChildNodeLabelOnly instanceof GenChildLabelNode));
        Node leafNode = this.createNode((GenCommonBase)leafGenChildNodeLabelOnly, (View)this.getCanvasInstance().getNodeACompartment());
        DiagramNodeTest.assertNotNull((String)"Node was not created", (Object)leafNode);
        DiagramNodeTest.assertTrue((String)"Leaf node has children", (leafNode.getChildren().size() == 0 ? 1 : 0) != 0);
        GenNode leafGenChildNode = (GenNode)genCompartment.getChildNodes().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not leaf node", (leafGenChildNode.getChildNodes().size() == 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not leaf node", (leafGenChildNode.getCompartments().size() == 0 ? 1 : 0) != 0);
        leafNode = this.createNode((GenCommonBase)leafGenChildNode, (View)this.getCanvasInstance().getNodeACompartment());
        DiagramNodeTest.assertNotNull((String)"Node was not created", (Object)leafNode);
        for (GenNodeLabel nextLabel : leafGenChildNode.getLabels()) {
            DiagramNodeTest.assertNotNull((String)("Notation model element was not created for label: " + nextLabel.getVisualID()), (Object)DiagramNodeTest.findChildView((View)leafNode, (GenCommonBase)nextLabel));
        }
    }

    public void testCreateInnerChildNodeNotationElements() {
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: passed node has no compartments", (nodeB.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)nodeB.getCompartments().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode childNode = (GenNode)genCompartment.getChildNodes().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not level-1 child node", (childNode.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment childNodeCompartment = (GenCompartment)childNode.getCompartments().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not level-1 child node", (childNodeCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        Node level1Child = this.createNode((GenCommonBase)childNode, (View)this.getCanvasInstance().getNodeBCompartment());
        DiagramNodeTest.assertNotNull((String)"Level1 ChildNode was not created", (Object)level1Child);
        View level1Compartment = DiagramNodeTest.findChildView((View)level1Child, (GenCommonBase)childNode.getCompartments().get(0));
        DiagramNodeTest.assertNotNull((String)"Level1 Compartment was not created", (Object)level1Compartment);
        GenNode recursiveChildNode = (GenNode)childNodeCompartment.getChildNodes().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not recursive child node", (recursiveChildNode.getChildNodes().size() == 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not recursive child node", (recursiveChildNode.getCompartments().size() == 1 ? 1 : 0) != 0);
        GenCompartment recursiveChildNodeCompartment = (GenCompartment)childNode.getCompartments().get(0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not recursive child node", (recursiveChildNodeCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: specified childNode is not recursive child node", (recursiveChildNodeCompartment.getChildNodes().get(0) == recursiveChildNode ? 1 : 0) != 0);
        Node level2Child = this.createNode((GenCommonBase)recursiveChildNode, level1Compartment);
        DiagramNodeTest.assertNotNull((String)"Level2 ChildNode was not created", (Object)level2Child);
        View level2Compartment = DiagramNodeTest.findChildView((View)level2Child, (GenCommonBase)recursiveChildNode.getCompartments().get(0));
        DiagramNodeTest.assertNotNull((String)"Level1 Compartment was not created", (Object)level2Compartment);
        Node level3Child = this.createNode((GenCommonBase)recursiveChildNode, level2Compartment);
        DiagramNodeTest.assertNotNull((String)"Level2 ChildNode was not created", (Object)level3Child);
        View level3Compartment = DiagramNodeTest.findChildView((View)level3Child, (GenCommonBase)recursiveChildNode.getCompartments().get(0));
        DiagramNodeTest.assertNotNull((String)"Level1 Compartment was not created", (Object)level3Compartment);
    }

    public void testCreateChildNodeNotWithinCompartment() {
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: GenModel with only two nodes", (this.getSetup().getGenModel().getGenDiagram().getTopLevelNodes().size() > 2 ? 1 : 0) != 0);
        GenNode genNodeC = (GenNode)this.getSetup().getGenModel().getGenDiagram().getTopLevelNodes().get(2);
        DiagramNodeTest.assertFalse((String)"Incorrect Setup: passed node has compartments", (genNodeC.getCompartments().size() > 0 ? 1 : 0) != 0);
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genNodeC.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode genChildNode = (GenNode)genNodeC.getChildNodes().get(0);
        Node topLevelNode = this.createNode((GenCommonBase)genNodeC, (View)this.getDiagram());
        DiagramNodeTest.assertNotNull((String)"Top level node was not created", (Object)topLevelNode);
        DiagramNodeTest.assertTrue((String)"Incorrect number of top-level node children was created", (genNodeC.getLabels().size() == topLevelNode.getChildren().size() ? 1 : 0) != 0);
        for (GenNodeLabel nextLabel : genNodeC.getLabels()) {
            DiagramNodeTest.assertNotNull((String)("Notation model element was not created for label: " + nextLabel.getVisualID()), (Object)DiagramNodeTest.findChildView((View)topLevelNode, (GenCommonBase)nextLabel));
        }
        Node childNode = this.createNode((GenCommonBase)genChildNode, (View)topLevelNode);
        DiagramNodeTest.assertNotNull((String)"Child node without compartment was not created", (Object)childNode);
    }

    static /* synthetic */ View access$1(View view, GenCommonBase genCommonBase) {
        return AbstractCanvasTest.findChildView(view, genCommonBase);
    }
}

