/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.setup.ToolDefSource;

public class CompartmentsSessionSetup
extends SessionSetup {
    protected CompartmentsSessionSetup() {
    }

    public static SessionSetup newInstance() {
        if (factoryClosed) {
            return null;
        }
        return new CompartmentsSessionSetup();
    }

    protected DomainModelSource createDomainModel() {
        return new DomainSetupWithChildren().init();
    }

    protected DiaDefSource createGraphDefModel() {
        return new DiaDefSetupWithCompartments().init();
    }

    protected MapDefSource createMapModel() {
        MapSetup mapDefSource = new MapSetupWithCompartments().init(this.getGraphDefModel(), this.getDomainModel(), new ToolDefSetup());
        this.assertCompartmentMapping(mapDefSource.getNodeA());
        this.assertCompartmentMapping(mapDefSource.getNodeB());
        return mapDefSource;
    }

    private void assertCompartmentMapping(NodeMapping nodeMapping) {
        Assert.assertFalse((boolean)nodeMapping.getCompartments().isEmpty());
        Iterator compartments = nodeMapping.getCompartments().iterator();
        while (compartments.hasNext()) {
            CompartmentMapping next = (CompartmentMapping)compartments.next();
            Assert.assertSame((Object)nodeMapping, (Object)next.getParentNode());
        }
    }

    protected DiaGenSource createGenModel() {
        DiaGenSetup result = new DiaGenSetup().init(this.getMapModel());
        Assert.assertFalse((boolean)result.getNodeA().getCompartments().isEmpty());
        Assert.assertFalse((boolean)result.getNodeB().getCompartments().isEmpty());
        return result;
    }

    public DomainModelSourceExtension getDomainModelExtension() {
        return (DomainModelSourceExtension)this.getDomainModel();
    }

    public DiaDefSourceExtension getGraphDefModelExtension() {
        return (DiaDefSourceExtension)this.getGraphDefModel();
    }

    public static interface DiaDefSourceExtension
    extends DiaDefSource {
        public Compartment getCompartmentA();

        public Compartment getCompartmentB();

        public Node getColoredNode();

        public Connection getColoredConnection();

        public DiagramLabel getDecoratedDiagramLabel();
    }

    public static interface DomainModelSourceExtension
    extends DomainModelSource {
        public DomainModelSource.NodeData getChildOfA();

        public DomainModelSource.NodeData getChildOfB();
    }

    protected static class DiaDefSetupWithCompartments
    extends DiaDefSetup
    implements DiaDefSourceExtension {
        private Compartment myCollapsibleCompartmentWithTitle;
        private Compartment myCompartmentNoTitleNoCollapse;
        private Node myColoredNode;
        private Connection myColoredConnection;
        private DiagramLabel myDiagramLabelWithFont;

        protected DiaDefSetupWithCompartments() {
        }

        public void setupCanvasDef(Canvas canvasDef) {
            FigureGallery oneMoreGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
            canvasDef.getFigures().add((Object)oneMoreGallery);
            Rectangle compartmentFigure = GMFGraphFactory.eINSTANCE.createRectangle();
            compartmentFigure.setName("CompartmentFigure");
            oneMoreGallery.getFigures().add((Object)compartmentFigure);
            this.myCollapsibleCompartmentWithTitle = this.createCompartment((Figure)compartmentFigure, "Compartment_Title_Collapse", true, true);
            canvasDef.getCompartments().add((Object)this.myCollapsibleCompartmentWithTitle);
            this.myCompartmentNoTitleNoCollapse = this.createCompartment((Figure)compartmentFigure, "Compartment_NoTitle_No_Collapse", false, false);
            canvasDef.getCompartments().add((Object)this.myCompartmentNoTitleNoCollapse);
            Rectangle colored = GMFGraphFactory.eINSTANCE.createRectangle();
            colored.setForegroundColor(this.createColor(ColorConstants.RED_LITERAL));
            colored.setBackgroundColor(this.createColor(ColorConstants.BLUE_LITERAL));
            colored.setName("ColoredRectangle");
            oneMoreGallery.getFigures().add((Object)colored);
            this.myColoredNode = GMFGraphFactory.eINSTANCE.createNode();
            this.myColoredNode.setName("ColoredRectangleNode");
            this.myColoredNode.setFigure((FigureHandle)colored);
            this.getCanvasDef().getNodes().add((Object)this.myColoredNode);
            PolylineConnection connectionLink = GMFGraphFactory.eINSTANCE.createPolylineConnection();
            connectionLink.setName("ColoredLink");
            connectionLink.setForegroundColor(this.createColor(ColorConstants.ORANGE_LITERAL));
            oneMoreGallery.getFigures().add((Object)connectionLink);
            this.myColoredConnection = GMFGraphFactory.eINSTANCE.createConnection();
            this.myColoredConnection.setName("ColoredLinkConnection");
            this.myColoredConnection.setFigure((FigureHandle)connectionLink);
            this.getCanvasDef().getConnections().add((Object)this.myColoredConnection);
            Label label = GMFGraphFactory.eINSTANCE.createLabel();
            label.setName("LabelWithFont");
            label.setText("LabelText");
            BasicFont font = GMFGraphFactory.eINSTANCE.createBasicFont();
            font.setFaceName("Arial");
            font.setHeight(18);
            font.setStyle(FontStyle.BOLD_LITERAL);
            label.setFont((Font)font);
            oneMoreGallery.getFigures().add((Object)label);
            this.myDiagramLabelWithFont = GMFGraphFactory.eINSTANCE.createDiagramLabel();
            this.myDiagramLabelWithFont.setName("DiagramLabelWithFont");
            this.myDiagramLabelWithFont.setFigure((FigureHandle)label);
            this.getCanvasDef().getLabels().add((Object)this.myDiagramLabelWithFont);
        }

        protected void setupNodeDef(Node nodeDef) {
            Figure figure = (Figure)nodeDef.getFigure();
            figure.setLayout((Layout)GMFGraphFactory.eINSTANCE.createBorderLayout());
        }

        public Compartment getCompartmentA() {
            return this.myCollapsibleCompartmentWithTitle;
        }

        public Compartment getCompartmentB() {
            return this.myCompartmentNoTitleNoCollapse;
        }

        public Connection getColoredConnection() {
            return this.myColoredConnection;
        }

        public Node getColoredNode() {
            return this.myColoredNode;
        }

        public DiagramLabel getDecoratedDiagramLabel() {
            return this.myDiagramLabelWithFont;
        }

        private Compartment createCompartment(Figure figure, String name, boolean collapsible, boolean needsTitle) {
            Compartment result = GMFGraphFactory.eINSTANCE.createCompartment();
            result.setFigure((FigureHandle)figure);
            result.setName(name);
            result.setNeedsTitle(needsTitle);
            result.setCollapsible(collapsible);
            return result;
        }

        private Color createColor(ColorConstants color) {
            ConstantColor result = GMFGraphFactory.eINSTANCE.createConstantColor();
            result.setValue(color);
            return result;
        }
    }

    protected static class DomainSetupWithChildren
    extends DomainModelSetup
    implements DomainModelSourceExtension {
        private DomainModelSource.NodeData myChildOfA;
        private DomainModelSource.NodeData myChildOfB;

        protected DomainSetupWithChildren() {
        }

        public DomainModelSetup init() {
            DomainModelSetup result = super.init();
            result.getModel().setName("ModelWithChildren");
            EClass childClass = EcoreFactory.eINSTANCE.createEClass();
            childClass.setName("Child");
            EAttribute childLabel = EcoreFactory.eINSTANCE.createEAttribute();
            childLabel.setName("childLabel");
            childLabel.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            childClass.getEStructuralFeatures().add((Object)childLabel);
            result.getModel().getEClassifiers().add((Object)childClass);
            EReference containmentForA = EcoreFactory.eINSTANCE.createEReference();
            containmentForA.setContainment(true);
            containmentForA.setName("childrenOfA");
            containmentForA.setEType((EClassifier)childClass);
            containmentForA.setUpperBound(-1);
            result.getNodeA().getEClass().getEStructuralFeatures().add((Object)containmentForA);
            EReference containmentForB = (EReference)EcoreUtil.copy((EObject)containmentForA);
            containmentForB.setName("childrenOfB");
            result.getNodeB().getEClass().getEStructuralFeatures().add((Object)containmentForB);
            this.myChildOfA = new DomainModelSource.NodeData(childClass, childLabel, containmentForA);
            this.myChildOfB = new DomainModelSource.NodeData(childClass, childLabel, containmentForB);
            return result;
        }

        public DomainModelSource.NodeData getChildOfA() {
            return this.myChildOfA;
        }

        public DomainModelSource.NodeData getChildOfB() {
            return this.myChildOfB;
        }
    }

    protected static class MapSetupWithCompartments
    extends MapSetup {
        protected MapSetupWithCompartments() {
        }

        public MapSetup init(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
            Assert.assertTrue((boolean)(domainSource instanceof DomainSetupWithChildren));
            Assert.assertTrue((boolean)(ddSource instanceof DiaDefSetupWithCompartments));
            DomainSetupWithChildren domainWithChildren = (DomainSetupWithChildren)domainSource;
            DiaDefSetupWithCompartments diaDefSetupWithCompartments = (DiaDefSetupWithCompartments)ddSource;
            Assert.assertNotNull((Object)diaDefSetupWithCompartments.getCompartmentA());
            Assert.assertNotNull((Object)diaDefSetupWithCompartments.getCompartmentB());
            MapSetup result = super.init(ddSource, domainSource, toolDef);
            this.getNodeB().setDiagramNode(diaDefSetupWithCompartments.getColoredNode());
            this.getReferenceLink().setDiagramLink(diaDefSetupWithCompartments.getColoredConnection());
            this.setupReferenceAndCompartment(ddSource, diaDefSetupWithCompartments.getCompartmentA(), domainWithChildren.getChildOfA(), result.getNodeA());
            this.setupReferenceAndCompartment(ddSource, diaDefSetupWithCompartments.getCompartmentB(), domainWithChildren.getChildOfB(), result.getNodeB());
            Assert.assertFalse((boolean)this.getNodeB().getLabelMappings().isEmpty());
            Iterator labelsB = this.getNodeB().getLabelMappings().iterator();
            while (labelsB.hasNext()) {
                LabelMapping next = (LabelMapping)labelsB.next();
                next.setDiagramLabel(diaDefSetupWithCompartments.getDecoratedDiagramLabel());
            }
            return result;
        }

        private ChildReference setupReferenceAndCompartment(DiaDefSource ddSource, Compartment diagramCompartment, DomainModelSource.NodeData data, NodeMapping parentMapping) {
            Node diagramNode = ddSource.getNodeDef();
            DiagramLabel diagramLabel = ddSource.getLabelDef();
            NodeMapping childMapping = this.createNodeMapping(diagramNode, data.getEClass(), diagramLabel, data.getNameAttr(), data.getContainment(), false);
            ChildReference childReference = GMFMapFactory.eINSTANCE.createChildReference();
            childReference.setOwnedChild(childMapping);
            childReference.setChildrenFeature(data.getContainment());
            childReference.setContainmentFeature(data.getContainment());
            parentMapping.getChildren().add((Object)childReference);
            CompartmentMapping compartmentMapping = GMFMapFactory.eINSTANCE.createCompartmentMapping();
            compartmentMapping.setCompartment(diagramCompartment);
            compartmentMapping.getChildren().add((Object)childReference);
            parentMapping.getCompartments().add((Object)compartmentMapping);
            return childReference;
        }
    }
}

