/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.osgi.framework.Bundle;

public class StandaloneMapModeTest
extends FigureCodegenTestBase {
    private StandaloneGenerator.Config myGeneratorConfig;

    public StandaloneMapModeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myGeneratorConfig = null;
    }

    public void testStaticIdentityMapMode() {
        this.myGeneratorConfig = new StandaloneGenerator.ConfigImpl(this.getTestPluginName(), this.getFigurePackageName(), false);
        this.performTests(this.createTestFigure(), new FigureSizeCheck(123, 456));
    }

    public void testRuntimeIdentityMapMode() {
        this.myGeneratorConfig = new StandaloneGenerator.ConfigImpl(this.getTestPluginName(), this.getFigurePackageName(), true);
        this.performTests(this.createTestFigure(), new InstantiateFigureHook(123, 456, MapModeTypes.IDENTITY_MM, this.myGeneratorConfig));
    }

    public void testRuntimeHiMetricsMapMode() {
        this.myGeneratorConfig = new StandaloneGenerator.ConfigImpl(this.getTestPluginName(), this.getFigurePackageName(), true);
        this.performTests(this.createTestFigure(), new InstantiateFigureHook(123, 456, MapModeTypes.HIMETRIC_MM, this.myGeneratorConfig));
    }

    protected StandaloneGenerator.Config getGMFGraphGeneratorConfig() {
        StandaloneMapModeTest.assertNotNull((Object)this.myGeneratorConfig);
        return this.myGeneratorConfig;
    }

    private Figure createTestFigure() {
        Rectangle result = GMFGraphFactory.eINSTANCE.createRectangle();
        result.setName("TestFigure");
        Point size = GMFGraphFactory.eINSTANCE.createPoint();
        size.setX(123);
        size.setY(456);
        result.setSize(size);
        return result;
    }

    private static class FigureSizeCheck
    extends FigureCodegenTestBase.FigureCheck {
        private final Dimension mySize;

        public FigureSizeCheck(int width, int height) {
            this(new Dimension(width, height));
        }

        public FigureSizeCheck(Dimension size) {
            this.mySize = size;
        }

        public void checkFigure(IFigure figure) {
            FigureSizeCheck.assertEquals((Object)this.mySize, (Object)figure.getSize());
        }
    }

    private static class InstantiateFigureHook
    extends FigureSizeCheck {
        private final IMapMode myMapMode;
        private final StandaloneGenerator.Config myConfig;
        static /* synthetic */ Class class$0;

        public InstantiateFigureHook(int width, int height, IMapMode mapMode, StandaloneGenerator.Config config) {
            super(mapMode.DPtoLP(width), mapMode.DPtoLP(height));
            this.myMapMode = mapMode;
            this.myConfig = config;
        }

        protected IFigure instantiateFigure(Class figureClass) {
            try {
                this.hookMapMode();
            }
            catch (Exception e) {
                InstantiateFigureHook.fail((String)e.getMessage());
            }
            return super.instantiateFigure(figureClass);
        }

        private void hookMapMode() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Bundle bundle = Platform.getBundle((String)this.myConfig.getPluginID());
            InstantiateFigureHook.assertNotNull((Object)bundle);
            Class activatorClass = bundle.loadClass(String.valueOf(this.myConfig.getPluginActivatorPackageName()) + "." + this.myConfig.getPluginActivatorClassName());
            InstantiateFigureHook.assertNotNull((Object)activatorClass);
            Method getDefault = activatorClass.getMethod("getDefault", new Class[0]);
            InstantiateFigureHook.assertNotNull((Object)getDefault);
            Object activator = getDefault.invoke(null, new Object[0]);
            InstantiateFigureHook.assertNotNull((Object)activator);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method setMapMode = activatorClass.getMethod("setMapMode", classArray);
            InstantiateFigureHook.assertNotNull((Object)setMapMode);
            setMapMode.invoke(activator, this.myMapMode);
            Method getMapMode = activatorClass.getMethod("getMapMode", new Class[0]);
            InstantiateFigureHook.assertNotNull((Object)getMapMode);
            InstantiateFigureHook.assertEquals((Object)this.myMapMode, (Object)getMapMode.invoke(activator, new Object[0]));
        }
    }
}

