/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.lang.reflect.Method;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LabeledContainer;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.eclipse.gmf.tests.gen.GenericFigureCheck;

public class LabelSupportTest
extends FigureCodegenTestBase {
    private static final String LABEL_NAME = "Typename";
    static /* synthetic */ Class class$0;

    public LabelSupportTest(String name) {
        super(name);
    }

    public void testCustomFugureWithLabel() {
        CustomFigure custom = GMFGraphFactory.eINSTANCE.createCustomFigure();
        custom.setBundleName("org.eclipse.draw2d");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.RectangleFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        custom.setQualifiedClassName(clazz.getName());
        this.performChecks((Figure)custom, "CustomParent", LABEL_NAME);
    }

    public void testRectangleWithLabel() {
        Rectangle simple = GMFGraphFactory.eINSTANCE.createRectangle();
        this.performChecks((Figure)simple, "SimpleParent", LABEL_NAME);
    }

    public void testLabeledContainer() {
        LabeledContainer labeledContainer = GMFGraphFactory.eINSTANCE.createLabeledContainer();
        this.performChecks((Figure)labeledContainer, "LabeledContainerAlreadyHasLabel_DoesItNeedOneMore", LABEL_NAME);
    }

    public void testDeepLabelGraphdefOnly() {
        Rectangle root = GMFGraphFactory.eINSTANCE.createRectangle();
        root.setName("Root");
        BorderLayout layout = GMFGraphFactory.eINSTANCE.createBorderLayout();
        root.setLayout((Layout)layout);
        RoundedRectangle padding = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        padding.setName("Padding");
        BorderLayoutData paddingData = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        paddingData.setAlignment(Alignment.FILL_LITERAL);
        padding.setLayoutData((LayoutData)paddingData);
        Rectangle intermediateLabelContainer = GMFGraphFactory.eINSTANCE.createRectangle();
        intermediateLabelContainer.setName("intermediateLabelContainer");
        BorderLayoutData labelData = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        labelData.setAlignment(Alignment.BEGINNING_LITERAL);
        labelData.setVertical(true);
        intermediateLabelContainer.setLayoutData((LayoutData)labelData);
        this.addLabel((Figure)intermediateLabelContainer, LABEL_NAME);
        root.getChildren().add((Object)intermediateLabelContainer);
        root.getChildren().add((Object)padding);
        this.performTests((Figure)root, LabelSupportTest.combineChecks(new GenericFigureCheck((Figure)root), new LabelAccessorCheck(LABEL_NAME)));
    }

    private void performChecks(Figure parent, String parentName, String labelName) {
        parent.setName(parentName);
        Dimension prefSize = GMFGraphFactory.eINSTANCE.createDimension();
        prefSize.setDx(60);
        prefSize.setDy(60);
        parent.setPreferredSize(prefSize);
        this.addLabel(parent, labelName);
        this.performTests(parent, LabelSupportTest.combineChecks(new GenericFigureCheck(parent), new LabelAccessorCheck(LABEL_NAME)));
    }

    private void addLabel(Figure parent, String labelName) {
        Label label = GMFGraphFactory.eINSTANCE.createLabel();
        label.setName(labelName);
        Node labelNode = GMFGraphFactory.eINSTANCE.createNode();
        labelNode.setName("LabelNode");
        labelNode.setFigure((FigureHandle)label);
        parent.getChildren().add((Object)label);
    }

    private static class LabelAccessorCheck
    extends FigureCodegenTestBase.FigureCheck {
        private final String myLabelName;
        private static final Class[] NO_PARAMS = new Class[0];

        public LabelAccessorCheck(String labelName) {
            this.myLabelName = labelName;
        }

        public void checkFigure(IFigure figure) {
            LabelAccessorCheck.assertNotNull((Object)figure);
            LabelAccessorCheck.assertTrue((String)"NodeEditPart requires this method in the inner figure class", (boolean)this.hasMethod(figure, "getFigure" + CodeGenUtil.capName((String)this.myLabelName), NO_PARAMS));
        }

        private boolean hasMethod(Object instance, String methodName, Class[] params) {
            try {
                Method method = instance.getClass().getMethod(methodName, params);
                return method != null;
            }
            catch (SecurityException securityException) {
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        }
    }
}

