/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import java.util.HashMap;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.TreeRouter;

public class ForestRouter
extends BendpointConnectionRouter
implements OrthogonalRouter {
    private HashMap connections = new HashMap();
    private HashMap trunkVertexes = new HashMap();

    public void invalidate(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        TreeRouter connectionRouter = this.getSubRouter(conn);
        if (connectionRouter != null) {
            connectionRouter.invalidate(conn);
        }
    }

    public void remove(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        TreeRouter connectionRouter = this.getSubRouter(conn);
        if (connectionRouter != null) {
            connectionRouter.remove(conn);
        }
        super.remove(conn);
    }

    public void route(Connection conn) {
        if (conn.getTargetAnchor().getOwner() == null || conn.getSourceAnchor().getOwner() == null) {
            PointList points = conn.getPoints();
            points.removeAllPoints();
            Point ref1 = conn.getTargetAnchor().getReferencePoint();
            Point ref2 = conn.getSourceAnchor().getReferencePoint();
            PrecisionPoint precisePt = new PrecisionPoint();
            precisePt.setLocation(conn.getSourceAnchor().getLocation(ref1));
            conn.translateToRelative((Translatable)precisePt);
            points.addPoint((Point)precisePt);
            precisePt.setLocation(conn.getTargetAnchor().getLocation(ref2));
            conn.translateToRelative((Translatable)precisePt);
            points.addPoint((Point)precisePt);
            conn.setPoints(points);
            return;
        }
        TreeRouter treeRouter = this.getSubRouter(conn);
        Dimension trunk = treeRouter.getTrunkVertex();
        if (trunk != null) {
            AnchorKey trunkKey = new AnchorKey(conn.getTargetAnchor(), trunk);
            this.trunkVertexes.remove(trunkKey);
        }
        treeRouter.route(conn);
        trunk = treeRouter.getTrunkVertex();
        Dimension adjustedTrunk = this.accountForTrunkOverlap(trunk, conn);
        if (!adjustedTrunk.equals((Object)trunk)) {
            treeRouter.setTrunkVertex(adjustedTrunk);
            treeRouter.invalidate(conn);
        }
    }

    private Dimension accountForTrunkOverlap(Dimension trunk, Connection conn) {
        if (conn.getTargetAnchor() == null || conn.getTargetAnchor().getOwner() == null) {
            return trunk;
        }
        AnchorKey trunkKey = new AnchorKey(conn.getTargetAnchor(), trunk);
        int ownerExt = conn.getTargetAnchor().getOwner().getBounds().width / 2;
        int trunkExt = trunk.width;
        if (conn instanceof ITreeConnection && ((ITreeConnection)conn).getOrientation() == ITreeConnection.Orientation.HORIZONTAL) {
            ownerExt = conn.getTargetAnchor().getOwner().getBounds().height / 2;
            trunkExt = trunk.height;
        }
        if (this.trunkVertexes.get(trunkKey) == null || Math.abs(trunkExt) > ownerExt) {
            this.trunkVertexes.put(trunkKey, Boolean.TRUE);
            return trunk;
        }
        Dimension newTrunk = new Dimension(trunk);
        newTrunk.expand(10, 10);
        return this.accountForTrunkOverlap(newTrunk, conn);
    }

    public TreeRouter getSubRouter(Connection conn) {
        AnchorKey connectionKey;
        TreeRouter connectionRouter;
        if (conn.getTargetAnchor() == null) {
            return null;
        }
        String hint = "base";
        if (conn instanceof ITreeConnection) {
            hint = ((ITreeConnection)conn).getHint();
        }
        if ((connectionRouter = (TreeRouter)this.connections.get(connectionKey = new AnchorKey(conn.getTargetAnchor(), hint))) == null) {
            connectionRouter = new TreeRouter();
            this.connections.put(connectionKey, connectionRouter);
        }
        return connectionRouter;
    }

    private class AnchorKey {
        private ConnectionAnchor anchor;
        private Object qualifier;

        AnchorKey(ConnectionAnchor anchor, Object qualifier) {
            this.anchor = anchor;
            this.qualifier = qualifier;
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof AnchorKey) {
                AnchorKey hashKey = (AnchorKey)object;
                ConnectionAnchor hkA1 = hashKey.getAnchor();
                Object hkA2 = hashKey.getQualifier();
                isEqual = hkA1.equals(this.anchor) && hkA2.equals(this.qualifier);
            }
            return isEqual;
        }

        public ConnectionAnchor getAnchor() {
            return this.anchor;
        }

        public Object getQualifier() {
            return this.qualifier;
        }

        public int hashCode() {
            return this.anchor.hashCode() ^ this.qualifier.hashCode();
        }
    }
}

