/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.handles.CompartmentCollapseHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.handles.CompartmentResizeHandle;

public class ResizableCompartmentEditPolicy
extends ResizableEditPolicyEx {
    private boolean horizontal;
    private EditPartListener hostListener;
    private EditPartListener parentListener;

    public ResizableCompartmentEditPolicy() {
        this(false);
    }

    public ResizableCompartmentEditPolicy(boolean horizontal) {
        this.horizontal = horizontal;
    }

    protected boolean isHorizontal() {
        return this.horizontal;
    }

    protected List createCollapseHandles() {
        IGraphicalEditPart part = (IGraphicalEditPart)this.getHost();
        ArrayList<CompartmentCollapseHandle> collapseHandles = new ArrayList<CompartmentCollapseHandle>();
        collapseHandles.add(new CompartmentCollapseHandle(part));
        return collapseHandles;
    }

    protected List createSelectionHandles() {
        IGraphicalEditPart part = (IGraphicalEditPart)this.getHost();
        int d1 = this.isHorizontal() ? 8 : 1;
        int d2 = this.isHorizontal() ? 16 : 4;
        ArrayList<CompartmentResizeHandle> selectionHandles = new ArrayList<CompartmentResizeHandle>();
        selectionHandles.addAll(this.createCollapseHandles());
        selectionHandles.add(new CompartmentResizeHandle(part, d1));
        selectionHandles.add(new CompartmentResizeHandle(part, d2));
        return selectionHandles;
    }

    private ResizableCompartmentFigure getCompartmentFigure() {
        BorderedNodeFigure gpf;
        IFigure f;
        ResizableCompartmentFigure compartmentFigure = null;
        if (this.getGraphicalEditPart() instanceof ResizableCompartmentEditPart) {
            compartmentFigure = ((ResizableCompartmentEditPart)this.getGraphicalEditPart()).getCompartmentFigure();
        } else if (this.getGraphicalEditPart().getFigure() instanceof ResizableCompartmentFigure) {
            compartmentFigure = (ResizableCompartmentFigure)this.getGraphicalEditPart().getFigure();
        } else if (this.getGraphicalEditPart().getFigure() instanceof BorderedNodeFigure && (f = (gpf = (BorderedNodeFigure)this.getGraphicalEditPart().getFigure()).getMainFigure()) instanceof ResizableCompartmentFigure) {
            compartmentFigure = (ResizableCompartmentFigure)f;
        }
        return compartmentFigure;
    }

    protected void showSelection() {
        ResizableCompartmentFigure compartmentFigure;
        super.showSelection();
        if (this.getHost().getSelected() != 0 && (compartmentFigure = this.getCompartmentFigure()) != null) {
            compartmentFigure.setSelected(true);
        }
    }

    protected void hideSelection() {
        ResizableCompartmentFigure compartmentFigure;
        super.hideSelection();
        if (this.getHost().getSelected() == 0 && (compartmentFigure = this.getCompartmentFigure()) != null) {
            compartmentFigure.setSelected(false);
        }
    }

    public void activate() {
        super.activate();
        if (this.getHost().getParent().getSelected() != 0) {
            this.setSelectedState();
        }
    }

    protected void addSelectionListener() {
        this.hostListener = new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart part) {
                ResizableCompartmentEditPolicy.this.setSelectedState();
                ResizableCompartmentEditPolicy.this.setFocus(part.hasFocus());
            }
        };
        this.getHost().addEditPartListener(this.hostListener);
        this.parentListener = new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart part) {
                ResizableCompartmentEditPolicy.this.setSelectedState();
            }
        };
        this.getParentGraphicEditPart().addEditPartListener(this.parentListener);
    }

    protected void removeSelectionListener() {
        this.getHost().removeEditPartListener(this.hostListener);
        this.getParentGraphicEditPart().removeEditPartListener(this.parentListener);
    }

    protected void setSelectedState() {
        boolean vis;
        int hostState = this.getHost().getSelected();
        int topState = 0;
        if (this.getGraphicalEditPart().getTopGraphicEditPart() != null) {
            topState = this.getGraphicalEditPart().getTopGraphicEditPart().getSelected();
        }
        if ((vis = this.getGraphicalEditPart().getNotationView().isVisible()) && (hostState != 0 || topState != 0)) {
            this.setSelectedState(1);
        } else {
            this.setSelectedState(0);
        }
    }

    private IGraphicalEditPart getParentGraphicEditPart() {
        return (IGraphicalEditPart)this.getGraphicalEditPart().getParent();
    }

    private IGraphicalEditPart getGraphicalEditPart() {
        return (IGraphicalEditPart)this.getHost();
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(this.getResizeChildrenRequest(request));
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        return this.getHost().getParent().getCommand((Request)this.getResizeChildrenRequest(request));
    }

    private ChangeBoundsRequest getResizeChildrenRequest(ChangeBoundsRequest r) {
        Dimension delta = r.getSizeDelta();
        ResizableCompartmentFigure f = this.getCompartmentFigure();
        Dimension fd = f.getSize().getExpanded(delta);
        fd.intersect(f.getMaximumSize()).union(f.getMinimumSize());
        delta = fd.shrink(f.getSize().width, f.getSize().height);
        boolean moved = (r.getResizeDirection() & 9) != 0;
        IFigure a = f.getAdjacentSibling(moved);
        if (a != null) {
            Dimension ad = a.getSize().getExpanded(delta.negate());
            ad.intersect(a.getMaximumSize()).union(a.getMinimumSize());
            delta = ad.shrink(a.getSize().width, a.getSize().height).negate();
        } else {
            delta.shrink(delta.width, delta.height);
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(this.getHost());
        req.setLocation(r.getLocation());
        req.setResizeDirection(r.getResizeDirection());
        req.setSizeDelta(delta);
        if (moved) {
            req.setMoveDelta(new Point(-delta.width, -delta.height));
        }
        return req;
    }
}

