/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.internal.bridge.NaiveIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.StatefulVisualIdentifierDispencer;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.BasicGenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.FileGenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.SpecificDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.ErrorDialogEx;
import org.eclipse.gmf.internal.graphdef.codegen.ui.FigureGeneratorOptionsDialog;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.osgi.framework.Bundle;

public class TransformToGenModel
implements IObjectActionDelegate {
    private static final String ASK_WARN = "ask_warn";
    private IFile myMapFile;
    private IWorkbenchPart myPart;
    private IFile myDestFile;
    private Map mySaveOptions = null;
    private static final Boolean THERE_IS_NO_SPECIFIC_RT = Boolean.TRUE;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void run(IAction action) {
        GenModelDetector gmDetector;
        IStatus findStatus;
        this.initDestinationFile();
        if (this.myDestFile == null) {
            return;
        }
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource mapRes = resSet.getResource(this.getMapModelURI(), true);
        final Mapping mapping = (Mapping)mapRes.getContents().get(0);
        IStatus mapIsValid = this.validate(mapping);
        if (mapIsValid.matches(8)) {
            return;
        }
        if (mapIsValid.matches(4)) {
            String[] buttons = new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL};
            int[] buttonIDs = new int[]{10, 1};
            String msg = CodeGenUIPlugin.getBundleString("transform.err");
            ErrorDialogEx dlg = new ErrorDialogEx(this.getShell(), action.getText(), msg, mapIsValid, buttons, buttonIDs, 0);
            if (dlg.open() == 1) {
                return;
            }
        } else if (mapIsValid.matches(3) && !"always".equals(TransformToGenModel.getPreferences().getString(ASK_WARN)) && MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("transform.warn"), (String)CodeGenUIPlugin.getBundleString("transform.neverwarn"), (boolean)false, (IPreferenceStore)TransformToGenModel.getPreferences(), (String)ASK_WARN).getReturnCode() != 0) {
            return;
        }
        if ((findStatus = (gmDetector = new GenModelDetector()).find(this.getShell(), mapping)).getSeverity() == 8) {
            return;
        }
        GenModel domainGenModel = null;
        if (findStatus.isOK()) {
            domainGenModel = gmDetector.get((ResourceSet)resSet);
        }
        DiagramRunTimeModelHelper drtModelHelper = this.detectRunTimeModel((ResourceSet)resSet);
        ViewmapProducer viewmapProducer = this.detectViewmapProducer(this.getShell());
        if (viewmapProducer == null) {
            return;
        }
        VisualIdentifierDispenser idDespenser = this.getVisualIdDespenser((ResourceSet)resSet);
        final DiagramGenModelTransformer t = new DiagramGenModelTransformer(drtModelHelper, (GenModelNamingMediator)new GenModelNamingMediatorImpl(), viewmapProducer, idDespenser);
        if (domainGenModel != null) {
            t.setEMFGenModel(domainGenModel);
        }
        new Job(action.getText(), (ResourceSet)resSet, idDespenser){
            private final /* synthetic */ ResourceSet val$resSet;
            private final /* synthetic */ VisualIdentifierDispenser val$idDespenser;
            {
                this.val$resSet = resourceSet;
                this.val$idDespenser = visualIdentifierDispenser;
                super($anonymous0);
                this.setUser(true);
                this.setPriority(20);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                IStatus iStatus;
                block13: {
                    IStatus iStatus4;
                    block12: {
                        IStatus iStatus3;
                        block11: {
                            IStatus iStatus2;
                            block10: {
                                monitor.beginTask(this.getName(), 4);
                                try {
                                    try {
                                        GenEditorGenerator genEditor = this.transform(mapping);
                                        monitor.worked(1);
                                        if (monitor.isCanceled()) {
                                            iStatus2 = Status.CANCEL_STATUS;
                                            Object var3_11 = null;
                                            break block10;
                                        }
                                        if (CodeGenUIPlugin.needsReconcile()) {
                                            this.reconcile(genEditor);
                                        }
                                        monitor.worked(1);
                                        if (monitor.isCanceled()) {
                                            iStatus3 = Status.CANCEL_STATUS;
                                            break block11;
                                        }
                                        this.save(genEditor);
                                        monitor.worked(1);
                                        if (monitor.isCanceled()) {
                                            iStatus4 = Status.CANCEL_STATUS;
                                            break block12;
                                        }
                                        iStatus = this.validate(genEditor);
                                        break block13;
                                    }
                                    catch (IOException ex) {
                                        IStatus iStatus5 = CodeGenUIPlugin.createError(ex.getMessage(), ex);
                                        Object var3_15 = null;
                                        monitor.done();
                                        return iStatus5;
                                    }
                                    catch (IllegalArgumentException ex) {
                                        IStatus iStatus6 = CodeGenUIPlugin.createError(ex.getMessage(), ex);
                                        Object var3_16 = null;
                                        monitor.done();
                                        return iStatus6;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var3_17 = null;
                                    monitor.done();
                                    throw throwable;
                                }
                            }
                            monitor.done();
                            return iStatus2;
                        }
                        Object var3_12 = null;
                        monitor.done();
                        return iStatus3;
                    }
                    Object var3_13 = null;
                    monitor.done();
                    return iStatus4;
                }
                Object var3_14 = null;
                monitor.done();
                return iStatus;
            }

            private GenEditorGenerator transform(Mapping m) {
                t.transform(m);
                return t.getResult();
            }

            private IStatus validate(GenEditorGenerator genBurdern) {
                Diagnostic d = Diagnostician.INSTANCE.validate((EObject)genBurdern);
                if (d.getSeverity() == 0) {
                    return Status.OK_STATUS;
                }
                if ((d.getSeverity() & 8) != 0) {
                    return Status.CANCEL_STATUS;
                }
                return BasicDiagnostic.toIStatus((Diagnostic)d);
            }

            private void save(GenEditorGenerator genBurdern) throws IOException {
                Resource dgmmRes = this.val$resSet.createResource(TransformToGenModel.this.getGenModelURI());
                dgmmRes.getContents().add((Object)genBurdern);
                dgmmRes.save(TransformToGenModel.this.getSaveOptions());
                if (this.val$idDespenser instanceof StatefulVisualIdentifierDispencer) {
                    ((StatefulVisualIdentifierDispencer)this.val$idDespenser).saveState();
                }
            }

            /*
             * Exception decompiling
             */
            private void reconcile(GenEditorGenerator genBurdern) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 120->124)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }.schedule();
    }

    private VisualIdentifierDispenser getVisualIdDespenser(ResourceSet resSet) {
        Bundle tracePluginBundle = Platform.getBundle((String)"org.eclipse.gmf.bridge.trace");
        if (tracePluginBundle != null) {
            try {
                Class despenserClass = tracePluginBundle.loadClass("org.eclipse.gmf.internal.bridge.trace.MergingIdentifierDispenser");
                Object dispencer = despenserClass.newInstance();
                if (dispencer instanceof StatefulVisualIdentifierDispencer) {
                    StatefulVisualIdentifierDispencer statefulDispencer = (StatefulVisualIdentifierDispencer)dispencer;
                    statefulDispencer.loadState(this.getGenModelURI());
                    return statefulDispencer;
                }
            }
            catch (ClassNotFoundException e) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("MergingIdentifierDispenser was not found in org.eclipse.gmf.bridge.trace bundle", e));
            }
            catch (InstantiationException e) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("MergingIdentifierDispenser was not instantiated", e));
            }
            catch (IllegalAccessException e) {
                CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("IllegalAccessException while instantiating MergingIdentifierDispenser", e));
            }
        }
        return new NaiveIdentifierDispenser();
    }

    private ViewmapProducer detectViewmapProducer(Shell shell) {
        if (!this.checkLiteOptionPresent()) {
            Object strategy = MessageDialog.openQuestion((Shell)shell, (String)"Create Generator Model", (String)"Would you like to use IMapMode?") ? new MapModeCodeGenStrategy.RuntimeUnspecifiedMapMode() : new MapModeCodeGenStrategy.StaticIdentityMapMode();
            return new InnerClassViewmapProducer((FigureQualifiedNameSwitch)new RuntimeFQNSwitch(), (MapModeCodeGenStrategy)strategy);
        }
        FigureGeneratorOptionsDialog dlg = new FigureGeneratorOptionsDialog(shell, "Create Generator Model", true, true);
        if (dlg.open() != 0) {
            return null;
        }
        return new InnerClassViewmapProducer(dlg.getFigureQualifiedNameSwitch(), dlg.getMapModeCodeGenStrategy());
    }

    private boolean checkLiteOptionPresent() {
        return Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
    }

    private DiagramRunTimeModelHelper detectRunTimeModel(ResourceSet resSet) {
        Resource drtGenModelRes;
        BasicDiagramRunTimeModelHelper drtModelHelper = null;
        URI specificRTGenModelURI = this.decideOnRunTimeModel();
        if (specificRTGenModelURI != null && (drtGenModelRes = resSet.getResource(specificRTGenModelURI, true)) != null) {
            GenModel drtGenModel = (GenModel)drtGenModelRes.getContents().get(0);
            drtModelHelper = new SpecificDiagramRunTimeModelHelper(drtGenModel);
        }
        if (drtModelHelper == null) {
            drtModelHelper = new BasicDiagramRunTimeModelHelper();
        }
        return drtModelHelper;
    }

    protected Map getSaveOptions() {
        if (this.mySaveOptions == null) {
            this.mySaveOptions = new HashMap();
            this.mySaveOptions.put("ENCODING", "UTF-8");
        }
        return this.mySaveOptions;
    }

    private IStatus validate(Mapping mapping) {
        return BasicDiagnostic.toIStatus((Diagnostic)Diagnostician.INSTANCE.validate((EObject)mapping));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.myMapFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }

    private void initDestinationFile() {
        this.myDestFile = null;
        IPath destPath = this.myMapFile.getFullPath().removeFileExtension().addFileExtension("gmfgen");
        final IPath destLocation = destPath.removeLastSegments(1);
        String defFileName = destPath.lastSegment();
        InputDialog dlg = new InputDialog(this.getShell(), "Target model file", "Please specify name of the file to save diagram genmodel to", defFileName, new IInputValidator(){

            public String isValid(String newText) {
                IStatus s = ResourcesPlugin.getWorkspace().validatePath(destLocation.append(newText).toOSString(), 1);
                return s.isOK() ? null : s.getMessage();
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        this.myDestFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destLocation.append(dlg.getValue()));
    }

    public IFile getGenModelFile() {
        return this.myDestFile;
    }

    URI getMapModelURI() {
        return URI.createPlatformResourceURI((String)this.myMapFile.getFullPath().toString());
    }

    URI getGenModelURI() {
        return URI.createPlatformResourceURI((String)this.myDestFile.getFullPath().toString());
    }

    private Shell getShell() {
        return this.myPart.getSite().getShell();
    }

    private URI decideOnRunTimeModel() {
        if (THERE_IS_NO_SPECIFIC_RT.booleanValue()) {
            return null;
        }
        IPath p = this.myMapFile.getFullPath();
        String defValue = p.removeLastSegments(1).append(String.valueOf(p.removeFileExtension().lastSegment()) + "-drt").addFileExtension("genmodel").toString();
        InputDialog dlg = new InputDialog(this.getShell(), "Diagram RunTime Model", "Please specify path to genmodel file that describes specific diagram runtime model, or press Cancel if you don't need one", defValue, null);
        if (dlg.open() == 0) {
            return URI.createPlatformResourceURI((String)dlg.getValue());
        }
        return null;
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }

    private class GenModelDetector {
        private GenModelAccess myGMAccess;

        private GenModelDetector() {
        }

        public IStatus find(Shell shell, Mapping mapping) {
            IFile workspaceFile;
            Object next;
            HashSet<EPackage> packages = new HashSet<EPackage>();
            Iterator<Object> it = EcoreUtil.ExternalCrossReferencer.find((EObject)mapping).keySet().iterator();
            while (it.hasNext()) {
                next = it.next();
                if (!(next instanceof EClass)) continue;
                packages.add(((EClass)next).getEPackage());
            }
            it = packages.iterator();
            while (it.hasNext()) {
                next = (EPackage)it.next();
                if (next.getESuperPackage() == null || !EcoreUtil.isAncestor(packages, (EObject)next.getESuperPackage())) continue;
                it.remove();
            }
            if (packages.isEmpty()) {
                this.myGMAccess = new GenModelAccess.Adapter(null);
                return Status.OK_STATUS;
            }
            if (packages.size() == 1) {
                EPackage solePack = (EPackage)packages.iterator().next();
                BasicGenModelAccess gma = new BasicGenModelAccess(solePack);
                gma.initDefault();
                if (gma.load((ResourceSet)new ResourceSetImpl()).isOK()) {
                    gma.unload();
                    this.myGMAccess = gma;
                    return Status.OK_STATUS;
                }
                workspaceFile = this.askGenModelFile(shell, "Can't find genmodel for package " + solePack.getName() + "(" + solePack.getNsURI() + ")");
            } else {
                workspaceFile = this.askGenModelFile(shell, "Need genmodel to cover all referenced domain packages (" + packages.size() + ")");
            }
            if (workspaceFile == null) {
                return Status.CANCEL_STATUS;
            }
            this.myGMAccess = new FileGenModelAccess(workspaceFile);
            return Status.OK_STATUS;
        }

        private IFile askGenModelFile(Shell shell, String message) {
            ResourceSelectionDialog d = new ResourceSelectionDialog(shell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), message);
            if (d.open() != 0) {
                return null;
            }
            Object[] result = d.getResult();
            if (result == null || result.length != 1 || !(result[0] instanceof IFile)) {
                MessageDialog.openError((Shell)shell, (String)"GenModel selection", (String)"Needs exactly one .genmodel file");
                return null;
            }
            return (IFile)result[0];
        }

        public GenModel get(ResourceSet resSet) {
            IStatus s = this.myGMAccess.load(resSet);
            if (!s.isOK()) {
                throw new IllegalStateException(s.getMessage());
            }
            return this.myGMAccess.model();
        }
    }
}

