/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.figures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryProcessor;
import org.eclipse.gmf.tests.CompileUtil;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.RuntimeWorkspaceSetup;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.osgi.framework.Bundle;

public class FigureGeneratorUtil {
    public static final String DEFAULT_FIGURE_PACKAGE = "org.eclipse.gmf.tests.sample.figures";
    public static final String DEFAULT_PLUGIN_ACTIVATOR = "org.eclipse.gmf.tests.sample.figures.PluginActivator";

    public static void generate(StandaloneGenerator.Config config, StandaloneGenerator.Processor processor) {
        StandaloneGenerator generator = new StandaloneGenerator(processor, config, null);
        generator.run();
        Assert.assertTrue((String)generator.getRunStatus().toString(), (generator.getRunStatus().getSeverity() < 4 ? 1 : 0) != 0);
    }

    public static GeneratedClassData[] generateAndCompile(FigureGallery gallery) {
        return FigureGeneratorUtil.generateAndCompile(gallery, FigureGeneratorUtil.createStandaloneGeneratorConfig());
    }

    public static GeneratedClassData[] generateAndCompile(StandaloneGenerator.Config config, RealFigure ... figures) {
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        gallery.setName("bb");
        gallery.getFigures().addAll(Arrays.asList(figures));
        return FigureGeneratorUtil.generateAndCompile(gallery, config);
    }

    public static GeneratedClassData[] generateAndCompile(final FigureGallery gallery, StandaloneGenerator.Config config) {
        Assert.assertTrue((gallery.getName() != null && gallery.getName().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((gallery.getFigures().isEmpty() && gallery.getDescriptors().isEmpty() ? 1 : 0) != 0);
        final HashMap fqns = new HashMap();
        FigureGeneratorUtil.generate(config, (StandaloneGenerator.Processor)new GalleryProcessor(gallery){

            public void go(StandaloneGenerator.ProcessorCallback callback, StandaloneGenerator.Config config) throws InterruptedException {
                super.go(callback, config);
                for (RealFigure f : gallery.getFigures()) {
                    FigureRef fr = GMFGraphFactory.eINSTANCE.createFigureRef();
                    fr.setFigure(f);
                    FigureDescriptor fakeDesc = DiaDefSetup.newDescriptor(f.getName(), (Figure)fr);
                    String fqn = callback.visitFigure(fakeDesc);
                    this.handle(fakeDesc, fqn);
                }
            }

            protected void handle(FigureDescriptor next, String fqn) {
                fqns.put(next, fqn);
            }
        });
        try {
            Bundle bundle = FigureGeneratorUtil.installPlugin(config.getPluginID());
            ArrayList<GeneratedClassData> result = new ArrayList<GeneratedClassData>();
            for (FigureDescriptor next : fqns.keySet()) {
                result.add(new GeneratedClassData(next, bundle.loadClass((String)fqns.get(next))));
            }
            return result.toArray(new GeneratedClassData[result.size()]);
        }
        catch (Exception e) {
            Assert.fail((String)(String.valueOf(e.getClass().getSimpleName()) + ":" + e.getMessage()));
            Assert.fail((String)"Should not be here!");
            return null;
        }
    }

    public static Bundle installPlugin(String pluginId) throws CoreException, Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        IStatus compileStatus = new CompileUtil().build(project);
        Assert.assertTrue((String)compileStatus.getMessage(), (compileStatus.getSeverity() < 4 ? 1 : 0) != 0);
        RuntimeWorkspaceSetup.get().getReadyToStartAsBundle(project);
        String url = project.getLocation().toFile().toURL().toExternalForm();
        return Plugin.getBundleContext().installBundle(url);
    }

    public static void generateAndParse(RealFigure f) {
        FigureGeneratorUtil.generateAndParse(f, new FigureGenerator(null, DEFAULT_FIGURE_PACKAGE, false));
    }

    public static void generateAndParse(FigureDescriptor f) {
        FigureGeneratorUtil.generateAndParse(f, new FigureGenerator(null, DEFAULT_FIGURE_PACKAGE, false));
    }

    public static void generateAndParse(RealFigure f, FigureGenerator generator) {
        FigureDescriptor fd = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        FigureRef fr = GMFGraphFactory.eINSTANCE.createFigureRef();
        fr.setFigure(f);
        fd.setActualFigure((Figure)fr);
        fd.setName(f.getName());
        FigureGeneratorUtil.generateAndParse(fd, generator);
    }

    public static void generateAndParse(FigureDescriptor fd, FigureGenerator generator) {
        String res = generator.go(fd);
        Assert.assertNotNull((String)"Generation should produce code", (Object)res);
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(res.toCharArray());
        ASTNode astNode = p.createAST(null);
        Assert.assertEquals((String)"Generator is expected to produce cu", (int)astNode.getNodeType(), (int)15);
        CompilationUnit cu = (CompilationUnit)astNode;
        if (generator.getPackageName() != null) {
            Assert.assertNotNull((String)"Generator initialized with packageName should produce package statement", (Object)cu.getPackage());
            Assert.assertEquals((String)"Package names are different", (String)generator.getPackageName(), (String)cu.getPackage().getName().getFullyQualifiedName());
        } else {
            Assert.assertNull((Object)cu.getPackage());
        }
        IProblem[] problems = cu.getProblems();
        int i = 0;
        while (i < problems.length) {
            Assert.assertFalse((String)(String.valueOf(problems[i].getMessage()) + ", line:" + problems[i].getSourceLineNumber() + ", pos:" + cu.getColumnNumber(problems[i].getSourceStart())), (boolean)problems[i].isError());
            ++i;
        }
    }

    public static StandaloneGenerator.Config createStandaloneGeneratorConfig() {
        return new StandaloneGenerator.ConfigImpl(FigureGeneratorUtil.createTestPluginName(), DEFAULT_FIGURE_PACKAGE);
    }

    public static StandaloneGenerator.Config createStandaloneGeneratorConfig(String packageName, boolean useMapMode) {
        return new StandaloneGenerator.ConfigImpl(FigureGeneratorUtil.createTestPluginName(), packageName, useMapMode ? MapModeCodeGenStrategy.DYNAMIC : MapModeCodeGenStrategy.STATIC, null);
    }

    private static String createTestPluginName() {
        return "org.eclipse.gmf.tests.sample.figures.t" + System.currentTimeMillis();
    }

    public static ConstantColor createConstantColor(ColorConstants constant) {
        ConstantColor result = GMFGraphFactory.eINSTANCE.createConstantColor();
        result.setValue(constant);
        return result;
    }

    public static RGBColor createRGBColor(int red, int green, int blue) {
        RGBColor result = GMFGraphFactory.eINSTANCE.createRGBColor();
        result.setRed(red);
        result.setGreen(green);
        result.setBlue(blue);
        return result;
    }

    public static Font createBasicFont(String name, int height, FontStyle style) {
        BasicFont result = GMFGraphFactory.eINSTANCE.createBasicFont();
        result.setFaceName(name);
        result.setHeight(height);
        result.setStyle(style);
        return result;
    }

    public static Dimension createDimension(int dx, int dy) {
        Dimension result = GMFGraphFactory.eINSTANCE.createDimension();
        result.setDx(dx);
        result.setDy(dy);
        return result;
    }

    public static Point createPoint(int x, int y) {
        Point point = GMFGraphFactory.eINSTANCE.createPoint();
        point.setX(x);
        point.setY(y);
        return point;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeneratedClassData {
        private final FigureDescriptor myFigureDef;
        private final Class<?> myLoadedClass;

        public GeneratedClassData(FigureDescriptor figureDef, Class<?> loadedClass) {
            this.myFigureDef = figureDef;
            this.myLoadedClass = loadedClass;
        }

        public Class<?> getLoadedClass() {
            return this.myLoadedClass;
        }

        public FigureDescriptor getFigureDef() {
            return this.myFigureDef;
        }
    }
}

