/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.eclipse.gmf.tests.setup.figures.FigureCheck;
import org.eclipse.gmf.tests.setup.figures.FigureCodegenSetup;
import org.eclipse.gmf.tests.setup.figures.GenericFigureCheck;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureCodegenTest
extends FigureCodegenTestBase<FigureCodegenSetup> {
    public FigureCodegenTest(String name) {
        super(name);
    }

    public void testGenPolylineConnection() {
        final org.eclipse.gmf.gmfgraph.PolylineConnection f = ((FigureCodegenSetup)this.getSessionSetup()).getEcoreContainmentRef();
        this.performTests((RealFigure)f, (FigureCheck)new GenericFigureCheck(null){

            protected void checkFigure(IFigure figure) {
                1.assertTrue((boolean)(figure instanceof PolylineConnectionEx));
                1.assertTrue((boolean)(figure.getChildren().get(0) instanceof PolygonDecoration));
                this.checkFigure((Figure)f.getSourceDecoration(), (IFigure)((PolygonDecoration)figure.getChildren().get(0)));
            }
        });
    }

    public void testGenCustomFigure() {
        RealFigure f = ((FigureCodegenSetup)this.getSessionSetup()).getCustomFigure();
        this.performTests(f, (FigureCheck)new GenericFigureCheck((Figure)f));
    }

    public void testGenSimpleShape() {
        RealFigure f = ((FigureCodegenSetup)this.getSessionSetup()).getSimpleShape();
        this.performTests(f, (FigureCheck)new GenericFigureCheck((Figure)f));
    }

    public void testGenComplexShape() {
        RealFigure f = ((FigureCodegenSetup)this.getSessionSetup()).getComplexShape();
        this.performTests(f, (FigureCheck)new GenericFigureCheck((Figure)f));
    }

    public void testGenCustomFigureWithAttributes() {
        GenericFigureCheck defaultCheckWithoutChildren = new GenericFigureCheck((Figure)((FigureCodegenSetup)this.getSessionSetup()).getResult2()){

            protected void checkFigure(IFigure figure) {
                2.assertTrue((boolean)(figure instanceof ScrollBar));
                ScrollBar custom = (ScrollBar)figure;
                2.assertEquals((int)1, (int)custom.getMinimum());
                2.assertEquals((int)99, (int)custom.getMaximum());
                2.assertTrue((boolean)custom.isHorizontal());
                2.assertEquals((Object)new Dimension(100, 100), (Object)custom.getPreferredSize());
                super.checkFigure(figure);
            }

            protected void checkFigureChildren(Figure gmfFigure, IFigure d2dFigure) {
            }
        };
        this.performTests((RealFigure)((FigureCodegenSetup)this.getSessionSetup()).getResult2(), (FigureCheck)defaultCheckWithoutChildren);
    }

    public void testGenCustomDecoration() {
        FigureCheck customCheck = new FigureCheck(){

            protected void checkFigure(IFigure figure) {
                3.assertTrue((boolean)(figure instanceof PolygonDecoration));
                PolygonDecoration decoration = (PolygonDecoration)figure;
                3.assertTrue((boolean)Arrays.equals(PolygonDecoration.TRIANGLE_TIP.toIntArray(), decoration.getPoints().toIntArray()));
            }
        };
        this.performTests((RealFigure)((FigureCodegenSetup)this.getSessionSetup()).getResult1(), customCheck.chain(new GenericFigureCheck((Figure)((FigureCodegenSetup)this.getSessionSetup()).getResult1())));
    }

    public void testGenCustomConnection() {
        GenericFigureCheck constraintCheck = new GenericFigureCheck((Figure)((FigureCodegenSetup)this.getSessionSetup()).getResult()){

            protected void checkFigureItself(Figure gmfFigure, IFigure d2dFigure) {
                4.assertTrue((String)"Assume tests are creating figures with names", (boolean)(gmfFigure instanceof RealFigure));
                4.assertEquals((String)"Only one figure expected", (String)((FigureCodegenSetup)FigureCodegenTest.this.getSessionSetup()).getResult().getName(), (String)((RealFigure)gmfFigure).getName());
                super.checkFigureItself(gmfFigure, d2dFigure);
                this.checkConstraint(d2dFigure);
            }

            private void checkConstraint(IFigure figure) {
                4.assertTrue((boolean)(figure instanceof PolylineConnection));
                PolylineConnection decoration = (PolylineConnection)figure;
                4.assertTrue((boolean)(decoration.getConnectionRouter() instanceof BendpointConnectionRouter));
                4.assertEquals((Object)new Integer(42), (Object)decoration.getRoutingConstraint());
            }
        };
        this.performTests((RealFigure)((FigureCodegenSetup)this.getSessionSetup()).getResult(), (FigureCheck)constraintCheck);
    }

    public void testCustomFigureWithSameNameAsReferredClassName() {
        this.performTests((RealFigure)((FigureCodegenSetup)this.getSessionSetup()).getCustom(), FigureCheck.CHECK_CAN_CREATE_INSTANCE);
    }

    public void testFigureWithTwoBorderedChildren() {
        StaticFieldsChecker staticFieldsCheck = new StaticFieldsChecker(1, Color.class);
        this.performTests(((FigureCodegenSetup)this.getSessionSetup()).getRoot1(), new GenericFigureCheck((Figure)((FigureCodegenSetup)this.getSessionSetup()).getRoot1()).chain(staticFieldsCheck));
    }

    public void testFigureWithStaticFieldsForColorAndFonts() {
        StaticFieldsChecker fontFieldsCheck = new StaticFieldsChecker(4, Font.class);
        StaticFieldsChecker colorFieldsCheck = new StaticFieldsChecker(2, Color.class);
        this.performTests(((FigureCodegenSetup)this.getSessionSetup()).getRoot(), fontFieldsCheck.chain(colorFieldsCheck));
    }

    public void testConnectionWithColor() {
        StaticFieldsChecker colorFieldsCheck = new StaticFieldsChecker(1, Color.class);
        this.performTests((RealFigure)((FigureCodegenSetup)this.getSessionSetup()).getLink(), (FigureCheck)colorFieldsCheck);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StaticFieldsChecker
    extends FigureCheck {
        private final int myExpectedFieldCount;
        private final Class<?> myFieldClazz;

        public StaticFieldsChecker(int expectedFieldCount, Class<?> fieldClazz) {
            this.myExpectedFieldCount = expectedFieldCount;
            this.myFieldClazz = fieldClazz;
        }

        @Override
        protected void checkFigure(IFigure figure) {
            Class<?> figureClazz = figure.getClass();
            Field[] fields = figureClazz.getDeclaredFields();
            int staticFinalFields = 0;
            int i = 0;
            while (i < fields.length) {
                Field next = fields[i];
                int modifiers = next.getModifiers();
                if (this.myFieldClazz.equals(next.getType()) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                    ++staticFinalFields;
                }
                ++i;
            }
            StaticFieldsChecker.assertTrue((String)("Expected: at least " + this.myExpectedFieldCount + " constants of type :" + this.myFieldClazz.getName() + ". Actual: " + staticFinalFields), (staticFinalFields >= this.myExpectedFieldCount ? 1 : 0) != 0);
        }
    }
}

