/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.tests.setup.DiaDefSource;

public class DiaDefSetup
implements DiaDefSource {
    private Canvas myCanvasDef;
    private Node myNodeDef;
    private Connection myLinkDef;
    private FigureGallery myFigureContainer;
    private DiagramLabel myLabelDef;
    private Connection myColoredLinkDef;
    private Node myColoredNodeDef;
    private Compartment myCompartmentA;
    private Compartment myCompartmentB;
    private DiagramLabel myDecoratedLabelDef;

    public final DiaDefSetup init() {
        this.myCanvasDef = GMFGraphFactory.eINSTANCE.createCanvas();
        this.myNodeDef = GMFGraphFactory.eINSTANCE.createNode();
        this.myLinkDef = GMFGraphFactory.eINSTANCE.createConnection();
        this.myLabelDef = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        this.myFigureContainer = GMFGraphFactory.eINSTANCE.createFigureGallery();
        this.myColoredLinkDef = GMFGraphFactory.eINSTANCE.createConnection();
        this.myColoredNodeDef = GMFGraphFactory.eINSTANCE.createNode();
        this.myCompartmentA = GMFGraphFactory.eINSTANCE.createCompartment();
        this.myCompartmentB = GMFGraphFactory.eINSTANCE.createCompartment();
        this.myDecoratedLabelDef = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        this.myFigureContainer.setName("fc1");
        this.myCanvasDef.getFigures().add((Object)this.myFigureContainer);
        this.myCanvasDef.getNodes().add((Object)this.myNodeDef);
        this.myCanvasDef.getConnections().add((Object)this.myLinkDef);
        this.myCanvasDef.getLabels().add((Object)this.myLabelDef);
        this.myCanvasDef.getConnections().add((Object)this.myColoredLinkDef);
        this.myCanvasDef.getNodes().add((Object)this.myColoredNodeDef);
        this.myCanvasDef.getCompartments().add((Object)this.myCompartmentA);
        this.myCanvasDef.getCompartments().add((Object)this.myCompartmentB);
        this.myCanvasDef.getLabels().add((Object)this.myDecoratedLabelDef);
        this.commonSetupCanvasDef(this.myCanvasDef);
        this.commonSetupNodeDef(this.myNodeDef);
        this.commonSetupLinkDef(this.myLinkDef);
        this.commonSetupLabelDef(this.myLabelDef);
        this.commonSetupColoredLinkDef(this.myColoredLinkDef);
        this.commonSetupColoredNodeDef(this.myColoredNodeDef);
        this.commonSetupCompartmentA(this.myCompartmentA);
        this.commonSetupCompartmentB(this.myCompartmentB);
        this.commonSetupDecoratedLabelDef(this.myDecoratedLabelDef);
        this.setupCanvasDef(this.myCanvasDef);
        this.setupNodeDef(this.myNodeDef);
        this.setupLinkDef(this.myLinkDef);
        this.setupLabelDef(this.myLabelDef);
        this.setupColoredLinkDef(this.myColoredLinkDef);
        this.setupColoredNodeDef(this.myColoredNodeDef);
        this.setupCompartmentA(this.myCompartmentA);
        this.setupCompartmentB(this.myCompartmentB);
        this.setupDecoratedLabelDef(this.myDecoratedLabelDef);
        this.confineInResource();
        return this;
    }

    private void commonSetupDecoratedLabelDef(DiagramLabel label) {
        label.setName("DiagramLabelWithFont");
        Label labelFigure = GMFGraphFactory.eINSTANCE.createLabel();
        labelFigure.setText("LabelText");
        label.setFigure(DiaDefSetup.newDescriptor("LabelWithFont", (Figure)labelFigure));
        BasicFont font = GMFGraphFactory.eINSTANCE.createBasicFont();
        font.setFaceName("Arial");
        font.setHeight(18);
        font.setStyle(FontStyle.BOLD_LITERAL);
        labelFigure.setFont((Font)font);
        this.myFigureContainer.getDescriptors().add((Object)label.getFigure());
    }

    private void commonSetupCompartmentA(Compartment compartment) {
        compartment.setName("Compartment_Title_Collapse");
        compartment.setNeedsTitle(true);
        compartment.setCollapsible(true);
        Rectangle compartmentFigure = GMFGraphFactory.eINSTANCE.createRectangle();
        compartment.setFigure(DiaDefSetup.newDescriptor("CompartmentFigureA", (Figure)compartmentFigure));
        this.myFigureContainer.getDescriptors().add((Object)compartment.getFigure());
    }

    private void commonSetupCompartmentB(Compartment compartment) {
        compartment.setName("Compartment_NoTitle_No_Collapse");
        compartment.setNeedsTitle(false);
        compartment.setCollapsible(false);
        Rectangle compartmentFigure = GMFGraphFactory.eINSTANCE.createRectangle();
        compartment.setFigure(DiaDefSetup.newDescriptor("CompartmentFigureB", (Figure)compartmentFigure));
        this.myFigureContainer.getDescriptors().add((Object)compartment.getFigure());
    }

    private void commonSetupColoredNodeDef(Node coloredNodeDef) {
        coloredNodeDef.setName("ColoredRectangleNode");
        Rectangle rect = GMFGraphFactory.eINSTANCE.createRectangle();
        coloredNodeDef.setFigure(DiaDefSetup.newDescriptor("ColoredRectangle", (Figure)rect));
        rect.setForegroundColor(this.createColor(ColorConstants.RED_LITERAL));
        rect.setBackgroundColor(this.createColor(ColorConstants.BLUE_LITERAL));
        this.myFigureContainer.getDescriptors().add((Object)coloredNodeDef.getFigure());
    }

    private void commonSetupColoredLinkDef(Connection coloredLinkDef) {
        coloredLinkDef.setName("ColoredLinkConnection");
        PolylineConnection pc = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        coloredLinkDef.setFigure(DiaDefSetup.newDescriptor("ColoredLink", (Figure)pc));
        pc.setForegroundColor(this.createColor(ColorConstants.ORANGE_LITERAL));
        this.myFigureContainer.getDescriptors().add((Object)coloredLinkDef.getFigure());
    }

    private Color createColor(ColorConstants color) {
        ConstantColor result = GMFGraphFactory.eINSTANCE.createConstantColor();
        result.setValue(color);
        return result;
    }

    private void confineInResource() {
        new ResourceImpl(URI.createURI((String)"uri://org.eclipse.gmf/tests/GMFGraphSetup")).getContents().add((Object)this.myCanvasDef);
    }

    private void commonSetupCanvasDef(Canvas canvasDef) {
        canvasDef.setName("Test-dd-canvas");
    }

    private void commonSetupNodeDef(Node nodeDef) {
        nodeDef.setName("Test-dd-node");
        nodeDef.setFigure(DiaDefSetup.newDescriptor("nf1", (Figure)GMFGraphFactory.eINSTANCE.createRoundedRectangle()));
        this.myFigureContainer.getDescriptors().add((Object)nodeDef.getFigure());
    }

    private void commonSetupLinkDef(Connection linkDef) {
        linkDef.setName("Test-dd-link");
        linkDef.setFigure(DiaDefSetup.newDescriptor("lf1", (Figure)GMFGraphFactory.eINSTANCE.createPolylineConnection()));
        this.myFigureContainer.getDescriptors().add((Object)linkDef.getFigure());
    }

    private void commonSetupLabelDef(DiagramLabel labelDef) {
        labelDef.setName("TestLabel");
        Label figure = GMFGraphFactory.eINSTANCE.createLabel();
        labelDef.setFigure(DiaDefSetup.newDescriptor("LabelFig", (Figure)figure));
        this.myFigureContainer.getDescriptors().add((Object)labelDef.getFigure());
    }

    protected void setupCanvasDef(Canvas canvasDef) {
    }

    protected void setupNodeDef(Node nodeDef) {
    }

    protected void setupLinkDef(Connection linkDef) {
    }

    protected void setupLabelDef(DiagramLabel labelDef) {
    }

    public void setupColoredLinkDef(Connection myColoredLinkDef2) {
    }

    public void setupColoredNodeDef(Node myColoredNodeDef2) {
    }

    private void setupCompartmentA(Compartment compartment) {
    }

    private void setupCompartmentB(Compartment compartment) {
    }

    private void setupDecoratedLabelDef(DiagramLabel myDecoratedLabelDef2) {
    }

    public final Canvas getCanvasDef() {
        return this.myCanvasDef;
    }

    public final Connection getLinkDef() {
        return this.myLinkDef;
    }

    public final Node getNodeDef() {
        return this.myNodeDef;
    }

    public final DiagramLabel getLabelDef() {
        return this.myLabelDef;
    }

    public final FigureGallery getFigureContainer() {
        return this.myFigureContainer;
    }

    public Connection getColoredLinkDef() {
        return this.myColoredLinkDef;
    }

    public Node getColoredNodeDef() {
        return this.myColoredNodeDef;
    }

    public Compartment getCompartmentA() {
        return this.myCompartmentA;
    }

    public Compartment getCompartmentB() {
        return this.myCompartmentB;
    }

    public DiagramLabel getDecoratedLabelDef() {
        return this.myDecoratedLabelDef;
    }

    public static FigureDescriptor newDescriptor(String name, Figure fig) {
        assert (name != null);
        FigureDescriptor fd = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        fd.setActualFigure(fig);
        fd.setName(name);
        return fd;
    }

    public static FigureDescriptor newDescriptor(RealFigure fig) {
        return DiaDefSetup.newDescriptor(fig.getName(), (Figure)fig);
    }

    public static ChildAccess newAccess(FigureDescriptor fd, RealFigure child) {
        ChildAccess ca = GMFGraphFactory.eINSTANCE.createChildAccess();
        ca.setFigure((Figure)child);
        fd.getAccessors().add((Object)ca);
        return ca;
    }
}

