/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.migration;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.codegen.util.Migrate2008;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.tests.migration.MigrationPatchesTest;

public class TestCustomCopier
extends TestCase {
    private EPackage gmfgen_2008;
    private EClass cGenEditorGenerator;
    private EClass cGenDiagram;
    private EClass cGenAuditRule;
    private EClass cGenExpressionInterpreter;
    private EClass cGenJavaExpressionProvider;
    private EClass cValueExpression;
    private EClass cGenMetricRule;
    private EEnum eGenLanguage;
    private EClass cGenLink;
    private EClass cGenChildNode;
    private EClass cGenLinkConstraints;
    private EClass cTypeModelFacet;
    private EClass cGenFeatureSeqInitializer;
    private EClass cGenFeatureValueSpec;

    public TestCustomCopier(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.gmfgen_2008 = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/gmf/2008/GenModel");
        this.cGenEditorGenerator = (EClass)this.gmfgen_2008.getEClassifier("GenEditorGenerator");
        this.cGenDiagram = (EClass)this.gmfgen_2008.getEClassifier("GenDiagram");
        this.cGenAuditRule = (EClass)this.gmfgen_2008.getEClassifier("GenAuditRule");
        this.cGenExpressionInterpreter = (EClass)this.gmfgen_2008.getEClassifier("GenExpressionInterpreter");
        this.cGenJavaExpressionProvider = (EClass)this.gmfgen_2008.getEClassifier("GenJavaExpressionProvider");
        this.cValueExpression = (EClass)this.gmfgen_2008.getEClassifier("ValueExpression");
        this.cGenMetricRule = (EClass)this.gmfgen_2008.getEClassifier("GenMetricRule");
        this.eGenLanguage = (EEnum)this.gmfgen_2008.getEClassifier("GenLanguage");
        this.cGenLink = (EClass)this.gmfgen_2008.getEClassifier("GenLink");
        this.cGenChildNode = (EClass)this.gmfgen_2008.getEClassifier("GenChildNode");
        this.cGenLinkConstraints = (EClass)this.gmfgen_2008.getEClassifier("GenLinkConstraints");
        this.cTypeModelFacet = (EClass)this.gmfgen_2008.getEClassifier("TypeModelFacet");
        this.cGenFeatureSeqInitializer = (EClass)this.gmfgen_2008.getEClassifier("GenFeatureSeqInitializer");
        this.cGenFeatureValueSpec = (EClass)this.gmfgen_2008.getEClassifier("GenFeatureValueSpec");
    }

    public void test06to08ModelTransform() throws Exception {
        URI uri = MigrationPatchesTest.createURI("228913-copier.gmfgen#/");
        Resource r = new ToolingResourceFactory().createResource(uri.trimFragment());
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getResources().add((Object)r);
        EObject testRoot = rset.getEObject(uri, true);
        Migrate2008 m = new Migrate2008();
        EObject newGenModel = m.go(testRoot);
        TestCustomCopier.assertTrue((boolean)m.wasMigrationApplied());
        this.checkTestModel(newGenModel);
    }

    private void checkTestModel(EObject editorGen) throws Exception {
        EPackage p = editorGen.eClass().getEPackage();
        TestCustomCopier.assertEquals((String)this.gmfgen_2008.getNsURI(), (String)p.getNsURI());
        TestCustomCopier.assertEquals((Object)this.cGenEditorGenerator, (Object)editorGen.eClass());
        EStructuralFeature aGenExpressionInterpreter_Language = this.cGenExpressionInterpreter.getEStructuralFeature("language");
        EStructuralFeature aValueExpression_Body = this.cValueExpression.getEStructuralFeature("body");
        EStructuralFeature rValueExpression_Provider = this.cValueExpression.getEStructuralFeature("provider");
        EObject auditRoot = (EObject)editorGen.eGet(editorGen.eClass().getEStructuralFeature("audits"));
        TestCustomCopier.assertNotNull((Object)auditRoot);
        List auditRules = (List)auditRoot.eGet(auditRoot.eClass().getEStructuralFeature("rules"));
        TestCustomCopier.assertEquals((int)1, (int)auditRules.size());
        EObject aud1 = (EObject)auditRules.get(0);
        EObject aud1VE = (EObject)aud1.eGet(this.cGenAuditRule.getEStructuralFeature("rule"));
        TestCustomCopier.assertNotNull((Object)aud1VE);
        TestCustomCopier.assertEquals((Object)"audit1", (Object)aud1VE.eGet(aValueExpression_Body));
        EObject aud1VEprov = (EObject)aud1VE.eGet(rValueExpression_Provider);
        TestCustomCopier.assertNotNull((Object)aud1VEprov);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("ocl"), (Object)aud1VEprov.eGet(aGenExpressionInterpreter_Language));
        EObject metricsContainer = (EObject)editorGen.eGet(this.cGenEditorGenerator.getEStructuralFeature("metrics"));
        TestCustomCopier.assertNotNull((Object)metricsContainer);
        List metricsRules = (List)metricsContainer.eGet(metricsContainer.eClass().getEStructuralFeature("metrics"));
        TestCustomCopier.assertEquals((int)1, (int)metricsRules.size());
        EObject met1VE = (EObject)((EObject)metricsRules.get(0)).eGet(this.cGenMetricRule.getEStructuralFeature("rule"));
        TestCustomCopier.assertNotNull((Object)met1VE);
        TestCustomCopier.assertEquals((Object)"audit1", (Object)met1VE.eGet(aValueExpression_Body));
        EObject met1VEprov = (EObject)met1VE.eGet(rValueExpression_Provider);
        TestCustomCopier.assertNotNull((Object)met1VEprov);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("ocl"), (Object)met1VEprov.eGet(aGenExpressionInterpreter_Language));
        TestCustomCopier.assertEquals((Object)aud1VEprov, (Object)met1VEprov);
        TestCustomCopier.assertTrue((aud1VEprov == met1VEprov ? 1 : 0) != 0);
        TestCustomCopier.assertEquals((Object)met1VE, (Object)aud1VE);
        TestCustomCopier.assertTrue((met1VE == aud1VE ? 1 : 0) != 0);
        EObject diagram = (EObject)editorGen.eGet(this.cGenEditorGenerator.getEStructuralFeature("diagram"));
        TestCustomCopier.assertNotNull((Object)diagram);
        List links = (List)diagram.eGet(this.cGenDiagram.getEStructuralFeature("links"));
        TestCustomCopier.assertEquals((int)2, (int)links.size());
        EObject link1 = (EObject)links.get(0);
        TestCustomCopier.assertNotNull((Object)link1);
        EObject csts1 = (EObject)link1.eGet(this.cGenLink.getEStructuralFeature("creationConstraints"));
        TestCustomCopier.assertNotNull((Object)csts1);
        TestCustomCopier.assertNull((Object)csts1.eGet(this.cGenLinkConstraints.getEStructuralFeature("targetEnd")));
        EObject src1 = (EObject)csts1.eGet(this.cGenLinkConstraints.getEStructuralFeature("sourceEnd"));
        TestCustomCopier.assertNotNull((Object)src1);
        TestCustomCopier.assertEquals((Object)"source_link1", (Object)src1.eGet(aValueExpression_Body));
        EObject src1prov = (EObject)src1.eGet(rValueExpression_Provider);
        TestCustomCopier.assertNotNull((Object)src1prov);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("nregexp"), (Object)src1prov.eGet(aGenExpressionInterpreter_Language));
        EObject link2 = (EObject)links.get(1);
        EObject csts2 = (EObject)link2.eGet(this.cGenLink.getEStructuralFeature("creationConstraints"));
        TestCustomCopier.assertNotNull((Object)csts2);
        TestCustomCopier.assertNull((Object)csts2.eGet(this.cGenLinkConstraints.getEStructuralFeature("sourceEnd")));
        EObject trg2 = (EObject)csts2.eGet(this.cGenLinkConstraints.getEStructuralFeature("targetEnd"));
        TestCustomCopier.assertNotNull((Object)trg2);
        TestCustomCopier.assertEquals((Object)"target_link2", (Object)trg2.eGet(aValueExpression_Body));
        EObject trg2prov = (EObject)trg2.eGet(rValueExpression_Provider);
        TestCustomCopier.assertNotNull((Object)trg2prov);
        TestCustomCopier.assertEquals((Object)this.cGenJavaExpressionProvider, (Object)trg2prov.eClass());
        List nodes = (List)diagram.eGet(this.cGenDiagram.getEStructuralFeature("childNodes"));
        TestCustomCopier.assertEquals((int)2, (int)nodes.size());
        EObject node1 = (EObject)nodes.get(0);
        TestCustomCopier.assertNotNull((Object)node1);
        EObject fac1 = (EObject)node1.eGet(this.cGenChildNode.getEStructuralFeature("modelFacet"));
        TestCustomCopier.assertNotNull((Object)fac1);
        EObject node1cstr = (EObject)fac1.eGet(this.cTypeModelFacet.getEStructuralFeature("modelElementSelector"));
        TestCustomCopier.assertNotNull((Object)node1cstr);
        TestCustomCopier.assertEquals((Object)"node1", (Object)node1cstr.eGet(aValueExpression_Body));
        EObject node1cstrProv = (EObject)node1cstr.eGet(rValueExpression_Provider);
        TestCustomCopier.assertNotNull((Object)node1cstrProv);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("ocl"), (Object)node1cstrProv.eGet(aGenExpressionInterpreter_Language));
        TestCustomCopier.assertEquals((Object)aud1VEprov, (Object)node1cstrProv);
        EObject node2 = (EObject)nodes.get(1);
        TestCustomCopier.assertNotNull((Object)node2);
        EObject fac2 = (EObject)node2.eGet(this.cGenChildNode.getEStructuralFeature("modelFacet"));
        TestCustomCopier.assertNotNull((Object)fac2);
        EObject ir2 = (EObject)fac2.eGet(this.cTypeModelFacet.getEStructuralFeature("modelElementInitializer"));
        TestCustomCopier.assertEquals((Object)this.cGenFeatureSeqInitializer, (Object)ir2.eClass());
        List featureInitializers = (List)ir2.eGet(this.cGenFeatureSeqInitializer.getEStructuralFeature("initializers"));
        TestCustomCopier.assertEquals((int)1, (int)featureInitializers.size());
        EObject fvs1 = (EObject)featureInitializers.get(0);
        TestCustomCopier.assertEquals((Object)this.cGenFeatureValueSpec, (Object)fvs1.eClass());
        EObject node2ve = (EObject)fvs1.eGet(this.cGenFeatureValueSpec.getEStructuralFeature("value"));
        TestCustomCopier.assertNotNull((Object)node2ve);
        TestCustomCopier.assertEquals((Object)"node2", (Object)node2ve.eGet(aValueExpression_Body));
        EObject node2veProv = (EObject)node2ve.eGet(rValueExpression_Provider);
        TestCustomCopier.assertNotNull((Object)node2veProv);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("regexp"), (Object)node2veProv.eGet(aGenExpressionInterpreter_Language));
        EObject exprProviderContainer = (EObject)editorGen.eGet(this.cGenEditorGenerator.getEStructuralFeature("expressionProviders"));
        TestCustomCopier.assertNotNull((Object)exprProviderContainer);
        List providers = (List)exprProviderContainer.eGet(exprProviderContainer.eClass().getEStructuralFeature("providers"));
        TestCustomCopier.assertEquals((int)4, (int)providers.size());
        TestCustomCopier.assertEquals((Object)this.cGenExpressionInterpreter, (Object)((EObject)providers.get(0)).eClass());
        TestCustomCopier.assertEquals((Object)this.cGenExpressionInterpreter, (Object)((EObject)providers.get(1)).eClass());
        TestCustomCopier.assertEquals((Object)this.cGenExpressionInterpreter, (Object)((EObject)providers.get(2)).eClass());
        TestCustomCopier.assertEquals((Object)this.cGenJavaExpressionProvider, (Object)((EObject)providers.get(3)).eClass());
        EStructuralFeature rGenExpressionProviderBase_Expressions = this.cGenExpressionInterpreter.getEStructuralFeature("expressions");
        EObject pr1 = (EObject)providers.get(0);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("ocl"), (Object)pr1.eGet(aGenExpressionInterpreter_Language));
        TestCustomCopier.assertEquals((int)2, (int)((List)pr1.eGet(rGenExpressionProviderBase_Expressions)).size());
        EObject pr2 = (EObject)providers.get(1);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("regexp"), (Object)pr2.eGet(aGenExpressionInterpreter_Language));
        TestCustomCopier.assertEquals((int)1, (int)((List)pr2.eGet(rGenExpressionProviderBase_Expressions)).size());
        EObject pr3 = (EObject)providers.get(2);
        TestCustomCopier.assertEquals((Object)this.eGenLanguage.getEEnumLiteral("nregexp"), (Object)pr3.eGet(aGenExpressionInterpreter_Language));
        TestCustomCopier.assertEquals((int)1, (int)((List)pr3.eGet(rGenExpressionProviderBase_Expressions)).size());
        EObject pr4 = (EObject)providers.get(3);
        TestCustomCopier.assertEquals((int)1, (int)((List)pr4.eGet(rGenExpressionProviderBase_Expressions)).size());
    }
}

