/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import org.eclipse.gmf.tests.setup.ToolDefSource;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.ActionKind;
import org.eclipse.gmf.tooldef.BundleImage;
import org.eclipse.gmf.tooldef.ContextMenu;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.Image;
import org.eclipse.gmf.tooldef.ItemBase;
import org.eclipse.gmf.tooldef.ItemRef;
import org.eclipse.gmf.tooldef.MainMenu;
import org.eclipse.gmf.tooldef.MenuAction;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooldef.ToolRegistry;

public class ToolDefSetup
implements ToolDefSource {
    private final MainMenu myMainMenu = GMFToolFactory.eINSTANCE.createMainMenu();
    private final ContextMenu myNodeMenu;
    private final AbstractTool myNodeTool;
    private final AbstractTool myLinkTool;
    private ToolRegistry myRegistry;

    public ToolDefSetup() {
        this.myMainMenu.setTitle("ToolDefSetup");
        this.myMainMenu.getItems().add((Object)ToolDefSetup.createAction("a1"));
        this.myMainMenu.getItems().add((Object)GMFToolFactory.eINSTANCE.createSeparator());
        MenuAction shared = ToolDefSetup.createAction("SharedA2");
        ItemRef ref = GMFToolFactory.eINSTANCE.createItemRef();
        ref.setItem((ItemBase)shared);
        this.myMainMenu.getItems().add((Object)ref);
        this.myNodeMenu = GMFToolFactory.eINSTANCE.createContextMenu();
        this.myNodeMenu.getItems().add((Object)ToolDefSetup.createAction("a3"));
        ref = GMFToolFactory.eINSTANCE.createItemRef();
        ref.setItem((ItemBase)shared);
        this.myNodeMenu.getItems().add((Object)ref);
        this.myNodeTool = this.createTool("Node1");
        this.myLinkTool = this.createTool("Link1");
        Palette p = GMFToolFactory.eINSTANCE.createPalette();
        p.getTools().add((Object)this.myNodeTool);
        p.getTools().add((Object)this.myLinkTool);
        this.myRegistry = GMFToolFactory.eINSTANCE.createToolRegistry();
        this.myRegistry.getSharedActions().add((Object)shared);
        this.myRegistry.getAllMenus().add((Object)this.myMainMenu);
        this.myRegistry.getAllMenus().add((Object)this.myNodeMenu);
        this.myRegistry.setPalette(p);
    }

    private CreationTool createTool(String title) {
        CreationTool t = GMFToolFactory.eINSTANCE.createCreationTool();
        t.setTitle(title);
        return t;
    }

    private static MenuAction createAction(String name) {
        MenuAction a = GMFToolFactory.eINSTANCE.createMenuAction();
        BundleImage i = GMFToolFactory.eINSTANCE.createBundleImage();
        i.setBundle(null);
        i.setPath("/icons/obj16/" + name + ".gif");
        a.setIcon((Image)i);
        a.setKind(ActionKind.CREATE_LITERAL);
        a.setTitle(name);
        return a;
    }

    public ToolRegistry getRegistry() {
        return this.myRegistry;
    }

    public MainMenu getMainMenu() {
        return this.myMainMenu;
    }

    public ContextMenu getNodeContextMenu() {
        return this.myNodeMenu;
    }

    public AbstractTool getNodeCreationTool() {
        return this.myNodeTool;
    }

    public AbstractTool getLinkCreationTool() {
        return this.myLinkTool;
    }

    public Palette getPalette() {
        return (Palette)this.myNodeTool.eContainer();
    }
}

