/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTests
extends TestCase {
    public static final Bundle BUNDLE = Platform.getBundle((String)"org.eclipse.gmf.tests.runtime.emf.core");
    protected IProject project;
    protected TransactionalEditingDomain domain;
    protected Resource testEcoreResource;
    protected EPackage ecoreRoot;
    protected Resource testNotationResource;
    protected Diagram notationRoot;
    protected static final String PROJECT_NAME = "emfcoretests";
    protected static final String ECORE_RESOURCE_NAME = "/emfcoretests/emfcoretests.ecore";
    protected static final String NOTATION_RESOURCE_NAME = "/emfcoretests/emfcorenotationtests.xmi";

    public BaseTests() {
    }

    public BaseTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertsEnabled) {
            BaseTests.fail((String)"Asserts must be enabled for this test case. Add the '-ea' VM argument to proceed.");
        }
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!this.project.exists()) {
            this.project.create(null);
        }
        this.project.open(null);
        this.domain = this.createEditingDomain();
        AbstractEMFOperation op = new AbstractEMFOperation(this.domain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    Resource original = BaseTests.this.domain.loadResource(URI.createURI((String)BUNDLE.getEntry("/test_models/test_model.ecore").toString()).toString());
                    original.setURI(URI.createPlatformResourceURI((String)BaseTests.NOTATION_RESOURCE_NAME, (boolean)true));
                    original.save(Collections.EMPTY_MAP);
                    BaseTests.this.testEcoreResource = original;
                    BaseTests.this.ecoreRoot = (EPackage)BaseTests.this.find(BaseTests.this.testEcoreResource, "root");
                    original = BaseTests.this.domain.loadResource(URI.createURI((String)BUNDLE.getEntry("/test_models/test_notation_model.xmi").toString()).toString());
                    original.setURI(URI.createPlatformResourceURI((String)BaseTests.NOTATION_RESOURCE_NAME, (boolean)true));
                    original.save(Collections.EMPTY_MAP);
                    BaseTests.this.testNotationResource = original;
                    BaseTests.this.notationRoot = (Diagram)BaseTests.this.find(BaseTests.this.testNotationResource, "root");
                }
                catch (IOException e) {
                    BaseTests.fail((String)("Failed to load test model: " + e.getLocalizedMessage()));
                }
                return Status.OK_STATUS;
            }
        };
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BaseTests.fail((String)("Failed to load test model: " + e.getLocalizedMessage()));
        }
    }

    protected TransactionalEditingDomain createEditingDomain() {
        return GMFEditingDomainFactory.getInstance().createEditingDomain();
    }

    protected void tearDown() throws Exception {
        this.ecoreRoot = null;
        if (this.testEcoreResource != null) {
            if (this.testEcoreResource.isLoaded()) {
                this.testEcoreResource.unload();
            }
            if (this.testEcoreResource.getResourceSet() != null) {
                this.testEcoreResource.getResourceSet().getResources().remove((Object)this.testEcoreResource);
            }
            this.testEcoreResource = null;
        }
        if (this.project != null && this.project.exists()) {
            this.project.delete(true, true, null);
        }
        this.project = null;
        this.domain = null;
    }

    protected Resource createTestResource(String name) {
        Resource result = null;
        try {
            InputStream input = BUNDLE.getEntry("/test_models/" + name).openStream();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("emfcoretests/" + name));
            file.create(input, true, null);
            result = this.domain.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
        }
        catch (Exception e) {
            BaseTests.fail((String)("Unexpected exception creating test resource: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected void fail(Exception e) {
        e.printStackTrace();
        BaseTests.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    protected void assertFound(String name) {
        BaseTests.assertNotNull((String)("Did not find " + name), (Object)this.find(this.testEcoreResource, name));
    }

    protected void assertFound(Object start, String name) {
        BaseTests.assertNotNull((String)("Did not find " + name), (Object)this.find(this.testEcoreResource, name));
    }

    protected void assertNotFound(String name) {
        BaseTests.assertNull((String)("Found " + name), (Object)this.find(this.testEcoreResource, name));
    }

    protected void assertNotFound(Object start, String name) {
        BaseTests.assertNull((String)("Found " + name), (Object)this.find(this.testEcoreResource, name));
    }

    protected EObject find(Object start, String qname) {
        EObject result = null;
        Object current = start;
        String[] names = this.tokenize(qname);
        int i = 0;
        while (current != null && i < names.length) {
            String name = names[i];
            result = null;
            for (EObject child : this.getContents(current)) {
                if (!name.equals(this.getName(child))) continue;
                result = child;
                break;
            }
            current = result;
            ++i;
        }
        return result;
    }

    private String getName(EObject object) {
        if (object instanceof ENamedElement) {
            return ((ENamedElement)object).getName();
        }
        if (object instanceof Diagram) {
            return ((Diagram)object).getName();
        }
        return null;
    }

    private List<EObject> getContents(Object object) {
        if (object instanceof EObject) {
            return ((EObject)object).eContents();
        }
        if (object instanceof Resource) {
            return ((Resource)object).getContents();
        }
        return Collections.emptyList();
    }

    private String[] tokenize(String qname) {
        return qname.split("/");
    }
}

