/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui;

import junit.framework.TestCase;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class MapModeUtilTest
extends TestCase {
    public void testTranslationDefault() {
        this.verifyMapMode(MapModeUtil.getMapMode());
    }

    public void testTranslationHiMetric() {
        this.verifyMapMode(MapModeTypes.HIMETRIC_MM);
    }

    public void testTranslationIdentity() {
        this.verifyMapMode(MapModeTypes.IDENTITY_MM);
    }

    public void testTranslationFromFigure() {
        MapModeFigure mmFig = new MapModeFigure();
        this.verifyMapMode(MapModeUtil.getMapMode((IFigure)mmFig));
        Figure fig = new Figure();
        fig.setParent((IFigure)mmFig);
        this.verifyMapMode(MapModeUtil.getMapMode((IFigure)fig));
        this.verifyMapMode(MapModeUtil.getMapMode(null));
    }

    private void verifyMapMode(IMapMode mm) {
        int index = 0;
        while (index < 1000) {
            int val1 = index;
            int val2 = mm.DPtoLP(index);
            Point ptLP = (Point)mm.DPtoLP((Translatable)new Point(index, 0));
            MapModeUtilTest.assertEquals((int)val2, (int)ptLP.x);
            int val3 = mm.LPtoDP(val2);
            Point ptDP = (Point)mm.LPtoDP((Translatable)new Point(val2, 0));
            MapModeUtilTest.assertEquals((int)val3, (int)ptDP.x);
            MapModeUtilTest.assertTrue((Math.abs(val1 - val3) <= 1 ? 1 : 0) != 0);
            ++index;
        }
    }

    static class MapModeFigure
    extends Figure
    implements IMapMode {
        MapModeFigure() {
        }

        public int DPtoLP(int deviceUnit) {
            return MapModeTypes.DEFAULT_MM.DPtoLP(deviceUnit);
        }

        public Translatable DPtoLP(Translatable t) {
            return MapModeTypes.DEFAULT_MM.DPtoLP(t);
        }

        public int LPtoDP(int logicalUnit) {
            return MapModeTypes.DEFAULT_MM.LPtoDP(logicalUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return MapModeTypes.DEFAULT_MM.LPtoDP(t);
        }
    }
}

