/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.internal.runtime.lite.Activator;

public abstract class AbstractWrappingCommand
extends Command {
    private final TransactionalEditingDomain myEditingDomain;

    public AbstractWrappingCommand(TransactionalEditingDomain editingDomain) {
        this.myEditingDomain = editingDomain;
    }

    public void execute() {
        try {
            this.getOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError("exception occurred while executing operation", e);
        }
    }

    public boolean canExecute() {
        final boolean[] result = new boolean[1];
        AbstractEMFOperation canExecute = new AbstractEMFOperation(this.myEditingDomain, "canExecute"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                result[0] = AbstractWrappingCommand.this.getOperation().canExecute();
                return Status.OK_STATUS;
            }
        };
        try {
            canExecute.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError("exception occurred while testing executability of operation", e);
        }
        return result[0];
    }

    public void undo() {
        try {
            this.getOperation().undo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError("exception occurred while undoing operation", e);
        }
    }

    public boolean canUndo() {
        return this.getOperation().canUndo();
    }

    public void redo() {
        try {
            this.getOperation().redo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError("exception occurred while redoing operation", e);
        }
    }

    public void dispose() {
        this.getOperation().dispose();
        super.dispose();
    }

    protected final TransactionalEditingDomain getEditingDomain() {
        return this.myEditingDomain;
    }

    protected abstract IUndoableOperation getOperation();
}

