/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class ImageFileDropTargetListener
extends DiagramDropTargetListener {
    public ImageFileDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)FileTransfer.getInstance());
    }

    protected List getObjectsBeingDropped() {
        TransferData[] data = this.getCurrentEvent().dataTypes;
        ArrayList<String> fileList = new ArrayList<String>();
        int i = 0;
        while (i < data.length) {
            if (FileTransfer.getInstance().isSupportedType(data[i])) {
                try {
                    Object files = FileTransfer.getInstance().nativeToJava(data[i]);
                    if (files instanceof String[]) {
                        String[] fileStrings = (String[])files;
                        int j = 0;
                        while (j < fileStrings.length) {
                            fileList.add(fileStrings[j]);
                            ++j;
                        }
                    }
                }
                catch (SWTException sWTException) {}
            }
            ++i;
        }
        if (fileList.size() == 0) {
            ISelection selection = null;
            if (LocalSelectionTransfer.getTransfer().getSelection() != null) {
                selection = LocalSelectionTransfer.getTransfer().getSelection();
            }
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                Object[] array = ((IStructuredSelection)selection).toArray();
                int j = 0;
                while (j < array.length) {
                    if (array[j] instanceof IFile) {
                        IFile dropFile = (IFile)array[j];
                        fileList.add(dropFile.getLocation().toOSString());
                    }
                    ++j;
                }
            }
            return fileList;
        }
        if (fileList.size() > 0) {
            return fileList;
        }
        return null;
    }

    public boolean isEnabled(DropTargetEvent event) {
        if (super.isEnabled(event)) {
            Object modelObj = this.getViewer().getContents().getModel();
            List dropObjects = this.getDropObjectsRequest().getObjects();
            if (modelObj instanceof EObject) {
                return dropObjects != null && !dropObjects.isEmpty();
            }
            if (modelObj instanceof IAdaptable) {
                EObject target = (EObject)((IAdaptable)modelObj).getAdapter(EObject.class);
                if (dropObjects == null || dropObjects.isEmpty() || target == null) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

