/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.ui.parts;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class FileResourceEditorInput
implements IPathEditorInput,
IPersistableElement {
    private static final String MEMENTO_PATH_KEY = "path";
    private static final String PERSISTABLE_ELEMENT_FACTORY_ID = "XToolsEditorInputFactoryID";
    private IFile file;

    public FileResourceEditorInput(IFile file) {
        assert (file != null);
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName());
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.file.getFullPath().makeRelative().toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class) {
            return this.file;
        }
        return this.file.getAdapter(adapter);
    }

    public IPath getPath() {
        return this.file.getLocation();
    }

    public String getFactoryId() {
        return PERSISTABLE_ELEMENT_FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        memento.putString(MEMENTO_PATH_KEY, this.file.getFullPath().toString());
    }
}

