/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

public class GroupAction
extends DiagramAction {
    public GroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setId("groupAction");
        this.setText(DiagramUIActionsMessages.GroupAction_Group_ActionLabelText);
        this.setToolTipText(DiagramUIActionsMessages.GroupAction_Group_ActionToolTipText);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_GROUP);
        this.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_GROUP_DISABLED);
        this.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_GROUP);
    }

    protected Request createTargetRequest() {
        return new GroupRequest((Object)this.getId());
    }

    protected void updateTargetRequest() {
        GroupRequest request = (GroupRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
    }

    protected Command getCommand() {
        if (this.getOperationSet().size() > 1) {
            EditPart parent = ((EditPart)this.getOperationSet().get(0)).getParent();
            return parent.getCommand(this.getTargetRequest());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.size() <= 1 || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        return ToolUtilities.getSelectionWithoutDependants((List)selection);
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        super.doRun(progressMonitor);
        Object model = ((EditPart)((GroupRequest)this.getTargetRequest()).getEditParts().get(0)).getModel();
        if (model instanceof View) {
            EObject groupView = ((View)model).eContainer();
            Object groupEP = this.getDiagramGraphicalViewer().getEditPartRegistry().get(groupView);
            if (groupEP != null) {
                this.getDiagramGraphicalViewer().setSelection((ISelection)new StructuredSelection(groupEP));
                this.getDiagramGraphicalViewer().reveal((EditPart)groupEP);
            }
        }
    }
}

