/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.part;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.map.editor.part.GMFMapCreationWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class GMFMapDiagramFileCreator {
    private GMFMapCreationWizard wizard;
    private static GMFMapDiagramFileCreator INSTANCE = new GMFMapDiagramFileCreator();

    public static GMFMapDiagramFileCreator getInstance() {
        return INSTANCE;
    }

    public static boolean exists(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().exists(path);
    }

    public GMFMapDiagramFileCreator() {
    }

    public GMFMapDiagramFileCreator(GMFMapCreationWizard wizard) {
        this.wizard = wizard;
    }

    public GMFMapCreationWizard getWizard() {
        return this.wizard;
    }

    public String getExtension() {
        return ".gmfmap_diagram";
    }

    public String getUniqueFileName(IPath containerPath, String fileName) {
        int nFileNumber = 1;
        String newFileName = fileName = this.removeExtensionFromFileName(fileName);
        IPath diagramFilePath = containerPath.append(this.appendExtensionToFileName(newFileName));
        IPath modelFilePath = containerPath.append(String.valueOf(newFileName) + ".gmfmap");
        while (GMFMapDiagramFileCreator.exists(diagramFilePath) || GMFMapDiagramFileCreator.exists(modelFilePath)) {
            newFileName = String.valueOf(fileName) + ++nFileNumber;
            diagramFilePath = containerPath.append(this.appendExtensionToFileName(newFileName));
            modelFilePath = containerPath.append(String.valueOf(newFileName) + ".gmfmap");
        }
        return newFileName;
    }

    public String appendExtensionToFileName(String fileName) {
        if (!fileName.endsWith(this.getExtension())) {
            return String.valueOf(fileName) + this.getExtension();
        }
        return fileName;
    }

    private String removeExtensionFromFileName(String fileName) {
        if (fileName.endsWith(this.getExtension())) {
            return fileName.substring(0, fileName.length() - this.getExtension().length());
        }
        return fileName;
    }

    public IFile createNewFile(IPath containerPath, String fileName, InputStream initialContents, Shell shell) {
        IPath newFilePath = containerPath.append(this.appendExtensionToFileName(fileName));
        IFile newFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
        try {
            this.createFile(newFileHandle, initialContents);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)shell, (String)"Creation Problems", null, (IStatus)e.getStatus());
            return null;
        }
        return newFileHandle;
    }

    protected void createFile(IFile fileHandle, InputStream contents) throws CoreException {
        try {
            if (contents == null) {
                contents = new ByteArrayInputStream(new byte[0]);
            }
            fileHandle.create(contents, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
    }
}

