/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.probbroadcast;

import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.external.prism.MDPStateSpaceValidator;
import org.eclipse.emf.henshin.statespace.impl.OCLStateValidator;
import org.eclipse.emf.henshin.statespace.impl.ParallelStateSpaceManager;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceImpl;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResourceSet;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;
import org.eclipse.emf.henshin.statespace.util.StateSpaceXYPlot;

public class ProbBroadcast {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/probbroadcast";
    public final StateSpaceManager manager;
    public final StateSpaceResourceSet resourceSet;

    public ProbBroadcast(String path) {
        this.resourceSet = new StateSpaceResourceSet(path);
        Module module = this.resourceSet.getModule("probbroadcast.henshin", false);
        StateSpaceImpl stateSpace = new StateSpaceImpl(module);
        this.manager = new ParallelStateSpaceManager((StateSpace)stateSpace);
    }

    private void generate(String initModel) throws StateSpaceException {
        System.out.println("\n - Generating state space for topology in '" + initModel + "'...");
        this.manager.resetStateSpace(true);
        this.manager.createInitialState(this.resourceSet.getModel(initModel));
        long time = System.currentTimeMillis();
        new StateSpaceExplorationHelper(this.manager).doExploration(-1, null);
        System.out.println(" - Generated " + this.manager.getStateSpace().getStateCount() + " states in " + (System.currentTimeMillis() - time) + "ms");
    }

    private Object getResults(String probSend, String property) throws Exception {
        MDPStateSpaceValidator validator = new MDPStateSpaceValidator((StateSpaceIndex)this.manager);
        validator.setProperty(property);
        this.manager.getStateSpace().getProperties().put((Object)"probSend1", (Object)probSend);
        this.manager.getStateSpace().getProperties().put((Object)"probSend2", (Object)"1-probSend1");
        return validator.validate(this.manager.getStateSpace(), null).getResult();
    }

    public void fixedSendProb(int[] nodes, double probSend) throws Exception {
        System.out.println("\n - Computing reception probabilities for send probability " + probSend + "...\n");
        System.out.println("   Node\tPmin\tPmax");
        int i = 0;
        while (i < nodes.length) {
            String label = "label \"target\" = <<<OCL not self.nodes->at(" + nodes[i] + ").active >>>;";
            double pmin = (Double)this.getResults(String.valueOf(probSend), String.valueOf(label) + " Pmin=?[F \"target\"]");
            double pmax = (Double)this.getResults(String.valueOf(probSend), String.valueOf(label) + " Pmax=?[F \"target\"]");
            System.out.println("   " + nodes[i] + "\t" + pmin + "\t" + pmax);
            ++i;
        }
    }

    public void fixedNode(int node, String probSend) throws Exception {
        System.out.println("\n - Computing reception probabilities for node " + node + "...\n");
        System.out.println("   Psend\tPmin\tPmax");
        String label = "label \"target\" = <<<OCL not self.nodes->at(" + node + ").active >>>;";
        StateSpaceXYPlot pmin = (StateSpaceXYPlot)this.getResults(probSend, String.valueOf(label) + " Pmin=?[F \"target\"]");
        StateSpaceXYPlot pmax = (StateSpaceXYPlot)this.getResults(probSend, String.valueOf(label) + " Pmax=?[F \"target\"]");
        int x = 0;
        while (x < pmin.getXMaxSegments()) {
            System.out.println("   " + pmin.getX(0, x) + "\t" + pmin.getY(0, x) + "\t" + pmax.getY(0, x));
            ++x;
        }
    }

    public static void run(String path) {
        ProbBroadcast main = new ProbBroadcast(path);
        try {
            try {
                OCLStateValidator.register();
                main.generate("init-grid3x3.xmi");
                main.fixedSendProb(new int[]{2, 4, 3, 5, 7, 6, 8, 9}, 0.6);
                main.fixedNode(9, "0:0.1:1");
            }
            catch (Throwable t) {
                t.printStackTrace();
                main.manager.shutdown();
            }
        }
        finally {
            main.manager.shutdown();
        }
    }

    public static void main(String[] args) {
        ProbBroadcast.run(PATH);
    }
}

