/*
 * Decompiled with CFR 0.152.
 */
package agg.termination;

import agg.xt_basis.GraphObject;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class TypeLayerOfTypeGraph {
    private Hashtable<GraphObject, Integer> typeLayer;
    private Hashtable<GraphObject, Integer> types;

    public TypeLayerOfTypeGraph(Hashtable<GraphObject, Integer> types) {
        this.types = types;
        this.initTypeLayer();
    }

    public void setLayer(GraphObject type, int layer) {
        this.typeLayer.put(type, layer);
    }

    private void initTypeLayer() {
        this.typeLayer = new Hashtable();
        Enumeration<GraphObject> keys = this.types.keys();
        while (keys.hasMoreElements()) {
            GraphObject t = keys.nextElement();
            this.typeLayer.put(t, this.types.get(t));
        }
    }

    public Hashtable<GraphObject, Integer> getTypeLayer() {
        return this.typeLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<GraphObject> keys = this.getTypeLayer().keys();
        while (keys.hasMoreElements()) {
            GraphObject key = keys.nextElement();
            Integer layer = this.getTypeLayer().get(key);
            if (layer >= startLayer) continue;
            startLayer = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable<Integer, HashSet<Object>> invertLayer() {
        Hashtable<Integer, HashSet<Object>> inverted = new Hashtable<Integer, HashSet<Object>>();
        Enumeration<GraphObject> keys = this.typeLayer.keys();
        while (keys.hasMoreElements()) {
            GraphObject key = keys.nextElement();
            Integer value = this.typeLayer.get(key);
            HashSet<Object> invertedValue = inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Type:\t\tLayer:\n";
        Enumeration<GraphObject> keys = this.typeLayer.keys();
        while (keys.hasMoreElements()) {
            GraphObject key = keys.nextElement();
            Integer value = this.typeLayer.get(key);
            resultString = String.valueOf(resultString) + key.toString() + "\t\t" + value.toString() + "\n";
        }
        return resultString;
    }
}

