/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.AttrType;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.parser.ExcludePair;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TestStep;
import agg.xt_basis.TypeException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class CriticalRulePairAtGraph
extends ExcludePair {
    private Rule rule1;
    private Rule rule2;
    private Graph graph;
    private final Vector<Hashtable<GraphObject, GraphObject>> r1Matches = new Vector();
    private final Vector<Hashtable<GraphObject, GraphObject>> r2Matches = new Vector();
    private Hashtable<Vector<GraphObject>, Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> jointlyMatches;

    public CriticalRulePairAtGraph(Rule r1, Rule r2, Graph g) {
        this.rule1 = r1;
        this.rule2 = r2;
        this.graph = g;
    }

    public Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> isCriticalAtGraph() {
        if (this.essential) {
            this.disableConstraints();
        }
        if (!this.checkGlobalNACsOfRule2(this.rule1, this.rule2)) {
            System.out.println("*** CriticalRulePairAtGraph.getCriticalForGraph::  [ " + this.rule1.getName() + ", " + this.rule2.getName() + " ]  non-critical.");
            return null;
        }
        this.fillTypeSubset(this.rule2.getLeft(), this.typesTG_L2);
        if (this.withPACs) {
            this.getTypeSubsetLeft_PACs(this.rule2, this.typesTG_L2, this.typesTG_PAC2);
        }
        if (this.withNACs) {
            this.getTypeSubsetLeft_NACs(this.rule2, this.typesTG_L2, this.typesTG_NAC2);
        }
        if (this.withPACs) {
            this.computeLeftC_B_K(this.rule1, this.contextC1_L1, this.boundB1_L1, this.preservedK1_L1, this.delete, this.typesTG_PAC2);
        } else {
            this.computeLeftC_B_K(this.rule1, this.contextC1_L1, this.boundB1_L1, this.preservedK1_L1, this.delete, this.typesTG_L2);
        }
        if (this.withNACs) {
            this.computeRightC_B_K(this.rule1, this.contextC1_R1, this.boundB1_R1, this.preservedK1_R1, this.produce, this.typesTG_NAC2);
        } else {
            this.computeRightC_B_K(this.rule1, this.contextC1_R1, this.boundB1_R1, this.preservedK1_R1, this.produce, this.typesTG_L2);
        }
        this.findValidMatches(this.rule1, this.graph, this.r1Matches);
        this.findValidMatches(this.rule2, this.graph, this.r2Matches);
        boolean canOverlapLHS1withLHS2 = this.canMatchConstantAttributeLHS1intoLHS2(this.rule1, this.rule2);
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> resultOverlappings = new Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>>();
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> deleteUseOverlappings = null;
        if (!this.contextC1_L1.isEmpty() && canOverlapLHS1withLHS2 && !this.stop && (deleteUseOverlappings = this.getDeleteUseConflictsAtGraph(this.rule1, this.rule2)) != null) {
            int i = 0;
            while (i < deleteUseOverlappings.size()) {
                resultOverlappings.add(deleteUseOverlappings.elementAt(i));
                ++i;
            }
        }
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> produceForbidOverlappings = null;
        if (this.withNACs && (this.complete || resultOverlappings.isEmpty()) && !this.contextC1_R1.isEmpty() && !this.stop && (produceForbidOverlappings = this.getProduceForbidConflictsAtGraph(this.rule1, this.rule2)) != null) {
            int i = 0;
            while (i < produceForbidOverlappings.size()) {
                resultOverlappings.add(produceForbidOverlappings.elementAt(i));
                ++i;
            }
        }
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> changeAttributeOverlappings = null;
        if ((this.complete || resultOverlappings.isEmpty()) && !this.stop) {
            Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL1 = new Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>>();
            this.preservedChanged.clear();
            this.contextC1_L1.clear();
            this.boundB1_L1.clear();
            this.ruleChangesAttributes(this.preservedChanged, this.rule1, this.rule2, this.contextC1_L1, this.boundB1_L1, this.preservedK1_L1, changedAttrsL1, this.typesTG_NAC2);
            this.ruleChangesAttributes(this.preservedChanged, this.rule1, this.rule2, this.contextC1_L1, this.boundB1_L1, this.preservedK1_L1, changedAttrsL1, this.typesTG_PAC2);
            Vector<GraphObject> preservedL2_K2 = new Vector<GraphObject>(5);
            Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL2 = new Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>>();
            this.ruleChangesAttributes(this.rule2, preservedL2_K2, changedAttrsL2);
            if (this.ruleRestrictsAttributes(true, this.rule2, changedAttrsL2, changedAttrsL1) && (changeAttributeOverlappings = this.getChangeAttributeConflictsAtGraph(this.rule1, this.rule2, changedAttrsL1, changedAttrsL2)) != null) {
                int i = 0;
                while (i < changeAttributeOverlappings.size()) {
                    resultOverlappings.add(changeAttributeOverlappings.elementAt(i));
                    ++i;
                }
            }
        }
        if (this.essential) {
            this.enableConstraints();
        }
        return resultOverlappings;
    }

    private void findValidMatches(Rule r, Graph g, Vector<Hashtable<GraphObject, GraphObject>> ruleMatches) {
        Match m = BaseFactory.theFactory().createMatch(r, g);
        m.setCompletionStrategy(this.strategy, true);
        while (m.nextCompletion()) {
            if (!m.isValid()) continue;
            Hashtable<GraphObject, GraphObject> mTable = new Hashtable<GraphObject, GraphObject>();
            Enumeration<GraphObject> dom = m.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject o = dom.nextElement();
                mTable.put(o, m.getImage(o));
            }
            ruleMatches.add(mTable);
        }
    }

    private Hashtable<Vector<GraphObject>, Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> getJointlyMatches(Vector<Hashtable<GraphObject, GraphObject>> ruleMatches1, Vector<Hashtable<GraphObject, GraphObject>> ruleMatches2) {
        Hashtable<Vector<GraphObject>, Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> result = new Hashtable<Vector<GraphObject>, Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>>();
        int i = 0;
        while (i < ruleMatches1.size()) {
            Hashtable<GraphObject, GraphObject> m1 = ruleMatches1.get(i);
            int j = 0;
            while (j < ruleMatches2.size()) {
                Hashtable<GraphObject, GraphObject> m2 = ruleMatches2.get(j);
                Vector<GraphObject> jointlyObjs = new Vector<GraphObject>();
                Enumeration<GraphObject> keys1 = m1.keys();
                while (keys1.hasMoreElements()) {
                    GraphObject o1 = keys1.nextElement();
                    GraphObject i1 = m1.get(o1);
                    Collection<GraphObject> values2 = m2.values();
                    if (!values2.contains(i1)) continue;
                    jointlyObjs.add(i1);
                }
                if (!jointlyObjs.isEmpty()) {
                    Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> p = new Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>(m1, m2);
                    result.put(jointlyObjs, p);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private boolean setMapping(OrdinaryMorphism morph, OrdinaryMorphism isoG, Hashtable<GraphObject, GraphObject> map) {
        Enumeration<GraphObject> keys = map.keys();
        while (keys.hasMoreElements()) {
            GraphObject o = keys.nextElement();
            GraphObject img = isoG.getImage(map.get(o));
            if (img != null) {
                try {
                    if (img.isArc()) {
                        morph.addMapping(((Arc)o).getSource(), ((Arc)img).getSource());
                        morph.addMapping(((Arc)o).getTarget(), ((Arc)img).getTarget());
                    }
                    morph.addMapping(o, img);
                    continue;
                }
                catch (BadMappingException ex) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> getDeleteUseConflictsAtGraph(Rule r1, Rule r2) {
        this.jointlyMatches = this.getJointlyMatches(this.r1Matches, this.r2Matches);
        if (!this.jointlyMatches.isEmpty()) {
            Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> result = new Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>>();
            Enumeration<Vector<GraphObject>> jointly = this.jointlyMatches.keys();
            block0: while (jointly.hasMoreElements()) {
                Vector<GraphObject> jointlyObjs = jointly.nextElement();
                Hashtable m1 = (Hashtable)this.jointlyMatches.get(jointlyObjs).first;
                Hashtable m2 = (Hashtable)this.jointlyMatches.get(jointlyObjs).second;
                int i = 0;
                while (i < jointlyObjs.size()) {
                    GraphObject o = jointlyObjs.get(i);
                    GraphObject go = this.getOriginalOfImage(o, m1);
                    if (this.delete.contains(go)) {
                        o.setCritical(true);
                        Pair<Hashtable, Hashtable> p = new Pair<Hashtable, Hashtable>(m1, m2);
                        result.add(p);
                        continue block0;
                    }
                    ++i;
                }
            }
            return result;
        }
        return null;
    }

    private GraphObject getOriginalOfImage(GraphObject img, Hashtable<GraphObject, GraphObject> map) {
        Enumeration<GraphObject> keys = map.keys();
        while (keys.hasMoreElements()) {
            GraphObject o = keys.nextElement();
            GraphObject i = map.get(o);
            if (i != img) continue;
            return o;
        }
        return null;
    }

    private Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> getProduceForbidConflictsAtGraph(Rule r1, Rule r2) {
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> result = new Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>>();
        int i = 0;
        while (i < this.r1Matches.size()) {
            block12: {
                OrdinaryMorphism isoG = this.graph.isomorphicCopy();
                if (isoG == null) {
                    result = null;
                    return null;
                }
                Hashtable<GraphObject, GraphObject> m1Map = this.r1Matches.get(i);
                Match m1 = BaseFactory.theFactory().createMatch(r1, isoG.getTarget());
                if (this.setMapping(m1, isoG, m1Map)) {
                    OrdinaryMorphism com1 = null;
                    try {
                        com1 = (OrdinaryMorphism)TestStep.execute(m1);
                    }
                    catch (TypeException ex) {
                        m1.dispose();
                        m1 = null;
                        break block12;
                    }
                    int j = 0;
                    while (j < this.r2Matches.size()) {
                        Hashtable<GraphObject, GraphObject> m2Map = this.r2Matches.get(j);
                        Match m2 = BaseFactory.theFactory().createMatch(r2, isoG.getTarget());
                        if (this.setMapping(m2, isoG, m2Map) && m2.areTotalIdentDanglSatisfied()) {
                            List<OrdinaryMorphism> nacs2 = r2.getNACsList();
                            int l = 0;
                            while (l < nacs2.size()) {
                                OrdinaryMorphism nac2 = nacs2.get(l);
                                OrdinaryMorphism nac2Star = (OrdinaryMorphism)m2.checkNAC(nac2);
                                if (nac2Star != null) {
                                    boolean critical = false;
                                    Enumeration<GraphObject> nac2StarCodom = nac2Star.getCodomain();
                                    while (nac2StarCodom.hasMoreElements()) {
                                        GraphObject preimg;
                                        GraphObject o = nac2StarCodom.nextElement();
                                        Enumeration<GraphObject> preimgR1 = com1.getInverseImage(o);
                                        if (!preimgR1.hasMoreElements() || r1.getInverseImage(preimg = preimgR1.nextElement()).hasMoreElements()) continue;
                                        o.setCritical(true);
                                        critical = true;
                                    }
                                    if (critical) {
                                        Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> p = new Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>(m1Map, m2Map);
                                        result.add(p);
                                    }
                                }
                                ++l;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (!result.isEmpty()) {
            result.trimToSize();
            return result;
        }
        result = null;
        return null;
    }

    private Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> getChangeUseAttributeConflictAtGraph(Rule r1, Rule r2, Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL1, Hashtable<GraphObject, GraphObject> m1map, OrdinaryMorphism com1test, Match m2) {
        if (this.jointlyMatches == null) {
            this.jointlyMatches = this.getJointlyMatches(this.r1Matches, this.r2Matches);
        }
        if (!this.jointlyMatches.isEmpty()) {
            Enumeration<Vector<GraphObject>> jointly = this.jointlyMatches.keys();
            while (jointly.hasMoreElements()) {
                Vector<GraphObject> jointlyObjs = jointly.nextElement();
                Hashtable m1Map = (Hashtable)this.jointlyMatches.get(jointlyObjs).first;
                if (m1Map != m1map) continue;
                Hashtable m2Map = (Hashtable)this.jointlyMatches.get(jointlyObjs).second;
                boolean critical = false;
                int i = 0;
                while (i < jointlyObjs.size()) {
                    GraphObject img1changed;
                    GraphObject go2;
                    GraphObject img2;
                    GraphObject o = jointlyObjs.get(i);
                    GraphObject go1 = this.getOriginalOfImage(o, m1Map);
                    if (this.preservedChanged.contains(go1) && !this.checkChangeUseAttribute(img2 = m2.getImage(go2 = this.getOriginalOfImage(o, m2Map)), img1changed = com1test.getImage(r1.getImage(go1)), changedAttrsL1)) {
                        o.setCritical(true);
                        critical = true;
                    }
                    ++i;
                }
                if (!critical) continue;
                Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> p = new Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>(m1Map, m2Map);
                return p;
            }
        }
        return null;
    }

    private Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> getChangeForbidAttributeConflictAtGraph(Rule r1, Rule r2, Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL1, Hashtable<GraphObject, GraphObject> m1map, Hashtable<GraphObject, GraphObject> m2map, OrdinaryMorphism com1test, Match m2) {
        List<OrdinaryMorphism> nacs2 = r2.getNACsList();
        int i = 0;
        while (i < nacs2.size()) {
            OrdinaryMorphism nac2 = nacs2.get(i);
            OrdinaryMorphism nac2Star = (OrdinaryMorphism)m2.checkNAC(nac2);
            if (nac2Star != null) {
                boolean critical = false;
                Enumeration<GraphObject> nac2StarCodom = nac2Star.getCodomain();
                while (nac2StarCodom.hasMoreElements()) {
                    GraphObject nac2go;
                    GraphObject preimg;
                    Enumeration<GraphObject> preimgL1;
                    GraphObject o = nac2StarCodom.nextElement();
                    Enumeration<GraphObject> preimgR1 = com1test.getInverseImage(o);
                    if (!preimgR1.hasMoreElements() || !(preimgL1 = r1.getInverseImage(preimg = preimgR1.nextElement())).hasMoreElements() || !this.checkChangeForbidAttribute(nac2go = nac2Star.getInverseImage(o).nextElement(), o, changedAttrsL1)) continue;
                    o.setCritical(true);
                    critical = true;
                }
                if (critical) {
                    Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> p = new Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>(m1map, m2map);
                    return p;
                }
            }
            ++i;
        }
        return null;
    }

    private Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> getChangeAttributeConflictsAtGraph(Rule r1, Rule r2, Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL1, Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrsL2) {
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> result = new Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>>();
        int i = 0;
        while (i < this.r1Matches.size()) {
            block10: {
                OrdinaryMorphism isoG = this.graph.isomorphicCopy();
                if (isoG == null) {
                    result = null;
                    return null;
                }
                Hashtable<GraphObject, GraphObject> m1Map = this.r1Matches.get(i);
                Match m1 = BaseFactory.theFactory().createMatch(r1, isoG.getTarget());
                if (this.setMapping(m1, isoG, m1Map)) {
                    OrdinaryMorphism com1 = null;
                    try {
                        com1 = (OrdinaryMorphism)TestStep.execute(m1);
                    }
                    catch (TypeException ex) {
                        m1.dispose();
                        m1 = null;
                        break block10;
                    }
                    int j = 0;
                    while (j < this.r2Matches.size()) {
                        Hashtable<GraphObject, GraphObject> m2Map = this.r2Matches.get(j);
                        Match m2 = BaseFactory.theFactory().createMatch(r2, isoG.getTarget());
                        if (this.setMapping(m2, isoG, m2Map) && m2.areTotalIdentDanglSatisfied()) {
                            Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>> p = this.getChangeUseAttributeConflictAtGraph(r1, r2, changedAttrsL1, m1Map, com1, m2);
                            if (p != null) {
                                result.add(p);
                            }
                            if ((p = this.getChangeForbidAttributeConflictAtGraph(r1, r2, changedAttrsL1, m1Map, m2Map, com1, m2)) != null) {
                                result.add(p);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (!result.isEmpty()) {
            result.trimToSize();
            return result;
        }
        result = null;
        return null;
    }

    private boolean checkChangeForbidAttribute(GraphObject other, GraphObject changed, Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrs) {
        ValueTuple otherAttr = (ValueTuple)other.getAttribute();
        if (otherAttr == null) {
            return true;
        }
        Vector<Pair<ValueMember, ValueMember>> vec = changedAttrs.get(changed.getType().getAttrType());
        if (vec == null) {
            return true;
        }
        int i = 0;
        while (i < vec.size()) {
            String varValue;
            Pair<ValueMember, ValueMember> p = vec.get(i);
            ValueMember vmLeft = (ValueMember)p.first;
            ValueMember vmChanged = ((ValueTuple)changed.getAttribute()).getValueMemberAt(vmLeft.getName());
            ValueMember vmOther = otherAttr.getValueMemberAt(vmLeft.getName());
            if (vmOther.isSet() && (vmOther.getExpr().isVariable() ? (varValue = this.getValueOfVariable(this.rule2, vmOther.getExprAsText())) != null && !varValue.equals(vmChanged.getExprAsText()) : vmOther.getExpr().isConstant() && !vmOther.getExprAsText().equals(vmChanged.getExprAsText()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkChangeUseAttribute(GraphObject other, GraphObject changed, Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> changedAttrs) {
        ValueTuple otherAttr = (ValueTuple)other.getAttribute();
        if (otherAttr == null) {
            return true;
        }
        Vector<Pair<ValueMember, ValueMember>> vec = changedAttrs.get(changed.getType().getAttrType());
        if (vec == null) {
            return true;
        }
        int i = 0;
        while (i < vec.size()) {
            String varValue;
            Pair<ValueMember, ValueMember> p = vec.get(i);
            ValueMember vmLeft = (ValueMember)p.first;
            ValueMember vmChanged = ((ValueTuple)changed.getAttribute()).getValueMemberAt(vmLeft.getName());
            ValueMember vmOther = otherAttr.getValueMemberAt(vmLeft.getName());
            if (vmOther.isSet() && (vmOther.getExpr().isVariable() ? (varValue = this.getValueOfVariable(this.rule2, vmOther.getExprAsText())) != null && !varValue.equals(vmChanged.getExprAsText()) : vmOther.getExpr().isConstant() && !vmOther.getExprAsText().equals(vmChanged.getExprAsText()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getValueOfVariable(Rule r, String varName) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        VarMember var = vars.getVarMemberAt(varName);
        if (var.isSet()) {
            return var.getExprAsText();
        }
        return null;
    }
}

