/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.attribute.impl.ValueTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.editor.impl.EditUndoManager;
import agg.editor.impl.Loop;
import agg.gui.editor.GraGraEditor;
import agg.gui.editor.GraphCanvasMouseAdapter;
import agg.gui.editor.GraphCanvasMouseMotionAdapter;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.editor.RuleEditor;
import agg.xt_basis.Arc;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.UndirectedGraph;
import agg.xt_basis.UndirectedTypeGraph;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class GraphCanvas
extends JPanel {
    public static final int MAX_XWIDTH = 700;
    public static final int MAX_YHEIGHT = 600;
    private static final int DEPEND_ON_LAST_OBJECT = 0;
    private Toolkit tk;
    protected GraphCanvas canvas = this;
    private boolean leftPressed;
    private boolean rightPressed;
    private EdGraph eGraph;
    private boolean visible = true;
    private int mode = 11;
    private int lastMode = 11;
    private String fontName = "Dialog";
    private int fontStyle = 0;
    private int fontSize = 12;
    private double scale = 1.0;
    private JScrollBar hsb;
    private JScrollBar vsb;
    private int hsbValue;
    private int vsbValue;
    private boolean scrollbarValueSaved;
    private GraphPanel viewport;
    private int realWidth = 100;
    private int realHeight = 100;
    private boolean needResizeAfterMove = false;
    private boolean needResizeAfterStep = false;
    private boolean attrVisible = true;
    private EdNode pickedNode;
    private EdArc pickedArc;
    private EdArc pickedTextOfArc;
    private EdGraphObject pickedObj;
    private EdGraphObject src;
    private EdGraphObject tar;
    private Point anchor;
    private int x0 = 0;
    private int y0 = 0;
    private int dx = 0;
    private int dy = 0;
    private static final Rectangle selBox = new Rectangle(0, 0, 0, 0);
    private boolean selBoxOpen;
    private boolean changed;
    private boolean dragged;
    private boolean startDragging;
    boolean canCreateNode;
    private String msg;
    private Point magicArcStart;
    private boolean isMagicArc;
    private boolean showAnchor = true;
    private boolean magicArcEnabled = true;
    private boolean arcError;
    private boolean scrolling;
    private boolean scrollingByDragging;
    private final ImageIcon errorImage;
    private final ImageIcon okImage;
    private final ImageIcon smileImage;
    private final ImageIcon scrollImage;

    public GraphCanvas() {
        super(new BorderLayout(), true);
        new GraphCanvasMouseAdapter(this);
        new GraphCanvasMouseMotionAdapter(this);
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.WHITE);
        this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
        this.vsbValue = 0;
        this.hsbValue = 0;
        this.scrollbarValueSaved = false;
        this.errorImage = ClassLoader.getSystemResource("agg/lib/icons/sad.png") != null ? new ImageIcon(ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/sad.png")) : new ImageIcon();
        this.okImage = ClassLoader.getSystemResource("agg/lib/icons/good.png") != null ? new ImageIcon(ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/good.png")) : new ImageIcon();
        this.smileImage = ClassLoader.getSystemResource("agg/lib/icons/smile.png") != null ? new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/smile.png")) : new ImageIcon();
        this.scrollImage = ClassLoader.getSystemResource("agg/lib/icons/scroll.png") != null ? new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/scroll.png")) : new ImageIcon();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.realWidth, this.realHeight);
    }

    public void setViewport(GraphPanel vp) {
        this.viewport = vp;
        this.hsb = this.viewport.getHorizontalScrollBar();
        this.vsb = this.viewport.getVerticalScrollBar();
    }

    public GraphPanel getViewport() {
        return this.viewport;
    }

    public void setRealWidth(int w) {
        this.realWidth = w;
    }

    public void setRealHeight(int h) {
        this.realHeight = h;
    }

    public void setGraph(EdGraph eg) {
        this.eGraph = eg;
        if (this.eGraph == null || this.eGraph.getBasisGraph().isEmpty()) {
            return;
        }
        this.eGraph.applyScale(this.scale);
        this.setName(this.eGraph.getName());
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    @Override
    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public void setFontStyle(int fstyle) {
        this.fontStyle = fstyle;
        this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontSize(int fsize) {
        this.fontSize = fsize;
        if (this.fontSize == 0) {
            this.setFont(new Font(this.fontName, this.fontStyle, 6));
        } else {
            this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setScale(double s) {
        this.scale = s;
        if (this.scale == 0.5) {
            this.setFont(new Font(this.fontName, this.fontStyle, (int)((double)this.fontSize * 0.7)));
        } else if (this.scale == 0.2) {
            this.setFont(new Font(this.fontName, this.fontStyle, (int)((double)this.fontSize * 0.3)));
        } else if (this.scale == 2.0) {
            this.setFont(new Font(this.fontName, this.fontStyle, (int)((double)this.fontSize * 1.5)));
        } else {
            this.setFont(new Font(this.fontName, this.fontStyle, (int)((double)this.fontSize * this.scale)));
        }
        if (this.eGraph != null) {
            this.eGraph.applyScale(this.scale);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setAttributeVisible(boolean vis) {
        this.attrVisible = vis;
    }

    public void resizeAfterTransform(boolean val) {
        this.needResizeAfterStep = val;
    }

    public int getEditMode() {
        return this.mode;
    }

    public void setEditMode(int mode) {
        if (this.pickedObj != null && this.pickedObj.isWeakselected()) {
            this.pickedObj.setWeakselected(false);
            this.repaint();
        }
        switch (mode) {
            case 9: {
                this.mode = mode;
                break;
            }
            case 11: {
                this.mode = mode;
                break;
            }
            case 113: {
                this.mode = mode;
                break;
            }
            case 15: {
                this.mode = mode;
                break;
            }
            case 151: {
                this.mode = mode;
                break;
            }
            case 152: {
                this.mode = mode;
                break;
            }
            case 13: {
                this.mode = mode;
                break;
            }
            case 12: {
                this.mode = mode;
                break;
            }
            case 114: {
                this.mode = mode;
                break;
            }
            case 14: {
                this.mode = mode;
                break;
            }
            case 16: {
                this.mode = mode;
                break;
            }
            case 17: 
            case 171: {
                this.mode = mode;
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 1161: {
                this.mode = mode;
                break;
            }
            case 1201: {
                this.lastMode = this.mode;
                this.mode = mode;
                this.setToolTipText("Click on a node to add inheritance relation.");
                break;
            }
            case 1202: {
                this.lastMode = this.mode;
                this.mode = mode;
                this.setToolTipText("Click on a parent node to remove inheritance relation.");
                break;
            }
            case 118: 
            case 1181: {
                this.mode = mode;
                break;
            }
            case 42: {
                this.mode = mode;
                break;
            }
            case 32: 
            case 43: 
            case 82: 
            case 802: 
            case 8020: {
                this.mode = mode;
                break;
            }
            case 30: 
            case 80: 
            case 800: 
            case 8000: {
                this.mode = mode;
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 10: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected mode");
            }
        }
    }

    protected void propagateMoveEditMode() {
        GraGraEditor ggEd = this.getGraGraEditor();
        if (ggEd != null) {
            ggEd.resetMoveEditMode();
        }
    }

    public int getLastEditMode() {
        return this.lastMode;
    }

    public void setMsg(String m) {
        this.msg = m;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics grs) {
        if (grs == null) {
            return;
        }
        GraphCanvas graphCanvas = this;
        synchronized (graphCanvas) {
            if (this.eGraph == null || this.eGraph.isEmpty()) {
                this.realWidth = 0;
                this.realHeight = 0;
                grs.setColor(Color.WHITE);
                grs.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                grs.setFont(this.getFont());
                Graphics2D graphics2D = (Graphics2D)grs;
                Dimension graphDim = this.getGraphDimension();
                this.realWidth = graphDim.width;
                this.realHeight = graphDim.height;
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.needResizeAfterMove) {
                    this.needResizeAfterMove = false;
                } else if (this.needResizeAfterStep) {
                    EdNode lastNode = null;
                    if (this.eGraph.getNodes().size() != 0) {
                        lastNode = this.eGraph.getNodes().lastElement();
                        int newHeight = this.getHeight();
                        while (lastNode.getY() > newHeight) {
                            newHeight += this.viewport.getHeight() / 2;
                        }
                    } else {
                        this.realWidth = this.viewport.getWidth() - this.vsb.getWidth() - 3;
                        this.realHeight = this.viewport.getHeight() - this.hsb.getHeight() - 3;
                    }
                    this.resetValueOfScrollbar(0);
                    this.needResizeAfterStep = false;
                }
                if (this.eGraph.isCPAgraph()) {
                    this.eGraph.forceVisibilityUpdate();
                } else {
                    this.eGraph.updateVisibility();
                }
                this.eGraph.drawGraphics(graphics2D, this.eGraph.getVisibleNodes(), this.eGraph.getVisibleArcs(), true, this.attrVisible);
                this.drawSelectBox(graphics2D, Color.GREEN);
            }
        }
    }

    private void drawSelectBox(Graphics2D grs, Color c) {
        if (this.selBoxOpen) {
            grs.setColor(c);
            grs.drawLine(GraphCanvas.selBox.x, GraphCanvas.selBox.y, GraphCanvas.selBox.x + GraphCanvas.selBox.width, GraphCanvas.selBox.y);
            grs.drawLine(GraphCanvas.selBox.x, GraphCanvas.selBox.y, GraphCanvas.selBox.x, GraphCanvas.selBox.y + GraphCanvas.selBox.height);
            grs.setColor(Color.BLACK);
        }
    }

    public void openAttrEditorForGraphObject(MouseEvent e) {
        GraGraEditor ggEditor = this.getGraGraEditor();
        if (ggEditor != null) {
            this.pickedObj = this.getPickedObject(e.getX(), e.getY(), this.getGraphics().getFontMetrics());
            if (this.pickedObj != null) {
                if (e.getClickCount() == 2 && this.mode == 12) {
                    ggEditor.deselectAllProc();
                    this.eGraph.select(this.pickedObj);
                }
                if (this.viewport.getParentEditor() instanceof GraphEditor) {
                    ggEditor.setAttrEditorOnTopForGraphObject(this.pickedObj);
                } else if (this.viewport.getParentEditor() instanceof RuleEditor) {
                    ggEditor.setAttrEditorOnBottomForGraphObject(this.pickedObj);
                }
            } else {
                ggEditor.resetEditor();
            }
        }
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public boolean isLeftAndRightPressed() {
        return this.leftPressed && this.rightPressed;
    }

    public void unsetLeftAndRightPressed() {
        this.leftPressed = false;
        this.rightPressed = false;
    }

    public boolean isLeftPressed() {
        return this.leftPressed;
    }

    public void setLeftPressed(boolean b) {
        this.leftPressed = b;
    }

    public boolean isRightPressed() {
        return this.rightPressed;
    }

    public void setRightPressed(boolean b) {
        this.rightPressed = b;
    }

    public boolean isMagicArc() {
        return this.isMagicArc;
    }

    public void setMagicArc(boolean b) {
        this.isMagicArc = b;
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    public void setScrolling(boolean b) {
        this.scrolling = b;
    }

    public boolean isScrollingByDragging() {
        return this.scrollingByDragging;
    }

    public void setScrollingByDragging(boolean b) {
        this.scrollingByDragging = b;
    }

    public boolean canCreateNode() {
        return this.canCreateNode;
    }

    public boolean canCreateNodeOfType(Type t, Type arcType, Type srcNodeType) {
        List<String> arcTypes;
        if (t == null) {
            this.canCreateNode = false;
            return false;
        }
        if (t.isAbstract()) {
            if (this.eGraph.getTypeSet().getBasisTypeSet().getClan(t).size() == 1) {
                if (this.eGraph == this.eGraph.getGraGra().getGraph()) {
                    String mesg = "Node type &nbsp;<i>" + this.eGraph.getGraGra().getSelectedNodeType().getName() + "</i>&nbsp; is abstract <br>" + "and hasn't any descendants. <br>" + "To create a node of an abstract type isn't allowed.";
                    this.cannotCreateErrorMessage(" Create Node ", " a node", mesg);
                    this.canCreateNode = false;
                    return false;
                }
            } else if (this.eGraph == this.eGraph.getGraGra().getGraph() && this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() > 0) {
                String mesg = "Node type &nbsp;<i>" + this.eGraph.getGraGra().getSelectedNodeType().getName() + "</i>&nbsp; is abstract.<br>" + "To create a node of an abstract type inside of the host graph isn't allowed.";
                this.cannotCreateErrorMessage(" Create Node ", " a node", mesg);
                this.canCreateNode = false;
                return false;
            }
        } else if (this.eGraph == this.eGraph.getGraGra().getGraph() && arcType == null) {
            TypeError error = this.eGraph.getTypeSet().getBasisTypeSet().canCreateNode(this.eGraph.getBasisGraph(), t, this.eGraph.getGraGra().getLevelOfTypeGraphCheck());
            if (error != null) {
                String mesg = error.getMessage();
                this.cannotCreateErrorMessage(" Create Node ", " a node", mesg);
                this.canCreateNode = false;
                return false;
            }
        } else if (this.eGraph == this.eGraph.getGraGra().getGraph() && arcType != null && srcNodeType != null && (arcTypes = this.eGraph.getTypeSet().getBasisTypeSet().nodeTypeRequiresArcType(t, arcType, srcNodeType, this.eGraph.getGraGra().getLevelOfTypeGraphCheck())) != null && arcTypes.size() > 0) {
            String mesg = "Current node type  \"" + t.getName() + "\" \n" + "requires edge(s) of type: \n" + arcTypes.toString();
            this.cannotCreateErrorMessage(" Create Node ", " a node", mesg);
            this.canCreateNode = false;
            return false;
        }
        this.canCreateNode = true;
        return true;
    }

    public EdNode addNode(int x, int y) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return null;
        }
        if (this.eGraph.getBasisGraph().isTypeGraph() && ((TypeGraph)this.eGraph.getBasisGraph()).getTypeNode(this.eGraph.getTypeSet().getSelectedNodeType().getBasisType()) != null) {
            return null;
        }
        try {
            int X = (int)((double)x / this.scale);
            int Y = (int)((double)y / this.scale);
            EdNode en = this.eGraph.addNode(X, Y, this.visible);
            en.applyScale(this.scale);
            if (en.getBasisNode().xyAttr && en.getBasisNode().getContext().isCompleteGraph()) {
                ((ValueTuple)en.getBasisNode().getAttribute()).getValueMemberAt("thisX").setExprAsObject(en.getX());
                ((ValueTuple)en.getBasisNode().getAttribute()).getValueMemberAt("thisY").setExprAsObject(en.getY());
            }
            en.getLNode().setFrozenByDefault(true);
            this.eGraph.addCreatedToUndo(en);
            this.eGraph.undoManagerEndEdit();
            en.drawGraphic(this.getGraphics());
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
            this.addToGraphEmbedding(en);
            return en;
        }
        catch (TypeException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Create Node Error", 0);
            return null;
        }
    }

    private EdNode addNode(EdType nodeType, int x, int y) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return null;
        }
        try {
            int X = (int)((double)x / this.scale);
            int Y = (int)((double)y / this.scale);
            EdNode en = null;
            en = this.eGraph.addNode(X, Y, nodeType, true);
            en.applyScale(this.scale);
            if (en.getBasisNode().xyAttr && en.getBasisNode().getContext().isCompleteGraph()) {
                ((ValueTuple)en.getBasisNode().getAttribute()).getValueMemberAt("thisX").setExprAsObject(en.getX());
                ((ValueTuple)en.getBasisNode().getAttribute()).getValueMemberAt("thisY").setExprAsObject(en.getY());
            }
            en.getLNode().setFrozenByDefault(true);
            this.eGraph.addCreatedToUndo(en);
            this.eGraph.undoManagerEndEdit();
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
            this.addToGraphEmbedding(en);
            return en;
        }
        catch (TypeException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Create Node Error", 0);
            return null;
        }
    }

    private void addToGraphEmbedding(EdGraphObject sourceObject) {
        EdRuleScheme rs;
        EdRule kernelRule;
        if (this.eGraph.isSourceGraphOfGraphEmbedding() && (kernelRule = this.eGraph.getGraGra().getRule(this.eGraph.getBasisGraph())) != null && (rs = this.eGraph.getGraGra().getRuleScheme(kernelRule.getBasisRule())) != null) {
            rs.propagateAddGraphObjectToMultiRule(sourceObject);
        }
    }

    private void removeFromGraphEmbedding(EdGraphObject sourceObject) {
        EdRuleScheme rs;
        EdRule kernelRule;
        if (this.eGraph.isSourceGraphOfGraphEmbedding() && (kernelRule = this.eGraph.getGraGra().getRule(this.eGraph.getBasisGraph())) != null && (rs = this.eGraph.getGraGra().getRuleScheme(kernelRule.getBasisRule())) != null) {
            rs.propagateRemoveGraphObjectToMultiRule(sourceObject);
        }
    }

    public EdArc addArc(EdGraphObject s, EdGraphObject t, Point anch) throws TypeException {
        boolean doAddArc;
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return null;
        }
        boolean directed = !(this.eGraph.getBasisGraph() instanceof UndirectedGraph) && !(this.eGraph.getBasisGraph() instanceof UndirectedTypeGraph);
        boolean bl = doAddArc = !this.eGraph.isTypeGraph() || this.addSimilarParentArc(this.eGraph.getTypeSet().getSelectedArcType().getBasisType(), s.getType().getBasisType(), t.getType().getBasisType());
        if (doAddArc) {
            try {
                EdArc ea = null;
                if (anch != null) {
                    anch.x = (int)((double)anch.x / this.scale);
                    anch.y = (int)((double)anch.y / this.scale);
                }
                ea = this.eGraph.addArc(s, t, anch, directed);
                ea.applyScale(this.scale);
                if (anch != null) {
                    ea.getLArc().setFrozenByDefault(true);
                }
                this.eGraph.addCreatedToUndo(ea);
                this.eGraph.undoManagerEndEdit();
                this.changed = true;
                if (this.eGraph.getGraGra() != null) {
                    this.eGraph.getGraGra().setChanged(true);
                }
                this.addToGraphEmbedding(ea);
                return ea;
            }
            catch (TypeException e) {
                if (!this.eGraph.isTypeGraph()) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Create Edge Error", 0);
                }
                throw e;
            }
        }
        throw new TypeException(new TypeError(3, "The similar type edge is already defined for a child node types."));
    }

    private boolean addSimilarParentArc(Type t, Type source, Type target) {
        Arc a = ((TypeGraph)this.eGraph.getBasisGraph()).getTypeGraphChildArc(t, source, target);
        if (a != null) {
            Object[] options = new Object[]{"Continue", "Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "The similar type edge: <" + t.getName() + "> is already defined between parent node types.\n" + "Do you want continue to create this type edge?", "Similar Parent and Child Type Graph Edge ", -1, 2, null, options, options[1]);
            return answer == 0;
        }
        return true;
    }

    public boolean deleteObj(int x, int y) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return false;
        }
        try {
            return this.eGraph.deleteObj(x, y);
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Type Graph", " this object", e.getMessage());
            return false;
        }
    }

    public void deleteObj(EdGraphObject go) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        if (this.eGraph.getBasisGraph().isTypeGraph()) {
            this.deleteTypeGraphObject(go, new Vector<EdGraphObject>(), true);
        } else if (this.eGraph.isTargetObjOfGraphEmbedding(go)) {
            if (this.getGraGraEditor() != null) {
                JOptionPane.showMessageDialog(this.getGraGraEditor().applFrame, "Cannot delete this graph object. It should be deleted from the kernel rule.", "Delete Rule Object", 0);
            } else {
                JOptionPane.showMessageDialog(null, "Cannot delete this graph object. It should be deleted from the kernel rule.", "Delete Rule Object", 0);
            }
        } else if (go.isNode()) {
            this.deleteNodeObject((EdNode)go);
            this.unsetPicked();
            this.src = null;
        } else if (go.isArc()) {
            this.deleteArcObject((EdArc)go, false, false);
            this.unsetPicked();
            this.src = null;
        }
    }

    private void deleteNodeObject(EdNode go) {
        if (this.eGraph.isTargetObjOfGraphEmbedding(go)) {
            return;
        }
        try {
            TypeError typeError = null;
            Vector<EdArc> vIn = this.eGraph.getIncomingArcs(go);
            int i = 0;
            while (i < vIn.size()) {
                EdArc a = vIn.get(i);
                if (this.getViewport().getParentEditor() instanceof GraphEditor && (typeError = this.eGraph.getTypeSet().getBasisTypeSet().checkIfRemovable(a.getBasisArc(), false, true)) != null) {
                    this.cannotDeleteErrorMessage("Graph", " an arc", typeError.getMessage());
                    return;
                }
                this.eGraph.addDeletedToUndo(a);
                ++i;
            }
            Vector<EdArc> vOut = this.eGraph.getOutgoingArcs(go);
            int i2 = 0;
            while (i2 < vOut.size()) {
                EdArc a = vOut.get(i2);
                if (this.getViewport().getParentEditor() instanceof GraphEditor && (typeError = this.eGraph.getTypeSet().getBasisTypeSet().checkIfRemovable(a.getBasisArc(), true, false)) != null) {
                    this.cannotDeleteErrorMessage("Graph", " an arc", typeError.getMessage());
                    return;
                }
                if (!vIn.contains(a)) {
                    this.eGraph.addDeletedToUndo(a);
                }
                ++i2;
            }
            this.eGraph.addDeletedToUndo(go);
            this.removeFromGraphEmbedding(go);
            this.eGraph.deleteObj(go, false);
            this.eGraph.undoManagerEndEdit();
            this.updateUndoButton();
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Graph", " the object", e.getMessage());
        }
    }

    private void deleteArcObject(EdArc go, boolean deleteSrc, boolean deleteTar) {
        if (this.eGraph.isTargetObjOfGraphEmbedding(go)) {
            return;
        }
        boolean forceRemoveArc = false;
        if (this.getViewport().getParentEditor() instanceof GraphEditor) {
            TypeError typeError = this.eGraph.getTypeSet().getBasisTypeSet().checkIfRemovable(go.getBasisArc(), deleteSrc, deleteTar);
            if (typeError != null) {
                this.cannotDeleteErrorMessage("Graph", " an arc", typeError.getMessage());
                return;
            }
            forceRemoveArc = true;
        }
        try {
            this.eGraph.addDeletedToUndo(go);
            this.removeFromGraphEmbedding(go);
            this.eGraph.delSelectedArc(go, deleteSrc && deleteTar || forceRemoveArc);
            this.eGraph.undoManagerEndEdit();
            this.updateUndoButton();
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Type Graph", " an arc", e.getMessage());
        }
    }

    public void updateUndoButton() {
        if (this.viewport.getParentEditor() instanceof GraphEditor) {
            if (((GraphEditor)this.viewport.getParentEditor()).getGraGraEditor() != null) {
                ((GraphEditor)this.viewport.getParentEditor()).getGraGraEditor().updateUndoButton();
            }
        } else if (this.viewport.getParentEditor() instanceof RuleEditor && ((RuleEditor)this.viewport.getParentEditor()).getGraGraEditor() != null) {
            ((RuleEditor)this.viewport.getParentEditor()).getGraGraEditor().updateUndoButton();
        }
    }

    public void delArc(Arc bArc) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        try {
            this.eGraph.delArc(bArc);
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Type Graph", " an edge", e.getMessage());
        }
    }

    public void delNode(Node bNode) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        try {
            this.eGraph.delNode(bNode);
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Type Graph", " a node", e.getMessage());
        }
    }

    public void delSelectedNode(EdNode eNode) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        try {
            this.eGraph.delSelectedNode(eNode);
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Type Graph", " a node", e.getMessage());
        }
    }

    public void delSelectedArc(EdArc eArc) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        try {
            this.eGraph.delSelectedArc(eArc);
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        catch (TypeException e) {
            this.cannotDeleteErrorMessage("Type Graph", " an edge", e.getMessage());
        }
    }

    public void deleteSelectedNodes() {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        if (this.eGraph.getBasisGraph().isTypeGraph()) {
            this.deleteTypeGraphObject((List)this.eGraph.getSelectedObjs().clone());
        } else {
            try {
                this.eGraph.deleteSelectedNodes();
                this.changed = true;
                if (this.eGraph.getGraGra() != null) {
                    this.eGraph.getGraGra().setChanged(true);
                }
            }
            catch (TypeException e) {
                this.cannotDeleteErrorMessage("Type Graph", " a node", e.getMessage());
            }
        }
    }

    public void deleteSelectedArcs() {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        if (this.eGraph.getBasisGraph().isTypeGraph()) {
            this.deleteTypeGraphObject((List)this.eGraph.getSelectedObjs().clone());
        } else {
            try {
                this.eGraph.deleteSelectedArcs();
                this.changed = true;
                if (this.eGraph.getGraGra() != null) {
                    this.eGraph.getGraGra().setChanged(true);
                }
            }
            catch (TypeException e) {
                this.cannotDeleteErrorMessage("Type Graph", " an edge", e.getMessage());
            }
        }
    }

    public void deleteSelected() {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        if (this.eGraph.getBasisGraph().isTypeGraph()) {
            this.deleteTypeGraphObject((List)this.eGraph.getSelectedObjs().clone());
        } else {
            EdGraphObject obj;
            List list = (List)this.eGraph.getSelectedArcs().clone();
            int i = 0;
            while (i < list.size()) {
                obj = (EdArc)list.get(i);
                this.deleteArcObject((EdArc)obj, obj.getSource().isSelected(), obj.getTarget().isSelected());
                ++i;
            }
            list = (List)this.eGraph.getSelectedNodes().clone();
            i = 0;
            while (i < list.size()) {
                obj = (EdNode)list.get(i);
                this.deleteNodeObject((EdNode)obj);
                ++i;
            }
        }
    }

    private void deleteTypeGraphObject(List<?> gos) {
        EdGraphObject go;
        Vector<EdGraphObject> deletedObjs = new Vector<EdGraphObject>();
        boolean showWarning = true;
        int i = 0;
        while (i < gos.size()) {
            go = (EdGraphObject)gos.get(i);
            if (!go.isNode()) {
                this.deleteTypeGraphObject(go, deletedObjs, false);
            }
            ++i;
        }
        i = 0;
        while (i < gos.size()) {
            go = (EdGraphObject)gos.get(i);
            if (go.isNode()) {
                this.deleteTypeGraphObject(go, deletedObjs, false);
            }
            ++i;
        }
    }

    private void deleteTypeGraphObject(EdGraphObject go, List<EdGraphObject> deletedObjs, boolean showWarning) {
        block21: {
            if (deletedObjs.contains(go)) {
                return;
            }
            boolean canDelete = false;
            boolean used = true;
            String objstr = "";
            if (go.isNode()) {
                objstr = "node";
                if (!this.eGraph.getTypeSet().isTypeGraphNodeUsed(go.getType()) && !this.eGraph.getTypeSet().isChildTypeGraphNodeUsed(go.getType())) {
                    used = false;
                }
            } else if (go.isArc()) {
                objstr = "edge";
                if (!this.eGraph.getTypeSet().isTypeGraphArcUsed(go.getType(), ((EdArc)go).getSource().getType(), ((EdArc)go).getTarget().getType())) {
                    used = false;
                }
            }
            if (used) {
                if (this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() != 0) {
                    JOptionPane.showMessageDialog(null, "<html><body>Cannot delete type " + objstr + ".<br> " + "There are objects of the type " + objstr + " &nbsp;<i>" + go.getType().getName() + "</i><br>" + "Please disable the type graph before delete this type " + objstr, " Delete type ", 0);
                    return;
                }
                if (showWarning) {
                    Object[] options = new Object[]{"Delete", "Cancel"};
                    int answer = JOptionPane.showOptionDialog(null, "<html><body>Are you sure you want to delete the type " + objstr + " &nbsp;<i>" + go.getType().getName() + "</i> ?<br> " + "There are objects of it.", " Delete type ", -1, 2, null, options, options[0]);
                    if (answer == 0) {
                        canDelete = true;
                    }
                } else {
                    canDelete = true;
                }
            } else {
                canDelete = true;
            }
            if (canDelete) {
                Vector<EdGraphObject> objs = new Vector<EdGraphObject>();
                objs.add(go);
                deletedObjs.add(go);
                if (go.isNode()) {
                    Vector<EdArc> vIn = this.eGraph.getIncomingArcs((EdNode)go);
                    int i = 0;
                    while (i < vIn.size()) {
                        EdArc a = vIn.get(i);
                        if (!deletedObjs.contains(a)) {
                            objs.add(a);
                            deletedObjs.add(a);
                        }
                        ++i;
                    }
                    Vector<EdArc> vOut = this.eGraph.getOutgoingArcs((EdNode)go);
                    int i2 = 0;
                    while (i2 < vOut.size()) {
                        EdArc a = vOut.get(i2);
                        if (!deletedObjs.contains(a)) {
                            objs.add(a);
                            deletedObjs.add(a);
                        }
                        ++i2;
                    }
                }
                this.eGraph.addDeletedToUndo(objs);
                try {
                    this.eGraph.forceDeleteObj(go);
                    this.eGraph.undoManagerEndEdit();
                    this.updateUndoButton();
                    this.eGraph.refreshInheritanceArcs();
                    this.changed = true;
                    if (this.eGraph.getGraGra() != null) {
                        this.eGraph.getGraGra().setChanged(true);
                    }
                }
                catch (TypeException e) {
                    this.cannotDeleteErrorMessage("Type Graph", " this object", e.getMessage());
                    if (this.eGraph.getUndoManager() == null) break block21;
                    this.eGraph.getUndoManager().undo();
                    this.eGraph.getUndoManager().redo();
                }
            }
        }
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    private EdGraGra getGraGra() {
        if (this.viewport.getParentEditor() instanceof GraphEditor) {
            return ((GraphEditor)this.viewport.getParentEditor()).getGraGra();
        }
        if (this.viewport.getParentEditor() instanceof RuleEditor) {
            return ((RuleEditor)this.viewport.getParentEditor()).getGraGra();
        }
        return null;
    }

    private GraGraEditor getGraGraEditor() {
        if (this.viewport.getParentEditor() instanceof GraphEditor) {
            return ((GraphEditor)this.viewport.getParentEditor()).getGraGraEditor();
        }
        if (this.viewport.getParentEditor() instanceof RuleEditor) {
            return ((RuleEditor)this.viewport.getParentEditor()).getGraGraEditor();
        }
        return null;
    }

    public boolean isGraphEditor() {
        return this.viewport.getParentEditor() instanceof GraphEditor;
    }

    public boolean isRuleEditor() {
        return this.viewport.getParentEditor() instanceof RuleEditor;
    }

    public void performDeleteInheritanceRel(EdNode srcNode) {
        if (!(srcNode == null || this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() > 0 && this.eGraph.getTypeSet().isTypeUsed(srcNode.getType()))) {
            Vector<EdNode> parents = this.eGraph.getParentsOf(srcNode);
            if (!parents.isEmpty()) {
                boolean canRemoveIR;
                EdNode tarNode = parents.get(0);
                boolean bl = canRemoveIR = !this.eGraph.getTypeSet().hasTypeUser(srcNode.getType());
                if (!canRemoveIR) {
                    Vector<EdArc> usedArcTypes = this.eGraph.getTypeSet().getTypeArcOfInheritedArcsInUse(srcNode.getType().getBasisType(), tarNode.getType().getBasisType());
                    if (!usedArcTypes.isEmpty()) {
                        Vector<String> names = new Vector<String>(usedArcTypes.size());
                        int i = 0;
                        while (i < usedArcTypes.size()) {
                            names.add(usedArcTypes.get(i).getType().getName());
                            ++i;
                        }
                        Object[] options = new Object[]{"YES", "CANCEL"};
                        int answer = JOptionPane.showOptionDialog(null, "<html><body>Please note:<br>After removing this inheritance relation there is at least <br>one node object of a child node with an edge <br>of no more existent inheritance. <br>Edge type name:  " + names + " .<br><br>" + "Do you want to delete appropriate edges inside of all graphs?", " Remove Inheritance Relation ", -1, 3, null, options, options[0]);
                        if (answer == 0) {
                            EdGraGra gragra = this.getGraGra();
                            if (gragra != null) {
                                int i2 = 0;
                                while (i2 < usedArcTypes.size()) {
                                    EdGraphObject tgo = usedArcTypes.get(i2);
                                    gragra.deleteGraphObjectsOfType(tgo, false, true);
                                    ++i2;
                                }
                            }
                        } else {
                            return;
                        }
                        canRemoveIR = true;
                    } else {
                        canRemoveIR = true;
                    }
                }
                if (canRemoveIR) {
                    this.eGraph.addChangedParentToUndo(srcNode);
                    if (this.eGraph.deleteInheritanceRelation(srcNode, tarNode)) {
                        this.eGraph.undoManagerEndEdit();
                        this.eGraph.update();
                        this.canvas.repaint();
                        this.changed = true;
                        if (this.eGraph.getGraGra() != null) {
                            this.eGraph.getGraGra().setChanged(true);
                        }
                    } else {
                        this.eGraph.undoManagerLastEditDie();
                        this.errSound();
                        JOptionPane.showMessageDialog(null, "<html><body>This inheritance relation could not be removed.", " Remove Inheritance Relation ", 0);
                    }
                }
            } else {
                Type ptype = srcNode.getType().getBasisType().getParent();
                if (ptype != null) {
                    this.eGraph.getTypeSet().getBasisTypeSet().removeInheritanceRelation(srcNode.getType().getBasisType(), ptype);
                }
            }
        }
    }

    public void performDeleteInheritanceRel(EdNode srcNode, EdNode tarNode) {
        if (!(srcNode == null || this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() > 0 && this.eGraph.getTypeSet().isTypeUsed(srcNode.getType()))) {
            boolean canRemoveIR;
            boolean bl = canRemoveIR = !this.eGraph.getTypeSet().hasTypeUser(srcNode.getType());
            if (!canRemoveIR) {
                Vector<EdArc> usedArcTypes = this.eGraph.getTypeSet().getTypeArcOfInheritedArcsInUse(srcNode.getType().getBasisType(), tarNode.getType().getBasisType());
                if (!usedArcTypes.isEmpty()) {
                    Vector<String> names = new Vector<String>(usedArcTypes.size());
                    int i = 0;
                    while (i < usedArcTypes.size()) {
                        names.add(usedArcTypes.get(i).getType().getName());
                        ++i;
                    }
                    Object[] options = new Object[]{"YES", "CANCEL"};
                    int answer = JOptionPane.showOptionDialog(null, "<html><body>Please note:<br>After removing this inheritance relation there are at least <br>one node object of a child node with an edge <br>of no more existent inheritance. <br>Edge type name:  " + names + " .<br><br>" + "Do you want to delete appropriate edges inside of all graphs?", " Remove Inheritance Relation ", -1, 3, null, options, options[0]);
                    if (answer == 0) {
                        EdGraGra gragra = this.getGraGra();
                        if (gragra != null) {
                            int i2 = 0;
                            while (i2 < usedArcTypes.size()) {
                                EdArc tgo = usedArcTypes.get(i2);
                                gragra.deleteGraphObjectsOfType(tgo, false, true);
                                ++i2;
                            }
                        }
                    } else {
                        return;
                    }
                    canRemoveIR = true;
                } else {
                    canRemoveIR = true;
                }
            }
            if (canRemoveIR) {
                this.eGraph.addChangedParentToUndo(srcNode);
                if (this.eGraph.deleteInheritanceRelation(srcNode, tarNode)) {
                    this.eGraph.undoManagerEndEdit();
                    this.eGraph.update();
                    this.canvas.repaint();
                    this.changed = true;
                    if (this.eGraph.getGraGra() != null) {
                        this.eGraph.getGraGra().setChanged(true);
                    }
                } else {
                    this.eGraph.undoManagerLastEditDie();
                    this.errSound();
                    JOptionPane.showMessageDialog(null, "<html><body>This inheritance relation could not be removed.", " Remove Inheritance Relation ", 0);
                }
            }
        }
    }

    public boolean makeSelectionAt(int X, int Y) {
        EdGraphObject go = this.select(X, Y);
        if (go != null) {
            if (go.isNode()) {
                this.eGraph.drawNode(this.getGraphics(), (EdNode)go);
            } else {
                this.eGraph.drawArc(this.getGraphics(), (EdArc)go);
            }
            return true;
        }
        return false;
    }

    public void makeSelectionAt(EdGraphObject go) {
        if (go != null) {
            this.eGraph.select(go);
            if (go.isNode()) {
                this.eGraph.drawNode(this.getGraphics(), (EdNode)go);
            } else {
                this.eGraph.drawArc(this.getGraphics(), (EdArc)go);
            }
        }
    }

    public EdGraphObject select(int x, int y) {
        if (this.eGraph == null) {
            return null;
        }
        int X = (int)((double)x / this.scale);
        int Y = (int)((double)y / this.scale);
        EdGraphObject go = this.eGraph.select(X, Y);
        return go;
    }

    public void copySelected(int x, int y) {
        if (this.eGraph == null || !this.eGraph.isEditable()) {
            return;
        }
        EdType selNT = this.eGraph.getTypeSet().getSelectedNodeType();
        EdType selAT = this.eGraph.getTypeSet().getSelectedArcType();
        int X = (int)((double)(x + 10) / this.scale);
        int Y = (int)((double)(y + 10) / this.scale);
        Vector<EdGraphObject> res = this.eGraph.copySelected(X, Y);
        if (res != null && !res.isEmpty()) {
            Vector<EdGraphObject> vec = new Vector<EdGraphObject>(res);
            this.eGraph.addCreatedToUndo(vec);
            this.eGraph.undoManagerEndEdit();
            this.updateUndoButton();
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        if (selNT != null) {
            this.eGraph.getTypeSet().setSelectedNodeType(selNT);
        }
        if (selAT != null) {
            this.eGraph.getTypeSet().setSelectedArcType(selAT);
        }
    }

    public void copySelected(EdGraph targetGraph, int x, int y) {
        if (this.eGraph == null || !this.eGraph.isEditable() || targetGraph == null) {
            return;
        }
        EdType selNT = this.eGraph.getTypeSet().getSelectedNodeType();
        EdType selAT = this.eGraph.getTypeSet().getSelectedArcType();
        int X = (int)((double)(x + 10) / this.scale);
        int Y = (int)((double)(y + 10) / this.scale);
        targetGraph.setGraphToCopy(this.eGraph.getSelectedAsGraph());
        Vector<EdGraphObject> res = targetGraph.copySelected(X, Y);
        if (res != null && !res.isEmpty()) {
            Vector<EdGraphObject> vec = new Vector<EdGraphObject>(res);
            targetGraph.addCreatedToUndo(vec);
            targetGraph.undoManagerEndEdit();
            this.updateUndoButton();
            this.changed = true;
            if (this.eGraph.getGraGra() != null) {
                this.eGraph.getGraGra().setChanged(true);
            }
        }
        if (selNT != null) {
            this.eGraph.getTypeSet().setSelectedNodeType(selNT);
        }
        if (selAT != null) {
            this.eGraph.getTypeSet().setSelectedArcType(selAT);
        }
    }

    public void pasteCopy() {
        if (!this.eGraph.isEditable()) {
            return;
        }
        this.canvas.setMsg("");
        this.getGraph().eraseSelected(this.getGraphics(), true);
        this.copySelected(this.x0, this.y0);
        if (this.getGraph().getMsg().length() != 0) {
            this.setMsg("Copy / Paste : " + this.canvas.getGraph().getMsg());
        }
        this.getGraph().drawSelected(this.canvas.getGraphics());
        this.getGraph().deselectAll();
        Dimension dim = this.getGraph().getGraphDimension();
        if (dim.width != 0 && dim.height != 0) {
            if (dim.width < this.getWidth()) {
                dim.width = this.getWidth();
            }
            if (dim.height < this.getHeight()) {
                dim.height = this.getHeight();
            }
            this.setSize(dim);
        }
        this.repaint();
        this.unsetPicked();
        this.setChanged(true);
    }

    public void selectAll() {
        if (this.eGraph == null) {
            return;
        }
        this.eGraph.selectAll();
    }

    public void deselect(EdGraphObject ego) {
        if (this.eGraph == null) {
            return;
        }
        this.eGraph.deselect(ego);
    }

    public boolean deselectAll() {
        if (this.eGraph == null) {
            return false;
        }
        boolean hadSelection = false;
        if (this.eGraph.hasSelection()) {
            hadSelection = true;
            this.eGraph.deselectAll();
        }
        return hadSelection;
    }

    public boolean selectNodesOfSelectedNodeType() {
        if (this.eGraph == null) {
            return false;
        }
        boolean hasSelection = false;
        if (this.eGraph.hasSelection()) {
            hasSelection = true;
            this.eGraph.deselectAll();
        }
        this.eGraph.selectObjectsOfSelectedNodeType();
        if (this.eGraph.hasSelection()) {
            hasSelection = true;
        }
        return hasSelection;
    }

    public boolean selectArcsOfSelectedArcType() {
        if (this.eGraph == null) {
            return false;
        }
        boolean hasSelection = false;
        if (this.eGraph.hasSelection()) {
            hasSelection = true;
            this.eGraph.deselectAll();
        }
        this.eGraph.selectObjectsOfSelectedArcType();
        if (this.eGraph.hasSelection()) {
            hasSelection = true;
        }
        return hasSelection;
    }

    public boolean straigthSelectedArcs() {
        if (this.eGraph == null) {
            return false;
        }
        if (this.eGraph.hasSelection() && this.eGraph.straightSelectedArcs()) {
            this.changed = true;
            return true;
        }
        return false;
    }

    public void deselectAllWeakselected() {
        if (this.eGraph != null) {
            this.eGraph.deselectAllWeakselected();
        }
    }

    public void setAnchorPoint(Point p) {
        this.anchor = p;
    }

    public Point getAnchorPoint() {
        return this.anchor;
    }

    public void setPickedPoint(int startx, int starty) {
        this.x0 = startx;
        this.y0 = starty;
    }

    public Point getPickedPoint() {
        return new Point(this.x0, this.y0);
    }

    public void setPickedObject(EdGraphObject go) {
        this.pickedObj = go;
    }

    public EdGraphObject getPickedObject() {
        return this.pickedObj;
    }

    public void setSourceObject(EdGraphObject go) {
        this.src = go;
    }

    public EdGraphObject getSourceObject() {
        return this.src;
    }

    public void setTargetObject(EdGraphObject go) {
        this.tar = go;
    }

    public EdGraphObject getTargetObject() {
        return this.tar;
    }

    public EdGraphObject getPickedObject(int X, int Y, FontMetrics Fm) {
        this.pickedObj = null;
        this.pickedNode = null;
        this.pickedArc = null;
        this.pickedTextOfArc = null;
        this.pickedNode = this.eGraph.getPickedNode(X, Y);
        if (this.pickedNode != null) {
            this.pickedObj = this.pickedNode;
            return this.pickedNode;
        }
        this.pickedTextOfArc = this.eGraph.getPickedTextOfArc(X, Y, Fm);
        if (this.pickedTextOfArc != null) {
            this.pickedObj = this.pickedTextOfArc;
            return this.pickedTextOfArc;
        }
        this.pickedArc = this.eGraph.getPickedArc(X, Y);
        if (this.pickedArc != null) {
            this.pickedObj = this.pickedArc;
            return this.pickedArc;
        }
        return null;
    }

    public EdNode getPickedNode(int X, int Y) {
        return this.eGraph.getPickedNode(X, Y);
    }

    public EdArc getPickedArc(int X, int Y) {
        return this.eGraph.getPickedArc(X, Y);
    }

    public void draggingOfObject(MouseEvent e) {
        this.dx = 0;
        this.dy = 0;
        int x = e.getX();
        int y = e.getY();
        if (e.getX() <= 0) {
            x = 5;
        }
        if (e.getY() <= 0) {
            y = 5;
        }
        if (!this.startDragging) {
            this.startDragging = true;
            if (!this.pickedObj.isSelected()) {
                this.eGraph.addMovedToUndo(this.pickedObj);
            } else {
                this.eGraph.addMovedToUndo(this.eGraph.getSelectedObjs());
            }
        }
        this.dx = x - this.x0;
        this.dy = y - this.y0;
        if (Math.abs(this.dx) > 0 || Math.abs(this.dy) > 0) {
            this.dragged = true;
            this.x0 = x;
            this.y0 = y;
            if (!this.pickedObj.isSelected() || this.pickedObj.isArc()) {
                this.movePicked(x, y, this.dx, this.dy);
            } else if (this.pickedObj.isSelected() && !this.pickedObj.isArc()) {
                this.moveSelected(this.dx, this.dy);
                ((EdNode)this.pickedObj).drawShadowGraphic(this.getGraphics());
            }
        } else {
            this.dx = 0;
            this.dy = 0;
        }
    }

    public void endDraggingOfObject() {
        if (this.pickedObj != null && this.pickedObj.isNode()) {
            this.eGraph.undoManagerEndEdit();
            this.updateUndoButton();
        } else if (this.pickedTextOfArc != null) {
            this.eGraph.undoManagerEndEdit();
            this.updateUndoButton();
        } else if (this.pickedArc != null) {
            this.eGraph.undoManagerEndEdit();
            this.updateUndoButton();
        }
        this.updateAfterDraggingOfObject();
        if (this.eGraph.getGraGra() != null) {
            this.eGraph.getGraGra().setChanged(true);
        }
        this.startDragging = false;
        this.dragged = false;
        this.x0 = 0;
        this.y0 = 0;
    }

    private void updateAfterDraggingOfObject() {
        Dimension graphDim = this.getGraphDimension();
        if (graphDim.width != this.getWidth() || graphDim.height != this.getHeight()) {
            this.setSize(graphDim);
        }
        if (this.viewport.getParentEditor() instanceof RuleEditor && ((RuleEditor)this.viewport.getParentEditor()).isSynchronMoveOfMappedObjectsEnabled()) {
            if (this.viewport == ((RuleEditor)this.viewport.getParentEditor()).getRightPanel()) {
                ((RuleEditor)this.viewport.getParentEditor()).getLeftPanel().updateGraphics(true);
                ((RuleEditor)this.viewport.getParentEditor()).getNACPanel().updateGraphics(true);
            } else if (this.viewport == ((RuleEditor)this.viewport.getParentEditor()).getLeftPanel()) {
                ((RuleEditor)this.viewport.getParentEditor()).getRightPanel().updateGraphics(true);
                ((RuleEditor)this.viewport.getParentEditor()).getNACPanel().updateGraphics(true);
            } else if (this.viewport == ((RuleEditor)this.viewport.getParentEditor()).getNACPanel()) {
                ((RuleEditor)this.viewport.getParentEditor()).getRightPanel().updateGraphics(true);
                ((RuleEditor)this.viewport.getParentEditor()).getLeftPanel().updateGraphics(true);
            }
        }
    }

    public EdGraphObject getDraggedObject() {
        if (this.dragged) {
            return this.pickedObj;
        }
        return null;
    }

    public Dimension getDraggedDimension() {
        if (this.dragged) {
            return new Dimension(this.dx, this.dy);
        }
        return new Dimension(0, 0);
    }

    public void unsetPicked() {
        this.pickedObj = null;
        this.pickedNode = null;
        this.pickedArc = null;
        this.pickedTextOfArc = null;
    }

    public void resetScrollBars() {
        if (this.eGraph == null) {
            return;
        }
        if (this.scrollbarValueSaved) {
            this.hsb.setValue(this.hsbValue);
            this.vsb.setValue(this.vsbValue);
            this.scrollbarValueSaved = false;
            this.hsbValue = 0;
            this.vsbValue = 0;
        }
    }

    public void nodeToFront(int X, int Y) {
        this.pickedNode = this.eGraph.getPickedNode(X, Y);
        if (this.pickedNode != null) {
            this.eGraph.nodeToFront(this.pickedNode);
        }
    }

    public void nodeToFront(EdGraphObject go) {
        if (go != null && go.isNode()) {
            this.eGraph.nodeToFront((EdNode)go);
        }
    }

    public Dimension getGraphDimension() {
        if (this.eGraph != null) {
            return this.eGraph.getGraphDimension();
        }
        return new Dimension(0, 0);
    }

    private void movePicked(int pX, int pY, int dX, int dY) {
        if (this.pickedNode != null) {
            if (this.pickedNode.getX() + dX >= 0 && this.pickedNode.getY() + dY >= 0) {
                this.eGraph.moveNode(this.pickedNode, dX, dY);
                this.pickedNode.getLNode().setFrozenByDefault(true);
                this.pickedNode.drawShadowGraphic(this.getGraphics());
                if (this.pickedNode.getBasisNode().xyAttr && this.pickedNode.getBasisNode().getContext().isCompleteGraph()) {
                    ((ValueTuple)this.pickedNode.getBasisNode().getAttribute()).getValueMemberAt("thisX").setExprAsObject(this.pickedNode.getX());
                    ((ValueTuple)this.pickedNode.getBasisNode().getAttribute()).getValueMemberAt("thisY").setExprAsObject(this.pickedNode.getY());
                }
            }
        } else if (this.pickedTextOfArc != null) {
            this.eGraph.moveTextOfArc(this.pickedTextOfArc, dX, dY);
            this.pickedTextOfArc.drawTextShadowGraphic(this.getGraphics(), pX, pY);
        } else if (this.pickedArc != null) {
            this.eGraph.moveArc(this.pickedArc, dX, dY);
            this.pickedArc.drawShadowGraphic(this.getGraphics());
        }
    }

    public void setEdgeAnchorVisible(boolean b) {
        this.showAnchor = b;
    }

    public boolean isEdgeAnchorVisible() {
        return this.showAnchor;
    }

    public void setMagicEdgeSupportEnabled(boolean b) {
        this.magicArcEnabled = b;
    }

    public boolean isMagicEdgeSupportEnabled() {
        return this.magicArcEnabled;
    }

    public void startMagicArc(int X, int Y) {
        if (this.src != null) {
            this.magicArcStart = new Point(this.src.getX(), this.src.getY());
        }
    }

    public void setMagicArcStart(Point p) {
        this.magicArcStart = p;
    }

    public void drawMagicArc(EdNode from, int x, int y) {
        if (this.magicArcStart != null) {
            EdNode to;
            Graphics2D g = (Graphics2D)this.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(Color.GREEN);
            g.setStroke(new BasicStroke(2.0f));
            g.draw(new Line2D.Double(x, y, x, y));
            if (!this.checkSourceOfMagicArc((EdNode)this.src, this.src.getX(), this.src.getY())) {
                this.drawErrorImage(this.src.getX(), this.src.getY());
            }
            if ((to = this.getPickedNode(x, y)) != null) {
                if (this.checkTargetOfMagicArc(from, to)) {
                    this.drawOKImage(1, x, y);
                    this.arcError = false;
                } else {
                    this.drawErrorImage(x, y);
                    this.arcError = true;
                }
            } else if (this.checkTargetOfMagicArc(this.src.getType(), this.eGraph.getTypeSet().getSelectedNodeType())) {
                this.drawOKImage(1, x, y);
                this.arcError = false;
            } else {
                EdType arcType = this.eGraph.getTypeSet().getSelectedArcType();
                if (arcType != null) {
                    Vector<Type> v = arcType.getBasisType().getTargetsOfArc(this.src.getType().getBasisType());
                    if (!this.eGraph.isTypeGraph() && v.size() == 1) {
                        this.drawOKImage(0, x, y);
                        this.arcError = false;
                    } else {
                        this.drawErrorImage(x, y);
                        this.arcError = true;
                    }
                }
            }
        }
    }

    public void drawErrorImage(int x, int y) {
        ((Graphics2D)this.getGraphics()).drawImage(this.errorImage.getImage(), this.src.getX(), this.src.getY(), null);
    }

    public void drawOKImage(int kind, int x, int y) {
        if (kind == 0) {
            ((Graphics2D)this.getGraphics()).drawImage(this.okImage.getImage(), this.src.getX(), this.src.getY(), null);
        } else if (kind == 1) {
            ((Graphics2D)this.getGraphics()).drawImage(this.smileImage.getImage(), this.src.getX(), this.src.getY(), null);
        }
    }

    public boolean checkSourceOfMagicArc(EdNode from, int x, int y) {
        int tgl;
        if (this.eGraph.getTypeSet().getTypeGraph() != null && (tgl = this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck()) > 0) {
            EdType arcType = this.eGraph.getTypeSet().getSelectedArcType();
            boolean error = false;
            if (arcType != null) {
                if (!this.eGraph.isTypeGraph()) {
                    boolean bl = error = !arcType.getBasisType().hasTypeGraphArc(from.getType().getBasisType());
                }
                if (error) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return this.eGraph.getTypeSet().getSelectedArcType() != null;
    }

    public boolean checkTargetOfArc(EdNode from, EdNode to) {
        return this.checkTargetOfMagicArc(from, to);
    }

    private boolean checkTargetOfMagicArc(EdNode from, EdNode to) {
        int tgl;
        if (this.eGraph.getTypeSet().getTypeGraph() != null && (tgl = this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck()) > 0) {
            EdType arcType = this.eGraph.getTypeSet().getSelectedArcType();
            boolean error = false;
            if (arcType != null) {
                if (this.eGraph.isTypeGraph()) {
                    error = this.eGraph.getTypeSet().getBasisTypeSet().getTypeGraphArc(arcType.getBasisType(), from.getType().getBasisType(), to.getType().getBasisType()) != null;
                } else {
                    boolean bl = error = !arcType.getBasisType().isEdgeCreatable(from.getType().getBasisType(), to.getType().getBasisType(), tgl);
                }
                if (error) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return this.eGraph.getTypeSet().getSelectedArcType() != null;
    }

    private boolean checkTargetOfMagicArc(EdType from, EdType to) {
        if (this.eGraph.getTypeSet().getTypeGraph() != null) {
            int tgl = this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck();
            boolean error = false;
            EdType arcType = this.eGraph.getTypeSet().getSelectedArcType();
            if (tgl > 0) {
                if (!this.eGraph.isTypeGraph()) {
                    error = !arcType.getBasisType().isEdgeCreatable(from.getBasisType(), to.getBasisType(), tgl);
                } else {
                    boolean bl = error = this.eGraph.getTypeSet().getBasisTypeSet().getTypeGraphNode(to.getBasisType()) != null;
                    if (!error) {
                        boolean bl2 = error = this.eGraph.getTypeSet().getBasisTypeSet().getTypeGraphArc(arcType.getBasisType(), from.getBasisType(), to.getBasisType()) != null;
                    }
                }
                if (error) {
                    return false;
                }
            } else if (this.eGraph.isTypeGraph()) {
                boolean bl = error = this.eGraph.getTypeSet().getBasisTypeSet().getTypeGraphNode(to.getBasisType()) != null;
                if (!error) {
                    boolean bl3 = error = this.eGraph.getTypeSet().getBasisTypeSet().getTypeGraphArc(arcType.getBasisType(), from.getBasisType(), to.getBasisType()) != null;
                }
                if (error) {
                    return false;
                }
            }
        }
        return this.eGraph.getTypeSet().getSelectedArcType() != null;
    }

    private void makeArcWithTargetAt(int X, int Y) {
        if (this.mode == 113) {
            return;
        }
        boolean tarWasNull = false;
        this.tar = this.getPickedNode(X, Y);
        if (this.tar == null) {
            tarWasNull = true;
            EdType arcType = this.eGraph.getTypeSet().getSelectedArcType();
            if (arcType != null) {
                Vector<Type> v = arcType.getBasisType().getTargetsOfArc(this.src.getType().getBasisType());
                if (this.checkTargetOfMagicArc(this.src.getType(), this.eGraph.getTypeSet().getSelectedNodeType())) {
                    EdType nodeType = this.eGraph.getTypeSet().getSelectedNodeType();
                    if (v.size() == 1) {
                        nodeType = this.eGraph.getTypeSet().getNodeType(v.firstElement());
                    }
                    if (this.canCreateNodeOfType(nodeType.getBasisType(), arcType.getBasisType(), this.src.getType().getBasisType())) {
                        this.tar = this.addNode(nodeType, X, Y);
                    }
                } else if (!this.eGraph.isTypeGraph()) {
                    if (v.size() == 1) {
                        EdType nodeType = this.eGraph.getTypeSet().getNodeType(v.firstElement());
                        if (this.canCreateNodeOfType(nodeType.getBasisType(), arcType.getBasisType(), this.src.getType().getBasisType())) {
                            this.tar = this.addNode(nodeType, X, Y);
                        }
                    } else if (v.size() == 0 && this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() > 0 && this.eGraph.getTypeSet().getTypeGraph().getArcs(this.eGraph.getTypeSet().getSelectedArcType()).isEmpty()) {
                        this.cannotCreateErrorMessage(" Create edge ", " an edge", "Edge type &nbsp;<i>" + this.eGraph.getTypeSet().getSelectedArcType().getBasisType().getName() + "</i>&nbsp; isn't defined in the type graph.");
                    }
                }
            }
        }
        if (this.tar != null) {
            if (this.eGraph.getTypeSet().getSelectedArcType() != null) {
                try {
                    EdArc ea = this.addArc(this.src, this.tar, this.anchor);
                    if (ea != null) {
                        this.eGraph.drawArc(this.getGraphics(), ea);
                    } else if (tarWasNull) {
                        ((EditUndoManager)this.eGraph.getUndoManager()).undo();
                    }
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            ((EdNode)this.src).applyScale(this.scale);
            ((EdNode)this.src).getLNode().setFrozenByDefault(true);
            ((EdNode)this.src).drawGraphic(this.getGraphics());
            ((EdNode)this.tar).applyScale(this.scale);
            ((EdNode)this.tar).getLNode().setFrozenByDefault(true);
            ((EdNode)this.tar).drawGraphic(this.getGraphics());
        }
        this.mode = 11;
    }

    public void makeArcByMagicArc(int X, int Y) {
        boolean tarWasNull = false;
        this.tar = this.getPickedNode(X, Y);
        if (this.tar == null) {
            tarWasNull = true;
            EdType arcType = this.eGraph.getTypeSet().getSelectedArcType();
            if (arcType == null) {
                this.cannotCreateErrorMessage(" Create edge ", " an edge", "There isn't any edge type selected.");
            } else if (this.src != null) {
                Vector<Type> v = arcType.getBasisType().getTargetsOfArc(this.src.getType().getBasisType());
                if (this.checkTargetOfMagicArc(this.src.getType(), this.eGraph.getTypeSet().getSelectedNodeType())) {
                    if (v.size() == 1) {
                        EdType nodeType = this.eGraph.getTypeSet().getNodeType(v.firstElement());
                        if (this.canCreateNodeOfType(nodeType.getBasisType(), arcType.getBasisType(), this.src.getType().getBasisType())) {
                            this.tar = this.addNode(nodeType, X, Y);
                            if (this.tar != null) {
                                ((EdNode)this.tar).applyScale(this.scale);
                                ((EdNode)this.tar).getLNode().setFrozenByDefault(true);
                                ((EdNode)this.tar).drawGraphic(this.getGraphics());
                            }
                        }
                    } else {
                        EdType nodeType = this.eGraph.getTypeSet().getSelectedNodeType();
                        if (this.canCreateNodeOfType(nodeType.getBasisType(), arcType.getBasisType(), this.src.getType().getBasisType())) {
                            this.tar = this.addNode(nodeType, X, Y);
                            if (this.tar != null) {
                                ((EdNode)this.tar).applyScale(this.scale);
                                ((EdNode)this.tar).getLNode().setFrozenByDefault(true);
                                ((EdNode)this.tar).drawGraphic(this.getGraphics());
                            }
                        }
                    }
                } else if (!this.eGraph.isTypeGraph()) {
                    if (v.size() == 1) {
                        EdType nodeType = this.eGraph.getTypeSet().getNodeType(v.firstElement());
                        if (this.canCreateNodeOfType(nodeType.getBasisType(), arcType.getBasisType(), this.src.getType().getBasisType())) {
                            this.tar = this.addNode(nodeType, X, Y);
                            if (this.tar != null) {
                                ((EdNode)this.tar).applyScale(this.scale);
                                ((EdNode)this.tar).getLNode().setFrozenByDefault(true);
                                ((EdNode)this.tar).drawGraphic(this.getGraphics());
                            }
                        }
                    } else if (v.size() == 0 && this.eGraph.getTypeSet().getBasisTypeSet().getLevelOfTypeGraphCheck() > 0 && this.eGraph.getTypeSet().getTypeGraph().getArcs(this.eGraph.getTypeSet().getSelectedArcType()).isEmpty()) {
                        this.cannotCreateErrorMessage(" Create edge ", " an edge", "Edge type &nbsp;<i>" + this.eGraph.getTypeSet().getSelectedArcType().getBasisType().getName() + "</i>&nbsp; isn't defined in the type graph.");
                    }
                }
            }
        }
        if (this.tar != null) {
            if (this.eGraph.getTypeSet().getSelectedArcType() == null) {
                this.cannotCreateErrorMessage(" Create edge ", " an edge", "There isn't any edge type selected.");
            } else if (!this.arcError) {
                try {
                    EdArc ea = this.addArc(this.src, this.tar, this.anchor);
                    if (ea != null) {
                        this.eGraph.drawArc(this.getGraphics(), ea);
                        this.mode = 11;
                    } else if (tarWasNull) {
                        ((EditUndoManager)this.eGraph.getUndoManager()).undo();
                    }
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
        }
        if (this.tar == null) {
            this.canvas.propagateMoveEditMode();
        }
        this.removeMagicArc();
        this.update(this.getGraphics());
    }

    public void removeMagicArc() {
        this.src = null;
        this.tar = null;
        this.anchor = null;
        this.magicArcStart = null;
        this.isMagicArc = false;
    }

    public void startSelectBox(int X, int Y) {
        selBox.setLocation(X, Y);
        this.selBoxOpen = true;
    }

    public boolean isSelectBoxOpen() {
        return this.selBoxOpen;
    }

    public int getSelectBoxSize() {
        return GraphCanvas.selBox.width;
    }

    public boolean resizeSelectBox(int X, int Y) {
        if (this.selBoxOpen && X - GraphCanvas.selBox.x > 0 && Y - GraphCanvas.selBox.y > 0) {
            selBox.setSize(X - GraphCanvas.selBox.x, Y - GraphCanvas.selBox.y);
            this.drawSelectBox((Graphics2D)this.getGraphics(), Color.GREEN);
            return true;
        }
        return false;
    }

    public void selectObjectsInsideOfSelectBoxAndClose() {
        this.selectObjectsInside(selBox);
        this.closeSelectBox();
    }

    private void closeSelectBox() {
        this.drawSelectBox((Graphics2D)this.getGraphics(), Color.WHITE);
        selBox.setLocation(0, 0);
        selBox.setSize(0, 0);
        this.selBoxOpen = false;
    }

    public boolean startScrolling(int X, int Y) {
        if (this.hsb.isShowing() || this.vsb.isShowing()) {
            ((Graphics2D)this.getGraphics()).drawImage(this.scrollImage.getImage(), X, Y, null);
            return true;
        }
        return false;
    }

    public void endScrolling() {
        this.scrolling = false;
        this.scrollingByDragging = false;
        this.update(this.getGraphics());
    }

    public void scrollGraph(int X0, int Y0, int X, int Y) {
        int dX = X - X0;
        int dY = Y - Y0;
        if (dX > 0) {
            if (this.hsb.getValue() < this.hsb.getMaximum() - this.hsb.getVisibleAmount()) {
                this.hsb.setValue(this.hsb.getValue() + dX);
            }
        } else if (dX < 0 && this.hsb.getValue() > 0) {
            this.hsb.setValue(this.hsb.getValue() + dX);
        }
        if (dY > 0) {
            if (this.vsb.getValue() < this.vsb.getMaximum() - this.vsb.getVisibleAmount()) {
                this.vsb.setValue(this.vsb.getValue() + dY);
            }
        } else if (dY < 0 && this.vsb.getValue() > 0) {
            this.vsb.setValue(this.vsb.getValue() + dY);
        }
    }

    private void selectObjectsInside(Rectangle rect) {
        EdNode n;
        Vector<EdGraphObject> selSet = new Vector<EdGraphObject>();
        int k = -1;
        boolean deselectDone = false;
        int i = 0;
        while (i < this.eGraph.getNodes().size()) {
            n = this.eGraph.getNodes().get(i);
            if (rect.contains(n.getX(), n.getY())) {
                if (!deselectDone) {
                    this.eGraph.deselectAll();
                    deselectDone = true;
                }
                this.eGraph.select(n);
                selSet.add(n);
                k = i + 1;
                break;
            }
            ++i;
        }
        if (k == -1) {
            return;
        }
        i = k;
        while (i < this.eGraph.getNodes().size()) {
            n = this.eGraph.getNodes().get(i);
            if (rect.contains(n.getX(), n.getY())) {
                this.eGraph.select(n);
                selSet.add(n);
            }
            ++i;
        }
        i = 0;
        while (i < this.eGraph.getArcs().size()) {
            EdArc ea = this.eGraph.getArcs().elementAt(i);
            if (selSet.contains(ea.getSource()) && selSet.contains(ea.getTarget())) {
                this.eGraph.select(ea);
                selSet.add(ea);
            }
            ++i;
        }
        if (selSet.isEmpty()) {
            this.setForeground(Color.WHITE);
            ((Graphics2D)this.getGraphics()).draw(selBox);
            this.setForeground(Color.BLACK);
        }
        this.closeSelectBox();
    }

    private void moveSelected(int DX, int DY) {
        int i = 0;
        while (i < this.eGraph.getSelectedNodes().size()) {
            EdNode en = this.eGraph.getSelectedNodes().elementAt(i);
            this.eGraph.moveNodeAndNotSelectedInOutArcs(en, DX, DY);
            if (this.pickedNode.getBasisNode().xyAttr && this.pickedNode.getBasisNode().getContext().isCompleteGraph()) {
                ((ValueTuple)en.getBasisNode().getAttribute()).getValueMemberAt("thisX").setExprAsObject(en.getX());
                ((ValueTuple)en.getBasisNode().getAttribute()).getValueMemberAt("thisY").setExprAsObject(en.getY());
            }
            ++i;
        }
        i = 0;
        while (i < this.eGraph.getArcs().size()) {
            EdArc ea = this.eGraph.getArcs().elementAt(i);
            if (ea.isLine() && ea.hasAnchor()) {
                if (ea.isSelected()) {
                    if (ea.getSource().isSelected() && ea.getTarget().isSelected()) {
                        ea.setAnchor(new Point(ea.getAnchor().x + DX, ea.getAnchor().y + DY));
                    } else {
                        ea.setAnchor(new Point(ea.getAnchor().x + DX / 2, ea.getAnchor().y + DY / 2));
                    }
                }
            } else if (!ea.isLine() && ea == this.pickedArc && !ea.getSource().isSelected()) {
                Loop loop = ea.toLoop();
                loop.move(((EdNode)ea.getSource()).toRectangle(), ea.getAnchorID(), DX, DY);
                ea.setAnchor(1, new Point(loop.x, loop.y));
                ea.setWidth(loop.w);
                ea.setHeight(loop.h);
            }
            ++i;
        }
    }

    private void resetValueOfScrollbar(int dependOn) {
        if (this.eGraph == null) {
            return;
        }
        if (dependOn == 0 && this.eGraph.getNodes().size() != 0) {
            EdGraphObject go = this.eGraph.getNodes().lastElement();
            if (go.getX() >= this.hsb.getValue() + this.hsb.getVisibleAmount()) {
                this.hsbValue = go.getX() + go.getWidth() - this.hsb.getVisibleAmount();
                this.hsb.setValue(this.hsbValue);
                this.hsbValue = 0;
            }
            if (go.getY() >= this.vsb.getValue() + this.vsb.getVisibleAmount()) {
                this.vsbValue = go.getY() + go.getHeight() - this.vsb.getVisibleAmount();
                this.vsb.setValue(this.vsbValue);
                this.vsbValue = 0;
            }
        }
    }

    private void cannotDeleteErrorMessage(String title, String what, String mesg) {
        String str = "<html><body>Cannot delete " + what + ".<br>" + mesg;
        JOptionPane.showMessageDialog(null, str, title, 0);
    }

    public void cannotCreateErrorMessage(String title, String what, String mesg) {
        String str = "<html><body>Cannot create " + what + ".<br>" + mesg;
        JOptionPane.showMessageDialog(null, str, title, 0);
    }

    private void errSound() {
        Frame f = new Frame("Test");
        f.pack();
        this.tk = f.getToolkit();
        this.tk.beep();
    }
}

