/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class EdRuleScheme
extends EdRule {
    protected String name;
    protected EdRule itsKernelRule;
    protected final List<EdRule> itsMultiRules;
    protected EdRule itsAmalgamatedRule;

    public EdRuleScheme(RuleScheme ruleScheme, EdTypeSet types) {
        super(ruleScheme, types);
        this.name = ruleScheme.getSchemeName();
        this.itsKernelRule = new EdRule(ruleScheme.getKernelRule(), types);
        this.itsMultiRules = new Vector<EdRule>();
        this.createMultiRules(ruleScheme.getMultiRules());
        if (ruleScheme.getAmalgamatedRule() != null) {
            this.makeAmalgamatedRule(ruleScheme.getAmalgamatedRule());
        }
    }

    @Override
    public void dispose() {
        if (this.itsAmalgamatedRule != null) {
            this.itsAmalgamatedRule.dispose();
        }
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            this.itsMultiRules.remove(0).dispose();
            ++i;
        }
        this.itsKernelRule.dispose();
        this.name = "";
        super.dispose();
    }

    public RuleScheme getBasisRuleScheme() {
        return (RuleScheme)this.bRule;
    }

    @Override
    public void setGraGra(EdGraGra gra) {
        super.setGraGra(gra);
        this.itsKernelRule.setGraGra(gra);
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            multiRule.setGraGra(gra);
            ++i;
        }
        if (this.itsAmalgamatedRule != null) {
            this.itsAmalgamatedRule.setGraGra(gra);
        }
    }

    @Override
    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
        this.itsKernelRule.setUndoManager(this.undoManager);
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            multiRule.setUndoManager(this.undoManager);
            ++i;
        }
    }

    public EdRule getRule(String rulename) {
        if (this.itsKernelRule.getName().equals(rulename) || rulename.equals(String.valueOf(this.getName()) + "." + this.itsKernelRule.getName())) {
            return this.itsKernelRule;
        }
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            if (multiRule.getName().equals(rulename) || rulename.equals(String.valueOf(this.getName()) + "." + multiRule.getName())) {
                return multiRule;
            }
            ++i;
        }
        return null;
    }

    public EdRule getKernelRule() {
        return this.itsKernelRule;
    }

    public List<EdRule> getMultiRules() {
        return this.itsMultiRules;
    }

    public EdRule getMultiRule(Rule basisRule) {
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            if (multiRule.getBasisRule() == basisRule) {
                return multiRule;
            }
            ++i;
        }
        return null;
    }

    public EdRule getMultiRule(Graph g) {
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            if (multiRule.getBasisRule().getLeft() == g || multiRule.getBasisRule().getRight() == g) {
                return multiRule;
            }
            ++i;
        }
        return null;
    }

    public EdRule getKernelRule(Graph g) {
        if (this.itsKernelRule.getBasisRule().getLeft() == g || this.itsKernelRule.getBasisRule().getRight() == g) {
            return this.itsKernelRule;
        }
        return null;
    }

    public EdRule getRule(Graph g) {
        EdRule r = this.getKernelRule(g);
        if (r == null) {
            r = this.getMultiRule(g);
        }
        return r;
    }

    public boolean isRuleOfScheme(Rule r) {
        return ((RuleScheme)this.bRule).isRuleOfScheme(r);
    }

    public EdRule getAmalgamatedRule() {
        if (this.itsAmalgamatedRule != null) {
            return this.itsAmalgamatedRule;
        }
        if (((RuleScheme)this.bRule).getAmalgamatedRule() != null) {
            this.makeAmalgamatedRule(((RuleScheme)this.bRule).getAmalgamatedRule());
            return this.itsAmalgamatedRule;
        }
        return null;
    }

    public void createMultiRules(List<Rule> multiRules) {
        int i = 0;
        while (i < multiRules.size()) {
            MultiRule multiRule = (MultiRule)multiRules.get(i);
            EdRule r = new EdRule(multiRule, this.getTypeSet());
            r.setGraGra(this.eGra);
            r.setUndoManager(this.undoManager);
            this.itsMultiRules.add(r);
            ++i;
        }
    }

    public EdRule addMultiRule(String ruleName) {
        MultiRule mr = (MultiRule)((RuleScheme)this.getBasisRule()).addMultiRule(ruleName);
        EdRule r = new EdRule(mr, this.getTypeSet());
        this.applyLayoutOfKernelRule(r);
        r.setGraGra(this.eGra);
        r.setUndoManager(this.undoManager);
        this.itsMultiRules.add(r);
        return r;
    }

    private EdNode addNodeCopy(EdNode sourceNode, EdGraph targetGraph) {
        EdNode en = targetGraph.copyNode(sourceNode, sourceNode.getX(), sourceNode.getY());
        return en;
    }

    private EdArc addArcCopy(EdArc sourceArc, EdGraphObject targetSrc, EdGraphObject targetTar, EdGraph targetGraph) {
        EdArc ea = targetGraph.copyArc(sourceArc, targetSrc, targetTar);
        return ea;
    }

    public void propagateAddGraphObjectToMultiRule(EdGraphObject kernObj) {
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdArc copy;
            EdNode tarObj;
            EdNode srcObj;
            Node btarObj2;
            Node bsrcObj;
            EdNode copy2;
            EdRule mr = this.itsMultiRules.get(i);
            if (this.itsKernelRule.getLeft() == kernObj.getContext()) {
                if (kernObj.isNode()) {
                    copy2 = this.addNodeCopy((EdNode)kernObj, mr.getLeft());
                    if (copy2 != null) {
                        try {
                            ((MultiRule)mr.getBasisRule()).addEmbeddingLeft(kernObj.getBasisObject(), copy2.getBasisObject());
                            copy2.addContextUsage(String.valueOf(kernObj.hashCode()));
                            copy2.addContextUsage(kernObj.getContextUsage());
                        }
                        catch (BadMappingException badMappingException) {}
                    }
                } else {
                    bsrcObj = (Node)((MultiRule)mr.getBasisRule()).getEmbeddingLeft().getImage(((EdArc)kernObj).getSource().getBasisObject());
                    btarObj2 = (Node)((MultiRule)mr.getBasisRule()).getEmbeddingLeft().getImage(((EdArc)kernObj).getTarget().getBasisObject());
                    if (bsrcObj != null && btarObj2 != null) {
                        srcObj = mr.getLeft().findNode(bsrcObj);
                        tarObj = mr.getLeft().findNode(btarObj2);
                        if (srcObj != null && tarObj != null && (copy = this.addArcCopy((EdArc)kernObj, srcObj, tarObj, mr.getLeft())) != null) {
                            try {
                                copy.addContextUsage(kernObj.getContextUsage());
                                ((MultiRule)mr.getBasisRule()).addEmbeddingLeft(kernObj.getBasisObject(), copy.getBasisObject());
                            }
                            catch (BadMappingException badMappingException) {}
                        }
                    }
                }
            } else if (this.itsKernelRule.getRight() == kernObj.getContext()) {
                if (kernObj.isNode()) {
                    copy2 = this.addNodeCopy((EdNode)kernObj, mr.getRight());
                    if (copy2 != null) {
                        try {
                            ((MultiRule)mr.getBasisRule()).addEmbeddingRight(kernObj.getBasisObject(), copy2.getBasisObject());
                            copy2.addContextUsage(String.valueOf(kernObj.hashCode()));
                            copy2.addContextUsage(kernObj.getContextUsage());
                        }
                        catch (BadMappingException btarObj2) {}
                    }
                } else {
                    bsrcObj = (Node)((MultiRule)mr.getBasisRule()).getEmbeddingRight().getImage(((EdArc)kernObj).getSource().getBasisObject());
                    btarObj2 = (Node)((MultiRule)mr.getBasisRule()).getEmbeddingRight().getImage(((EdArc)kernObj).getTarget().getBasisObject());
                    if (bsrcObj != null && btarObj2 != null) {
                        srcObj = mr.getRight().findNode(bsrcObj);
                        tarObj = mr.getRight().findNode(btarObj2);
                        if (srcObj != null && tarObj != null && (copy = this.addArcCopy((EdArc)kernObj, srcObj, tarObj, mr.getRight())) != null) {
                            try {
                                copy.addContextUsage(kernObj.getContextUsage());
                                ((MultiRule)mr.getBasisRule()).addEmbeddingRight(kernObj.getBasisObject(), copy.getBasisObject());
                            }
                            catch (BadMappingException badMappingException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void propagateRemoveGraphObjectToMultiRule(EdGraphObject srcObject) {
        if (srcObject.isNode()) {
            EdArc arc;
            Vector<EdArc> arcs = srcObject.getContext().getIncomingArcs((EdNode)srcObject);
            int i = 0;
            while (i < arcs.size()) {
                arc = arcs.get(i);
                this.propagateRemoveGraphObjectToMultiRule(arc);
                ++i;
            }
            arcs = srcObject.getContext().getOutgoingArcs((EdNode)srcObject);
            i = 0;
            while (i < arcs.size()) {
                arc = arcs.get(i);
                this.propagateRemoveGraphObjectToMultiRule(arc);
                ++i;
            }
        }
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            Arc bArc;
            Node bNode;
            EdGraphObject tarObj;
            EdRule mr = this.itsMultiRules.get(i);
            if (this.itsKernelRule.getLeft() == srcObject.getContext()) {
                tarObj = mr.getLeft().findGraphObject(((MultiRule)mr.getBasisRule()).getEmbeddingLeft().getImage(srcObject.getBasisObject()));
                if (srcObject.isNode()) {
                    bNode = (Node)((MultiRule)mr.getBasisRule()).getEmbeddingLeft().getImage(srcObject.getBasisObject());
                    if (bNode != null) {
                        try {
                            ((MultiRule)mr.getBasisRule()).removeEmbeddingLeft(srcObject.getBasisObject());
                            srcObject.addContextUsage(String.valueOf(tarObj.hashCode()));
                            mr.getLeft().delNode(bNode);
                        }
                        catch (TypeException typeException) {}
                    }
                } else {
                    bArc = (Arc)((MultiRule)mr.getBasisRule()).getEmbeddingLeft().getImage(srcObject.getBasisObject());
                    if (bArc != null) {
                        try {
                            ((MultiRule)mr.getBasisRule()).removeEmbeddingLeft(srcObject.getBasisObject());
                            srcObject.addContextUsage(String.valueOf(tarObj.hashCode()));
                            mr.getLeft().delArc(bArc);
                        }
                        catch (TypeException typeException) {}
                    }
                }
            } else if (this.itsKernelRule.getRight() == srcObject.getContext()) {
                tarObj = mr.getRight().findGraphObject(((MultiRule)mr.getBasisRule()).getEmbeddingRight().getImage(srcObject.getBasisObject()));
                if (srcObject.isNode()) {
                    bNode = (Node)((MultiRule)mr.getBasisRule()).getEmbeddingRight().getImage(srcObject.getBasisObject());
                    if (bNode != null) {
                        try {
                            ((MultiRule)mr.getBasisRule()).removeEmbeddingRight(srcObject.getBasisObject());
                            srcObject.addContextUsage(String.valueOf(tarObj.hashCode()));
                            mr.getRight().delNode(bNode);
                        }
                        catch (TypeException typeException) {}
                    }
                } else {
                    bArc = (Arc)((MultiRule)mr.getBasisRule()).getEmbeddingRight().getImage(srcObject.getBasisObject());
                    if (bArc != null) {
                        try {
                            ((MultiRule)mr.getBasisRule()).removeEmbeddingRight(srcObject.getBasisObject());
                            srcObject.addContextUsage(String.valueOf(tarObj.hashCode()));
                            mr.getRight().delArc(bArc);
                        }
                        catch (TypeException typeException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void propagateAddMappingToMultiRule(EdGraphObject leftgo, EdGraphObject rightgo) {
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            GraphObject objL = ((MultiRule)multiRule.getBasisRule()).getEmbeddingLeft().getImage(leftgo.getBasisObject());
            GraphObject objR = ((MultiRule)multiRule.getBasisRule()).getEmbeddingRight().getImage(rightgo.getBasisObject());
            if (objL != null && objR != null) {
                EdGraphObject goL = multiRule.getLeft().findGraphObject(objL);
                EdGraphObject goR = multiRule.getRight().findGraphObject(objR);
                if (goL != null && goR != null) {
                    multiRule.interactRule(goL, goR);
                }
            }
            ++i;
        }
    }

    public void propagateRemoveMappingToMultiRule(EdGraphObject go, boolean left) {
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdRule multiRule = this.itsMultiRules.get(i);
            if (left) {
                EdGraphObject goL;
                GraphObject objL = ((MultiRule)multiRule.getBasisRule()).getEmbeddingLeft().getImage(go.getBasisObject());
                if (objL != null && (goL = multiRule.getLeft().findGraphObject(objL)) != null) {
                    EdGraphObject o;
                    EdGraph ac;
                    EdGraphObject goR = multiRule.getRight().findGraphObject(multiRule.getBasisRule().getImage(goL.getBasisObject()));
                    if (goR != null) {
                        multiRule.removeRuleMapping(goL);
                    }
                    int j = 0;
                    while (j < multiRule.getNestedACs().size()) {
                        ac = (EdNestedApplCond)multiRule.getNestedACs().get(j);
                        o = ac.findGraphObject(((EdPAC)ac).getMorphism().getImage(objL));
                        if (o != null) {
                            multiRule.addDeletedACMappingToUndo(go, o);
                            multiRule.removeNestedACMapping(goL, (NestedApplCond)((EdPAC)ac).getMorphism());
                            multiRule.undoManagerEndEdit();
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < multiRule.getNACs().size()) {
                        ac = multiRule.getNACs().get(j);
                        o = ac.findGraphObject(((EdNAC)ac).getMorphism().getImage(objL));
                        if (o != null) {
                            multiRule.addDeletedNACMappingToUndo(go, o);
                            multiRule.removeNACMapping(goL, ((EdNAC)ac).getMorphism());
                            multiRule.undoManagerEndEdit();
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < multiRule.getPACs().size()) {
                        ac = multiRule.getPACs().get(j);
                        o = ac.findGraphObject(((EdPAC)ac).getMorphism().getImage(objL));
                        if (o != null) {
                            multiRule.addDeletedPACMappingToUndo(go, o);
                            multiRule.removePACMapping(goL, ((EdPAC)ac).getMorphism());
                            multiRule.undoManagerEndEdit();
                        }
                        ++j;
                    }
                }
            } else {
                EdGraphObject goR;
                GraphObject objR = ((MultiRule)multiRule.getBasisRule()).getEmbeddingRight().getImage(go.getBasisObject());
                if (objR != null && (goR = multiRule.getRight().findGraphObject(objR)) != null && multiRule.getBasisRule().getInverseImage(goR.getBasisObject()).hasMoreElements()) {
                    GraphObject objL = multiRule.getBasisRule().getInverseImage(goR.getBasisObject()).nextElement();
                    EdGraphObject goL = multiRule.getLeft().findGraphObject(objL);
                    if (goL != null) {
                        multiRule.removeRuleMapping(goL);
                    }
                }
            }
            ++i;
        }
    }

    private void applyLayoutOfKernelRule(EdRule multiRule) {
        Enumeration<GraphObject> embLeft = ((MultiRule)multiRule.getBasisRule()).getEmbeddingLeft().getDomain();
        while (embLeft.hasMoreElements()) {
            GraphObject o = embLeft.nextElement();
            GraphObject o1 = ((MultiRule)multiRule.getBasisRule()).getEmbeddingLeft().getImage(o);
            EdGraphObject go = this.itsKernelRule.getLeft().findGraphObject(o);
            EdGraphObject go1 = multiRule.getLeft().findGraphObject(o1);
            if (go == null || go1 == null || !go.isNode()) continue;
            go1.setXY(go.getX(), go.getY());
        }
        Enumeration<GraphObject> embRight = ((MultiRule)multiRule.getBasisRule()).getEmbeddingRight().getDomain();
        while (embRight.hasMoreElements()) {
            GraphObject o = embRight.nextElement();
            GraphObject o1 = ((MultiRule)multiRule.getBasisRule()).getEmbeddingRight().getImage(o);
            EdGraphObject go = this.itsKernelRule.getRight().findGraphObject(o);
            EdGraphObject go1 = multiRule.getRight().findGraphObject(o1);
            if (go == null || go1 == null || !go.isNode()) continue;
            go1.setXY(go.getX(), go.getY());
        }
    }

    public void removeMultiRule(EdRule r) {
        if (this.itsMultiRules.contains(r)) {
            ((RuleScheme)this.getBasisRule()).removeMultiRule(r.getBasisRule());
            this.itsMultiRules.remove(r);
        }
    }

    public void setAmalgamatedRule(EdRule r) {
        if (this.itsAmalgamatedRule != null) {
            this.itsAmalgamatedRule.dispose();
        }
        this.itsAmalgamatedRule = r;
        this.itsAmalgamatedRule.setGraGra(this.eGra);
        this.setXYLayoutOfAmalgamatedRule(this.itsAmalgamatedRule);
        this.itsAmalgamatedRule.getLeft().setEditable(false);
        this.itsAmalgamatedRule.getRight().setEditable(false);
        this.itsAmalgamatedRule.setEditable(false);
        if (this.itsAmalgamatedRule.getMatch() != null) {
            this.eGra.getBasisGraGra().addMatch(this.itsAmalgamatedRule.getMatch());
        }
    }

    private void makeAmalgamatedRule(AmalgamatedRule rule) {
        this.itsAmalgamatedRule = new EdRule(rule);
        this.itsAmalgamatedRule.setGraGra(this.eGra);
        this.setXYLayoutOfAmalgamatedRule(this.itsAmalgamatedRule);
        this.itsAmalgamatedRule.getLeft().setEditable(false);
        this.itsAmalgamatedRule.getRight().setEditable(false);
        this.itsAmalgamatedRule.setEditable(false);
    }

    public void setLayoutByIndexFrom(EdRuleScheme rs) {
        this.setLayoutByIndexFrom(rs, false);
    }

    public void setLayoutByIndexFrom(EdRuleScheme rs, boolean inverse) {
        EdGraph ac1;
        EdGraph ac;
        if (inverse) {
            this.itsKernelRule.getLeft().setLayoutByIndex(rs.getKernelRule().getRight(), true);
            this.itsKernelRule.getRight().setLayoutByIndex(rs.getKernelRule().getLeft(), true);
        } else {
            this.itsKernelRule.getLeft().setLayoutByIndex(rs.getKernelRule().getLeft(), true);
            this.itsKernelRule.getRight().setLayoutByIndex(rs.getKernelRule().getRight(), true);
        }
        int n = 0;
        while (n < this.itsKernelRule.itsACs.size()) {
            ac = (EdNestedApplCond)this.itsKernelRule.itsACs.get(n);
            if (n < rs.getKernelRule().getNestedACs().size()) {
                ac1 = (EdNestedApplCond)rs.getKernelRule().getNestedACs().get(n);
                ((EdNestedApplCond)ac).setLayoutByIndex(ac1, true);
            }
            ++n;
        }
        n = 0;
        while (n < this.itsKernelRule.getNACs().size()) {
            ac = this.itsKernelRule.getNACs().get(n);
            if (n < rs.getKernelRule().getNACs().size()) {
                ac1 = rs.getKernelRule().getNACs().get(n);
                ac.setLayoutByIndex(ac1, true);
            }
            ++n;
        }
        n = 0;
        while (n < this.itsKernelRule.getPACs().size()) {
            ac = this.itsKernelRule.getPACs().get(n);
            if (n < rs.getKernelRule().getPACs().size()) {
                ac1 = rs.getKernelRule().getPACs().get(n);
                ac.setLayoutByIndex(ac1, true);
            }
            ++n;
        }
        int i = 0;
        while (i < this.itsMultiRules.size()) {
            EdGraph ac12;
            EdGraph ac2;
            EdRule mr = this.itsMultiRules.get(i);
            EdRule r = rs.getMultiRules().get(i);
            if (inverse) {
                mr.getLeft().setLayoutByIndex(r.getRight(), true);
                mr.getRight().setLayoutByIndex(r.getLeft(), true);
            } else {
                mr.getLeft().setLayoutByIndex(r.getLeft(), true);
                mr.getRight().setLayoutByIndex(r.getRight(), true);
            }
            int n2 = 0;
            while (n2 < mr.getNestedACs().size()) {
                ac2 = (EdNestedApplCond)mr.getNestedACs().get(n2);
                if (n2 < r.getNestedACs().size()) {
                    ac12 = (EdNestedApplCond)r.getNestedACs().get(n2);
                    ((EdNestedApplCond)ac2).setLayoutByIndex(ac12, true);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < mr.getNACs().size()) {
                ac2 = mr.getNACs().get(n2);
                if (n2 < r.getNACs().size()) {
                    ac12 = r.getNACs().get(n2);
                    ac2.setLayoutByIndex(ac12, true);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < mr.getPACs().size()) {
                ac2 = mr.getPACs().get(n2);
                if (n2 < r.getPACs().size()) {
                    ac12 = r.getPACs().get(n2);
                    ac2.setLayoutByIndex(ac12, true);
                }
                ++n2;
            }
            ++i;
        }
    }

    private void setXYLayoutOfAmalgamatedRule(EdRule r) {
        if (r.getMatch() != null) {
            int i = 0;
            while (i < r.getLeft().getNodes().size()) {
                EdNode nodeL = r.getLeft().getNodes().get(i);
                Node bnodeL = (Node)r.getMatch().getImage(nodeL.getBasisObject());
                EdNode gnode = this.eGra.getGraph().findNode(bnodeL);
                if (gnode != null) {
                    EdNode nodeR;
                    nodeL.setXY(gnode.getX(), gnode.getY());
                    Node bnodeR = (Node)r.getBasisRule().getImage(nodeL.getBasisObject());
                    if (bnodeR != null && (nodeR = r.getRight().findNode(bnodeR)) != null) {
                        nodeR.setXY(nodeL.getX(), nodeL.getY());
                        nodeR.getLNode().setFrozen(true);
                    }
                }
                ++i;
            }
            r.getRight().layoutBasisGraph(new Dimension(400, 300));
        }
    }

    public void updateMatch(Match m, EdGraph eImageGraph) {
        if (m == null || eImageGraph == null) {
            return;
        }
        eImageGraph.clearMarks();
        Enumeration<GraphObject> domain = m.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = m.getImage(bOrig);
            EdNode enI = eImageGraph.findNode(bImage);
            if (enI != null) {
                if (!enI.isMorphismMarkEmpty()) continue;
                enI.addMorphismMark(enI.getMyKey());
                continue;
            }
            EdArc eaI = eImageGraph.findArc(bImage);
            if (eaI == null || !eaI.isMorphismMarkEmpty()) continue;
            eaI.addMorphismMark(eaI.getMyKey());
        }
    }

    public void removeAmalgamatedRule() {
        if (this.itsAmalgamatedRule != null) {
            if (this.itsAmalgamatedRule.getBasisRule() != null && this.itsAmalgamatedRule.getBasisRule().getMatch() != null) {
                this.itsAmalgamatedRule.getBasisRule().getMatch().clear();
                this.itsAmalgamatedRule.updateMatch();
                this.eGra.getBasisGraGra().destroyMatch(this.itsAmalgamatedRule.getBasisRule().getMatch());
            }
            this.itsAmalgamatedRule.dispose();
            ((RuleScheme)this.bRule).disposeAmalgamatedRule();
            this.itsAmalgamatedRule = null;
        }
    }

    @Override
    public boolean deleteGraphObjectsOfType(EdGraphObject tgo, boolean addToUndo) {
        boolean allDone = true;
        int j = 0;
        while (j < this.itsMultiRules.size()) {
            EdRule r = this.itsMultiRules.get(j);
            if (!this.delObjsOfTypeFromMultiRule(tgo, r, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        allDone = this.delObjsOfTypeFromKernelRule(tgo, addToUndo);
        return allDone;
    }

    private boolean delObjsOfTypeFromMultiRule(EdGraphObject tgo, EdRule r, boolean addToUndo) {
        EdGraphObject rgo;
        EdGraphObject go;
        int i;
        List<EdGraphObject> listLHS = r.eLeft.getGraphObjectsOfType(tgo);
        List<EdGraphObject> listRHS = r.eRight.getGraphObjectsOfType(tgo);
        if (addToUndo) {
            int i2 = 0;
            while (i2 < listLHS.size()) {
                EdGraphObject rgo2;
                EdGraphObject go2 = listLHS.get(i2);
                if (!((MultiRule)r.getBasisRule()).isTargetOfEmbeddingLeft(go2.getBasisObject()) && (rgo2 = r.getRight().findGraphObject(r.getBasisRule().getImage(go2.getBasisObject()))) != null) {
                    r.addDeletedMappingToUndo(go2, rgo2);
                    r.undoManagerEndEdit();
                }
                ++i2;
            }
        }
        boolean allDone = true;
        int j = 0;
        while (j < r.itsNACs.size()) {
            EdNAC nac = r.itsNACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = nac.findGraphObject(nac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        r.addDeletedNACMappingToUndo(go, rgo);
                        r.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!nac.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < r.itsPACs.size()) {
            EdPAC pac = r.itsPACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = pac.findGraphObject(pac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        r.addDeletedPACMappingToUndo(go, rgo);
                        r.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!pac.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < r.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)r.itsACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        r.addDeletedACMappingToUndo(go, rgo);
                        r.undoManagerEndEdit();
                    }
                    ++i;
                }
                ac.storeMappingOfGraphObjectsOfType(tgo, (EdGraph)ac);
            }
            if (!ac.deleteGraphObjectsOfType(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        if (addToUndo) {
            EdGraphObject go3;
            int i3 = 0;
            while (i3 < listLHS.size()) {
                go3 = listLHS.get(i3);
                if (!((MultiRule)r.getBasisRule()).isTargetOfEmbeddingLeft(go3.getBasisObject())) {
                    if (go3.isNode()) {
                        if (!r.eLeft.deleteNode((EdNode)go3, addToUndo)) {
                            allDone = false;
                        }
                    } else if (!r.eLeft.deleteArc((EdArc)go3, addToUndo)) {
                        allDone = false;
                    }
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < listRHS.size()) {
                go3 = listRHS.get(i3);
                if (!((MultiRule)r.getBasisRule()).isTargetOfEmbeddingRight(go3.getBasisObject())) {
                    if (go3.isNode()) {
                        if (!r.eRight.deleteNode((EdNode)go3, addToUndo)) {
                            allDone = false;
                        }
                    } else if (!r.eRight.deleteArc((EdArc)go3, addToUndo)) {
                        allDone = false;
                    }
                }
                ++i3;
            }
        } else {
            if (!r.eLeft.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            if (!r.eRight.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
        }
        return allDone;
    }

    private boolean delObjsOfTypeFromMultiRule(EdType t, EdRule r, boolean addToUndo) {
        EdGraphObject rgo;
        EdGraphObject go;
        int i;
        List<EdGraphObject> listLHS = r.eLeft.getGraphObjectsOfType(t);
        List<EdGraphObject> listRHS = r.eRight.getGraphObjectsOfType(t);
        if (addToUndo) {
            int i2 = 0;
            while (i2 < listLHS.size()) {
                EdGraphObject rgo2;
                EdGraphObject go2 = listLHS.get(i2);
                if (!((MultiRule)r.getBasisRule()).isTargetOfEmbeddingLeft(go2.getBasisObject()) && (rgo2 = r.getRight().findGraphObject(r.getBasisRule().getImage(go2.getBasisObject()))) != null) {
                    r.addDeletedMappingToUndo(go2, rgo2);
                    r.undoManagerEndEdit();
                }
                ++i2;
            }
        }
        boolean allDone = true;
        int j = 0;
        while (j < r.itsNACs.size()) {
            EdNAC nac = r.itsNACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = nac.findGraphObject(nac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        r.addDeletedNACMappingToUndo(go, rgo);
                        r.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!nac.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < r.itsPACs.size()) {
            EdPAC pac = r.itsPACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = pac.findGraphObject(pac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        r.addDeletedPACMappingToUndo(go, rgo);
                        r.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!pac.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < r.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)r.itsACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        r.addDeletedACMappingToUndo(go, rgo);
                        r.undoManagerEndEdit();
                    }
                    ++i;
                }
                ac.storeMappingOfGraphObjectsOfType(t, (EdGraph)ac);
            }
            if (!ac.deleteGraphObjectsOfType(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        if (addToUndo) {
            EdGraphObject go3;
            int i3 = 0;
            while (i3 < listLHS.size()) {
                go3 = listLHS.get(i3);
                if (!((MultiRule)r.getBasisRule()).isTargetOfEmbeddingLeft(go3.getBasisObject())) {
                    if (go3.isNode()) {
                        if (!r.eLeft.deleteNode((EdNode)go3, addToUndo)) {
                            allDone = false;
                        }
                    } else if (!r.eLeft.deleteArc((EdArc)go3, addToUndo)) {
                        allDone = false;
                    }
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < listRHS.size()) {
                go3 = listRHS.get(i3);
                if (!((MultiRule)r.getBasisRule()).isTargetOfEmbeddingRight(go3.getBasisObject())) {
                    if (go3.isNode()) {
                        if (!r.eRight.deleteNode((EdNode)go3, addToUndo)) {
                            allDone = false;
                        }
                    } else if (!r.eRight.deleteArc((EdArc)go3, addToUndo)) {
                        allDone = false;
                    }
                }
                ++i3;
            }
        } else {
            if (!r.eLeft.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            if (!r.eRight.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
        }
        return allDone;
    }

    private boolean delObjsOfTypeFromKernelRule(EdGraphObject tgo, boolean addToUndo) {
        EdGraphObject rgo;
        EdGraphObject go;
        int i;
        List<EdGraphObject> listLHS = this.itsKernelRule.eLeft.getGraphObjectsOfType(tgo);
        List<EdGraphObject> listRHS = this.itsKernelRule.eRight.getGraphObjectsOfType(tgo);
        if (addToUndo) {
            int i2 = 0;
            while (i2 < listLHS.size()) {
                EdGraphObject go2 = listLHS.get(i2);
                EdGraphObject rgo2 = this.itsKernelRule.eRight.findGraphObject(this.itsKernelRule.getBasisRule().getImage(go2.getBasisObject()));
                if (rgo2 != null) {
                    this.propagateRemoveRuleMappingToMultiRule(go2);
                    this.itsKernelRule.addDeletedMappingToUndo(go2, rgo2);
                    this.itsKernelRule.undoManagerEndEdit();
                }
                ++i2;
            }
        }
        boolean allDone = true;
        int j = 0;
        while (j < this.itsKernelRule.itsNACs.size()) {
            EdNAC nac = this.itsKernelRule.itsNACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = nac.findGraphObject(nac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.itsKernelRule.addDeletedNACMappingToUndo(go, rgo);
                        this.itsKernelRule.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!nac.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsKernelRule.itsPACs.size()) {
            EdPAC pac = this.itsKernelRule.itsPACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = pac.findGraphObject(pac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.itsKernelRule.addDeletedPACMappingToUndo(go, rgo);
                        this.itsKernelRule.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!pac.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsKernelRule.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsKernelRule.itsACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < listLHS.size()) {
                    go = listLHS.get(i);
                    rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.itsKernelRule.addDeletedACMappingToUndo(go, rgo);
                        this.itsKernelRule.undoManagerEndEdit();
                    }
                    ++i;
                }
                ac.storeMappingOfGraphObjectsOfType(tgo, (EdGraph)ac);
            }
            if (!ac.deleteGraphObjectsOfType(tgo, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        if (addToUndo) {
            EdGraphObject go3;
            int i3 = 0;
            while (i3 < listLHS.size()) {
                go3 = listLHS.get(i3);
                this.propagateRemoveGraphObjectToMultiRule(go3);
                if (go3.isNode()) {
                    if (!this.itsKernelRule.eLeft.deleteNode((EdNode)go3, addToUndo)) {
                        allDone = false;
                    }
                } else if (!this.itsKernelRule.eLeft.deleteArc((EdArc)go3, addToUndo)) {
                    allDone = false;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < listRHS.size()) {
                go3 = listRHS.get(i3);
                this.propagateRemoveGraphObjectToMultiRule(go3);
                if (go3.isNode()) {
                    if (!this.itsKernelRule.eRight.deleteNode((EdNode)go3, addToUndo)) {
                        allDone = false;
                    }
                } else if (!this.itsKernelRule.eRight.deleteArc((EdArc)go3, addToUndo)) {
                    allDone = false;
                }
                ++i3;
            }
        } else {
            if (!this.itsKernelRule.eLeft.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
            if (!this.itsKernelRule.eRight.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                allDone = false;
            }
        }
        return allDone;
    }

    @Override
    public boolean deleteGraphObjectsOfType(EdType t, boolean addToUndo) {
        boolean allDone = true;
        int j = 0;
        while (j < this.itsMultiRules.size()) {
            EdRule r = this.itsMultiRules.get(j);
            if (!this.delObjsOfTypeFromMultiRule(t, r, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        allDone = this.delObjsOfTypeFromKernelRule(t, addToUndo);
        return allDone;
    }

    private boolean delObjsOfTypeFromKernelRule(EdType t, boolean addToUndo) {
        EdGraphObject rgo;
        EdGraphObject go;
        int i;
        List<EdGraphObject> list = this.itsKernelRule.eLeft.getGraphObjectsOfType(t);
        if (addToUndo) {
            int i2 = 0;
            while (i2 < list.size()) {
                EdGraphObject go2 = list.get(i2);
                EdGraphObject rgo2 = this.eRight.findGraphObject(this.getBasisRule().getImage(go2.getBasisObject()));
                if (rgo2 != null) {
                    this.propagateRemoveRuleMappingToMultiRule(go2);
                    this.itsKernelRule.addDeletedMappingToUndo(go2, rgo2);
                    this.itsKernelRule.undoManagerEndEdit();
                }
                ++i2;
            }
        }
        boolean allDone = true;
        int j = 0;
        while (j < this.itsKernelRule.itsNACs.size()) {
            EdNAC nac = this.itsKernelRule.itsNACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < list.size()) {
                    go = list.get(i);
                    rgo = nac.findGraphObject(nac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.itsKernelRule.addDeletedNACMappingToUndo(go, rgo);
                        this.itsKernelRule.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!nac.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsKernelRule.itsPACs.size()) {
            EdPAC pac = this.itsKernelRule.itsPACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < list.size()) {
                    go = list.get(i);
                    rgo = pac.findGraphObject(pac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.itsKernelRule.addDeletedPACMappingToUndo(go, rgo);
                        this.itsKernelRule.undoManagerEndEdit();
                    }
                    ++i;
                }
            }
            if (!pac.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        j = 0;
        while (j < this.itsKernelRule.itsACs.size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.itsKernelRule.itsACs.get(j);
            if (addToUndo) {
                i = 0;
                while (i < list.size()) {
                    go = list.get(i);
                    rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                    if (rgo != null) {
                        this.itsKernelRule.addDeletedACMappingToUndo(go, rgo);
                        this.itsKernelRule.undoManagerEndEdit();
                    }
                    ++i;
                }
                ac.storeMappingOfGraphObjectsOfType(t, (EdGraph)ac);
            }
            if (!ac.deleteGraphObjectsOfType(t, addToUndo)) {
                allDone = false;
            }
            ++j;
        }
        if (!this.itsKernelRule.eLeft.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            allDone = false;
        }
        if (!this.itsKernelRule.eRight.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            allDone = false;
        }
        return allDone;
    }

    @Override
    public void XreadObject(XMLHelper h) {
        h.enrichObject(this.itsKernelRule);
        this.itsKernelRule.setGraGra(this.eGra);
        int j = 0;
        while (j < this.itsMultiRules.size()) {
            EdRule r = this.itsMultiRules.get(j);
            h.enrichObject(r);
            r.setGraGra(this.eGra);
            this.enrichContextUsageOfEmbedTarget(r);
            ++j;
        }
        if (this.itsAmalgamatedRule != null) {
            h.enrichObject(this.itsAmalgamatedRule);
            this.itsAmalgamatedRule.setGraGra(this.eGra);
        }
    }

    private void enrichContextUsageOfEmbedTarget(EdRule mr) {
        EdGraphObject kerngo;
        GraphObject kern;
        EdNode n;
        Vector<EdNode> nodes = mr.getLeft().getNodes();
        int i = 0;
        while (i < nodes.size()) {
            n = (EdNode)nodes.get(i);
            if (((MultiRule)mr.getBasisRule()).isTargetOfEmbeddingLeft(n.getBasisObject())) {
                kern = ((MultiRule)mr.getBasisRule()).getEmbeddingLeft().getInverseImage(n.getBasisObject()).nextElement();
                kerngo = this.itsKernelRule.getLeft().findGraphObject(kern);
                if (kerngo != null) {
                    n.addContextUsage(String.valueOf(kerngo.hashCode()));
                }
            }
            ++i;
        }
        nodes = mr.getRight().getNodes();
        i = 0;
        while (i < nodes.size()) {
            n = (EdNode)nodes.get(i);
            if (((MultiRule)mr.getBasisRule()).isTargetOfEmbeddingRight(n.getBasisObject())) {
                kern = ((MultiRule)mr.getBasisRule()).getEmbeddingRight().getInverseImage(n.getBasisObject()).nextElement();
                kerngo = this.itsKernelRule.getRight().findGraphObject(kern);
                if (kerngo != null) {
                    n.addContextUsage(String.valueOf(kerngo.hashCode()));
                }
            }
            ++i;
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.addObject("", this.itsKernelRule, true);
        int j = 0;
        while (j < this.itsMultiRules.size()) {
            h.addObject("", this.itsMultiRules.get(j), true);
            ++j;
        }
        if (this.itsAmalgamatedRule != null) {
            h.addObject("", this.itsAmalgamatedRule, true);
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        super.restoreState(state);
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        super.restoreState(state);
    }
}

