/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.refactoring.popup.actions;

import mergeSuggestion.MergeRule;
import mergeSuggestion.MergeSuggestion;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.MergeInException;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.NewMerger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MergeAction
implements IObjectActionDelegate {
    private Shell shell;
    private MergeSuggestion mergeSuggestion;
    private MergeRule mergeRule;
    private static final String HEADER = "MergeIn refactoring";

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.mergeRule = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof MergeRule) {
            this.mergeRule = (MergeRule)structuredSelection.getFirstElement();
        }
    }

    public void run(IAction action) {
        try {
            NewMerger merger = null;
            if (this.mergeSuggestion != null) {
                for (MergeRule mergeRule : this.mergeSuggestion.getMergeClusters()) {
                    merger = new NewMerger(mergeRule, true);
                    merger.merge();
                }
            } else if (this.mergeRule != null) {
                merger = new NewMerger(this.mergeRule, true);
                merger.merge();
            }
        }
        catch (MergeInException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.shell, (String)HEADER, (String)e.getMessage());
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void setMergeSuggestion(MergeSuggestion mergeSuggestion) {
        this.mergeSuggestion = mergeSuggestion;
    }
}

