/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.movies;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.PartitionedEGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class MoviesBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/movies";

    public static void runSyntheticDataTest(String modelPath, int factor, int numPartitions) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(modelPath);
        Module module = resourceSet.getModule("movies.henshin", false);
        Unit createExampleUnit = module.getUnit("createExample");
        Unit findCouplesUnit = module.getUnit("findCouples");
        Engine engine = MoviesBenchmark.createEngine(numPartitions);
        System.out.println("Nodes\tCouples\tTime (ms)");
        int i = 1;
        while (i <= 5) {
            int n = (i + 5) * factor;
            EGraph graph = MoviesBenchmark.createEGraph(numPartitions, null);
            UnitApplicationImpl createExample = new UnitApplicationImpl(engine, graph, createExampleUnit, null);
            createExample.setParameterValue("n", (Object)n);
            InterpreterUtil.executeOrDie((UnitApplication)createExample);
            int inputSize = graph.size();
            long millis = System.currentTimeMillis();
            UnitApplicationImpl findCouples = new UnitApplicationImpl(engine, graph, findCouplesUnit, null);
            InterpreterUtil.executeOrDie((UnitApplication)findCouples);
            millis = System.currentTimeMillis() - millis;
            EClass coupleClass = (EClass)((EPackage)module.getImports().get(0)).getEClassifier("Couple");
            int foundCouples = graph.getDomainSize(coupleClass, true);
            int expected = 2 * n;
            if (foundCouples != expected) {
                throw new AssertionError((Object)("Expected to find " + expected + " couples, but actually found " + foundCouples));
            }
            System.out.println(String.valueOf(inputSize) + "\t" + n + "\t" + millis);
            ++i;
        }
        engine.shutdown();
        engine = null;
        System.gc();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void runRealDataTest(String modelPath, String moviesPath, String fileExtension, int numPartitions) {
        Engine engine = MoviesBenchmark.createEngine(numPartitions);
        System.out.println("Nodes\tCouples\tTime (ms)");
        File[] fileArray = new File(moviesPath).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("." + fileExtension)) {
                HenshinResourceSet resourceSet = new HenshinResourceSet(modelPath);
                Module module = resourceSet.getModule("movies.henshin", false);
                Unit findCouplesUnit = module.getUnit("findCouples");
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
                resourceSet.getPackageRegistry().put((Object)((EPackage)module.getImports().get(0)).getNsURI(), module.getImports().get(0));
                System.gc();
                Resource movies = resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
                EGraph graph = MoviesBenchmark.createEGraph(numPartitions, movies);
                System.out.print(graph.size());
                long millis = System.currentTimeMillis();
                UnitApplicationImpl findCouples = new UnitApplicationImpl(engine, graph, findCouplesUnit, null);
                InterpreterUtil.executeOrDie((UnitApplication)findCouples);
                millis = System.currentTimeMillis() - millis;
                EClass coupleClass = (EClass)((EPackage)module.getImports().get(0)).getEClassifier("Couple");
                int foundCouples = graph.getDomainSize(coupleClass, true);
                System.out.println("\t" + foundCouples / 2 + "\t" + millis);
            }
            ++n2;
        }
        engine.shutdown();
        engine = null;
        System.gc();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static Engine createEngine(int numPartitions) {
        EngineImpl engine = new EngineImpl(new String[0]);
        if (numPartitions > 1) {
            engine.getOptions().put("WORKER_THREADS", numPartitions);
        }
        return engine;
    }

    private static EGraph createEGraph(int numPartitions, Resource resource) {
        if (resource != null) {
            return numPartitions > 1 ? new PartitionedEGraphImpl(resource, numPartitions) : new EGraphImpl(resource);
        }
        return numPartitions > 1 ? new PartitionedEGraphImpl(numPartitions) : new EGraphImpl();
    }

    public static void main(String[] args) {
        int p = 12;
        while (p >= 0) {
            System.out.println("\n*** REAL DATA BENCHMARK WITH " + p + " PARTITIONS ***\n");
            MoviesBenchmark.runRealDataTest(PATH, String.valueOf(System.getProperty("user.home")) + File.separator + "movies", "movies", p);
            p -= 2;
        }
    }
}

