/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.staticanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.staticanalysis.Path;

public class PathFinder {
    public static Map<List<EReference>, Integer> findReferencePaths(Node source, Node target, boolean withPACs, boolean onlyPACs) {
        LinkedHashMap<List<EReference>, Integer> reflists = new LinkedHashMap<List<EReference>, Integer>();
        for (Path path : PathFinder.findEdgePaths(source, target, true, withPACs)) {
            List<EReference> list;
            if (onlyPACs && !path.isViaNestedCondition() || (list = path.toReferenceList(true)) == null) continue;
            Integer count = (Integer)reflists.get(list);
            if (count != null) {
                reflists.put(list, count + 1);
                continue;
            }
            reflists.put(list, 1);
        }
        return reflists;
    }

    public static List<Path> findEdgePaths(Node source, Node target, boolean withInverse, boolean withPACs) {
        Graph graph = source.getGraph();
        Path initial = new Path();
        initial.nodes.add(source);
        ArrayList<Path> tempPaths = new ArrayList<Path>();
        tempPaths.add(initial);
        ArrayList<Path> finalPaths = new ArrayList<Path>();
        while (!tempPaths.isEmpty()) {
            ArrayList<Path> newTempPaths = new ArrayList<Path>();
            for (Path path : tempPaths) {
                Node last = path.lastNode();
                List<Path> steps = PathFinder.doStep(last, withInverse);
                if (withPACs) {
                    for (NestedCondition pac : graph.getPACs()) {
                        Node image = pac.getMappings().getImage(last, pac.getConclusion());
                        if (image == null) continue;
                        steps.addAll(PathFinder.doStep(image, withInverse));
                    }
                }
                for (Path step : steps) {
                    step.retract();
                    Path extended = path.copy();
                    extended.append(step);
                    if (extended.isCyclic()) continue;
                    if (extended.lastNode() == target) {
                        finalPaths.add(extended);
                        continue;
                    }
                    newTempPaths.add(extended);
                }
            }
            tempPaths = newTempPaths;
        }
        return finalPaths;
    }

    private static List<Path> doStep(Node node, boolean withInverse) {
        Path path;
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Edge outgoing : node.getOutgoing()) {
            path = new Path();
            path.nodes.add(node);
            path.edges.add(outgoing);
            path.nodes.add(outgoing.getTarget());
            paths.add(path);
        }
        if (withInverse) {
            for (Edge incoming : node.getIncoming()) {
                path = new Path();
                path.nodes.add(node);
                path.edges.add(incoming);
                path.nodes.add(incoming.getSource());
                paths.add(path);
            }
        }
        return paths;
    }

    public static List<Path> findAllPaths(Graph graph, boolean withPACs) {
        ArrayList<Path> paths = new ArrayList<Path>();
        int i = 0;
        while (i < graph.getNodes().size()) {
            int j = 0;
            while (j < graph.getNodes().size()) {
                paths.addAll(PathFinder.findEdgePaths((Node)graph.getNodes().get(i), (Node)graph.getNodes().get(j), true, withPACs));
                ++j;
            }
            ++i;
        }
        return paths;
    }

    public static boolean pacConsistsOnlyOfPaths(NestedCondition pac) {
        if (!pac.isPAC()) {
            return false;
        }
        HashSet<Node> reachedPACNodes = new HashSet<Node>();
        HashSet<ModelElement> reachedPACEdges = new HashSet<ModelElement>();
        for (Path path : PathFinder.findAllPaths(pac.getHost(), true)) {
            ModelElement image;
            if (path.toReferenceList(true) == null) continue;
            for (Node node : path.nodes) {
                if (node.getGraph() == pac.getConclusion()) {
                    reachedPACNodes.add(node);
                    continue;
                }
                image = pac.getMappings().getImage(node, pac.getConclusion());
                if (image == null) continue;
                reachedPACNodes.add((Node)image);
            }
            for (Edge edge : path.edges) {
                if (edge.getGraph() == pac.getConclusion()) {
                    reachedPACEdges.add(edge);
                    continue;
                }
                image = pac.getMappings().getImage(edge, pac.getConclusion());
                if (image == null) continue;
                reachedPACEdges.add(image);
            }
        }
        if (!reachedPACNodes.containsAll((Collection<?>)pac.getConclusion().getNodes())) {
            return false;
        }
        if (!reachedPACEdges.containsAll((Collection<?>)pac.getConclusion().getEdges())) {
            return false;
        }
        for (Node node : reachedPACNodes) {
            if (node.getAttributes().isEmpty()) continue;
            return false;
        }
        for (Node node : reachedPACNodes) {
            Node origin = pac.getMappings().getOrigin(node);
            if (origin == null || origin.getType() == node.getType()) continue;
            return false;
        }
        return true;
    }
}

