/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;

public class CopySubGraphToNestedConditionsCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected Collection<Node> nodes;
    protected Collection<Edge> edges = new ArrayList<Edge>();
    protected NestedCondition condition;
    protected Graph conclusionGraph;
    protected EObject previousFormula;
    protected EObject owner;
    protected EStructuralFeature feature;

    public CopySubGraphToNestedConditionsCommand(EditingDomain domain, Collection<Node> nodes, EObject owner, EStructuralFeature feature) {
        this.domain = domain;
        this.nodes = nodes;
        this.owner = owner;
        this.feature = feature;
    }

    public CopySubGraphToNestedConditionsCommand(EditingDomain domain, Collection<Node> nodes) {
        this.domain = domain;
        this.nodes = nodes;
    }

    public void setOwner(EObject owner) {
        this.owner = owner;
    }

    public void setFeature(EStructuralFeature feature) {
        this.feature = feature;
    }

    protected boolean prepare() {
        if (this.nodes.isEmpty()) {
            return false;
        }
        Graph graph = null;
        for (Node node : this.nodes) {
            if (graph == null) {
                graph = node.getGraph();
            }
            if (node.getGraph() == graph) continue;
            return false;
        }
        if (this.owner == null) {
            this.owner = graph;
            this.feature = HenshinPackage.Literals.GRAPH__FORMULA;
        }
        for (Edge edge : graph.getEdges()) {
            if (!this.nodes.contains(edge.getSource()) || !this.nodes.contains(edge.getTarget())) continue;
            this.edges.add(edge);
        }
        return true;
    }

    public void execute() {
        HenshinFactory factory = HenshinFactory.eINSTANCE;
        ArrayList<Object> subGraphElements = new ArrayList<Object>();
        subGraphElements.addAll(this.nodes);
        subGraphElements.addAll(this.edges);
        Command copyCmd = CopyCommand.create((EditingDomain)this.domain, subGraphElements);
        this.appendAndExecute(copyCmd);
        this.condition = factory.createNestedCondition();
        this.conclusionGraph = factory.createGraph();
        this.condition.setConclusion(this.conclusionGraph);
        Iterator originalElementsIterator = subGraphElements.iterator();
        Iterator copiedElementsIterator = copyCmd.getResult().iterator();
        EList conclusionNodeList = this.conclusionGraph.getNodes();
        EList conclusionEdgeList = this.conclusionGraph.getEdges();
        MappingList conditionMappingList = this.condition.getMappings();
        while (originalElementsIterator.hasNext() && copiedElementsIterator.hasNext()) {
            Object originalObject = originalElementsIterator.next();
            Object copiedObject = copiedElementsIterator.next();
            if (copiedObject instanceof Node) {
                conclusionNodeList.add((Node)copiedObject);
                conditionMappingList.add(factory.createMapping((Node)originalObject, (Node)copiedObject));
            }
            if (!(copiedObject instanceof Edge)) continue;
            conclusionEdgeList.add((Edge)copiedObject);
        }
        this.redo();
    }

    public void redo() {
        this.previousFormula = (Formula)this.owner.eGet(this.feature);
        this.owner.eSet(this.feature, (Object)this.condition);
    }

    public void undo() {
        this.owner.eSet(this.feature, (Object)this.previousFormula);
    }

    public boolean canUndo() {
        return true;
    }

    public Collection<?> getAffectedObjects() {
        return Collections.singleton(this.condition);
    }
}

