/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.util.Set;
import junit.framework.TestCase;
import ordersystem.Account;
import ordersystem.Address;
import ordersystem.OrderSystemFactory;
import ordersystem.OrderSystemPackage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.modeled.model.validation.ValidationPackage;
import org.eclipse.emf.validation.internal.standalone.ValidationTestsPlugin;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ModeledConstraintsLoader;

public class ModeledConstraintsTest
extends TestCase {
    private static boolean setup = false;

    protected void setUp() throws Exception {
        super.setUp();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING && !setup) {
            setup = true;
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2009/Validation", (Object)ValidationPackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)"http:///ordersystem.ecore", (Object)OrderSystemPackage.eINSTANCE);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            ModeledConstraintsLoader.getInstance().loadConstraintBundles(null, URI.createURI((String)((Object)((Object)this)).getClass().getClassLoader().getResource("order.validation").toString()), null, (ResourceLocator)ValidationTestsPlugin.INSTANCE);
        }
    }

    public void testCategory() {
        ModeledConstraintsTest.assertNotNull((Object)CategoryManager.getInstance().findCategory("modeled.test"));
        ModeledConstraintsTest.assertNotNull((Object)CategoryManager.getInstance().findCategory("modeled.test/modeled.test.sub"));
    }

    public void testConstraintDescriptor() {
        Category cat = CategoryManager.getInstance().findCategory("modeled.test");
        ModeledConstraintsTest.assertNotNull((Object)cat);
        Set constraints = cat.getConstraints();
        ModeledConstraintsTest.assertEquals((int)5, (int)constraints.size());
    }

    public void testValidation() {
        Account acc = OrderSystemFactory.eINSTANCE.createAccount();
        acc.setAccountNumber("12345A");
        IValidator val = ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        IStatus result = val.validate((Object)acc);
        ModeledConstraintsTest.assertFalse((boolean)result.isOK());
    }

    public void testIrrelevantTarget() {
        Address add = OrderSystemFactory.eINSTANCE.createAddress();
        IValidator val = ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        IStatus result = val.validate((Object)add);
        ModeledConstraintsTest.assertTrue((boolean)result.isOK());
    }

    public void testInternationalization() {
        Category cat = CategoryManager.getInstance().findCategory("modeled.test");
        ModeledConstraintsTest.assertNotNull((Object)cat);
        Set constraints = cat.getConstraints();
        for (IConstraintDescriptor desc : constraints) {
            String id = XmlConstraintDescriptor.normalizedId((String)"org.eclipse.emf.validation.tests", (String)"modeled4");
            if (!id.equals(desc.getId())) continue;
            ModeledConstraintsTest.assertEquals((String)"Constraint failed", (String)desc.getMessagePattern());
            ModeledConstraintsTest.assertEquals((String)"Test constraint for modeled i18n", (String)desc.getName());
            ModeledConstraintsTest.assertEquals((String)"Tests message bundles for constraints", (String)desc.getDescription());
        }
    }

    public static class AccountClientSelector
    implements IClientSelector {
        public boolean selects(Object object) {
            return object instanceof Account;
        }
    }

    public static class AccountNumberTestConstraint
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            Account act = (Account)ctx.getTarget();
            if ("12345C".equals(act.getAccountNumber())) {
                return Status.OK_STATUS;
            }
            Status fail = new Status(4, "org.eclipse.emf.validation.tests", "failed");
            return fail;
        }
    }
}

