/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import ordersystem.OrderSystemFactory;
import ordersystem.Product;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.service.BatchValidator;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.service.IProviderOperationExecutor;
import org.eclipse.emf.validation.model.EvaluationMode;

public class BatchValidatorTest
extends TestCase {
    private BatchValidator validator;

    public BatchValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new BatchValidator((IProviderOperationExecutor)new TestExecutor());
    }

    private BatchValidator getValidator() {
        return this.validator;
    }

    public void test_getEvaluationMode() {
        BatchValidatorTest.assertSame((String)"Wrong evaluation mode", (Object)EvaluationMode.BATCH, (Object)this.validator.getEvaluationMode());
    }

    public void test_isReportSuccesses() {
        this.getValidator().setReportSuccesses(true);
        BatchValidatorTest.assertTrue((String)"Not reporting successes", (boolean)this.getValidator().isReportSuccesses());
        this.getValidator().setReportSuccesses(false);
        BatchValidatorTest.assertFalse((String)"Should not report successes", (boolean)this.getValidator().isReportSuccesses());
    }

    public void test_validate_object() {
        Product target = OrderSystemFactory.eINSTANCE.createProduct();
        try {
            this.getValidator().validate((Object)target);
        }
        catch (Exception exception) {
            BatchValidatorTest.fail((String)"Should not throw.");
        }
    }

    public void test_validateCollection() {
        Product target = OrderSystemFactory.eINSTANCE.createProduct();
        try {
            this.getValidator().validate(Collections.singleton(target));
            this.getValidator().validate(Collections.emptySet());
        }
        catch (Exception exception) {
            BatchValidatorTest.fail((String)"Should not throw.");
        }
    }

    public void test_isIncludeLiveConstraints() {
        this.getValidator().setIncludeLiveConstraints(true);
        BatchValidatorTest.assertTrue((String)"Not including live constraints", (boolean)this.getValidator().isIncludeLiveConstraints());
        this.getValidator().setIncludeLiveConstraints(false);
        BatchValidatorTest.assertFalse((String)"Should not include live constraints", (boolean)this.getValidator().isIncludeLiveConstraints());
    }

    public void test_validate_EObject_IProgressMonitor() {
        TestMonitor monitor = new TestMonitor();
        Product target = OrderSystemFactory.eINSTANCE.createProduct();
        try {
            this.getValidator().validate((EObject)target, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            BatchValidatorTest.fail((String)"Should not throw.");
        }
        BatchValidatorTest.assertTrue((String)"Monitor not done", (boolean)monitor.isDone());
        BatchValidatorTest.assertTrue((String)"Monitor has zero total work", (monitor.getTotalWork() > 0 ? 1 : 0) != 0);
        BatchValidatorTest.assertTrue((String)"Monitor did no work", (monitor.getWorked() > 0.0 ? 1 : 0) != 0);
        BatchValidatorTest.assertEquals((String)"Monitor did not work total", (double)monitor.getTotalWork(), (double)monitor.getWorked(), (double)0.1);
    }

    public void test_validate_Collection_IProgressMonitor() {
        TestMonitor monitor = new TestMonitor();
        ArrayList<Product> targets = new ArrayList<Product>();
        targets.add(OrderSystemFactory.eINSTANCE.createProduct());
        targets.add(OrderSystemFactory.eINSTANCE.createProduct());
        try {
            this.getValidator().validate(targets, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            BatchValidatorTest.fail((String)"Should not throw.");
        }
        BatchValidatorTest.assertTrue((String)"Monitor not done", (boolean)monitor.isDone());
        BatchValidatorTest.assertTrue((String)"Monitor has zero total work", (monitor.getTotalWork() > 0 ? 1 : 0) != 0);
        BatchValidatorTest.assertTrue((String)"Monitor did no work", (monitor.getWorked() > 0.0 ? 1 : 0) != 0);
        BatchValidatorTest.assertEquals((String)"Monitor did not work total", (double)monitor.getTotalWork(), (double)monitor.getWorked(), (double)0.1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestExecutor
    implements IProviderOperationExecutor {
        TestExecutor() {
        }

        public <T> T execute(IProviderOperation<? extends T> op) {
            return (T)op.getConstraints();
        }
    }

    static class TestMonitor
    implements IProgressMonitor {
        private int totalWork;
        private double worked;
        private boolean done;

        TestMonitor() {
        }

        public void beginTask(String name, int totalTaskWork) {
            this.totalWork = totalTaskWork;
        }

        int getTotalWork() {
            return this.totalWork;
        }

        public void done() {
            this.done = true;
        }

        boolean isDone() {
            return this.done;
        }

        public void internalWorked(double work) {
            this.worked += work;
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        double getWorked() {
            return this.worked;
        }
    }
}

