/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.xml.tests;

import java.util.HashSet;
import java.util.List;
import ordersystem.OrderSystemFactory;
import ordersystem.Product;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.emf.validation.tests.TestNotification;
import org.eclipse.emf.validation.tests.TestPlugin;
import org.eclipse.emf.validation.xml.XmlConstraintProvider;

public class XmlConstraintProviderTest
extends TestBase {
    private static Fixture fixture;

    static {
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Flat());
        validator.validate((EObject)OrderSystemFactory.eINSTANCE.createInventoryItem());
    }

    public XmlConstraintProviderTest(String name) {
        super(name);
    }

    public void test_setInitializationData() {
        XmlConstraintProviderTest.assertTrue((boolean)fixture.wasInitializationDataSet());
    }

    public void test_getConstraints() {
        List<IModelConstraint> result = fixture.getConstraints();
        this.assertAllConstraintsPresent("various", result, "org.eclipse.emf.validation.tests.product.batch1", "org.eclipse.emf.validation.tests.product.batch2", "org.eclipse.emf.validation.tests.product.live1", "org.eclipse.emf.validation.tests.product.live2");
        for (IModelConstraint next : result) {
            XmlConstraintProviderTest.assertTrue((boolean)next.getClass().getName().endsWith("$ConstraintProxy"));
        }
    }

    public void test_getBatchConstraints() {
        Product object = OrderSystemFactory.eINSTANCE.createProduct();
        HashSet<IModelConstraint> result = new HashSet<IModelConstraint>();
        fixture.getBatchConstraints(object, result);
        this.assertAllConstraintsPresent("batch", result, "org.eclipse.emf.validation.tests.product.batch1", "org.eclipse.emf.validation.tests.product.batch2");
    }

    public void test_getLiveConstraints() {
        Product object = OrderSystemFactory.eINSTANCE.createProduct();
        HashSet<IModelConstraint> result = new HashSet<IModelConstraint>();
        fixture.getLiveConstraints((Notification)new TestNotification(object, 1), result);
        this.assertAllConstraintsPresent("live", result, "org.eclipse.emf.validation.tests.product.live1");
        this.assertAllConstraintsNotPresent("live", result, "org.eclipse.emf.validation.tests.product.live2");
    }

    public void test_getLiveConstraintsForFeature() {
        Product object = OrderSystemFactory.eINSTANCE.createProduct();
        HashSet<IModelConstraint> result = new HashSet<IModelConstraint>();
        fixture.getLiveConstraints((Notification)new TestNotification(object, 1, 1, null, "12345"), result);
        this.assertAllConstraintsPresent("live", result, "org.eclipse.emf.validation.tests.product.live1", "org.eclipse.emf.validation.tests.product.live2");
    }

    public void test_duplicateConstraintsLogged_207988() {
        List<IStatus> statuses = TestPlugin.getLogCapture().getLogs(63);
        XmlConstraintProviderTest.assertFalse((String)"Duplicate constraint not logged", (boolean)statuses.isEmpty());
    }

    public void test_getConstraintDisabledByDefault() {
        IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests.defaultTestNotActiveConstraint");
        XmlConstraintProviderTest.assertNotNull((Object)desc);
        XmlConstraintProviderTest.assertFalse((boolean)desc.isEnabled());
        desc = ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests.defaultTestActiveConstraint");
        XmlConstraintProviderTest.assertNotNull((Object)desc);
        XmlConstraintProviderTest.assertTrue((boolean)desc.isEnabled());
        desc = ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests.defaultTestConstraintWithoutDefaultEnablementInformation");
        XmlConstraintProviderTest.assertNotNull((Object)desc);
        XmlConstraintProviderTest.assertTrue((boolean)desc.isEnabled());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Fixture
    extends XmlConstraintProvider {
        private boolean initializationDataWasSet = false;

        public Fixture() {
            XmlConstraintProviderTest.fixture = this;
        }

        protected List<IModelConstraint> getConstraints() {
            return super.getConstraints();
        }

        public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
            super.setInitializationData(config, propertyName, data);
            this.initializationDataWasSet = true;
        }

        boolean wasInitializationDataSet() {
            return this.initializationDataWasSet;
        }
    }
}

