/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om.monitor;

import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.om.monitor.MON;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.MonitorNotBegunException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.OMSubMonitor;
import org.eclipse.net4j.util.om.monitor.TotalWorkExceededException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class Monitor
implements OMMonitor,
OMSubMonitor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, Monitor.class);
    private static final int UNINITIALIZED = 0;
    private Monitor parent;
    private int workFromParent;
    private int totalWork = 0;
    private int work;
    private String task;
    private Monitor child;
    private boolean canceled;

    public Monitor(Monitor parent, int workFromParent) {
        this.parent = parent;
        this.workFromParent = workFromParent;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void checkCanceled() throws MonitorCanceledException {
        if (this.canceled) {
            throw new MonitorCanceledException();
        }
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
        this.taskChanged(task, 0);
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public boolean hasBegun() {
        return this.totalWork != 0;
    }

    public void message(String msg) {
        if (msg != null) {
            this.message(msg, 0);
        }
    }

    public void worked(int work, String msg) throws MonitorCanceledException {
        MON.checkMonitor(this);
        this.checkWork(work);
        this.work += work;
        this.message(msg);
    }

    public void worked(int work) throws MonitorCanceledException {
        this.worked(work, null);
    }

    public void worked(String msg) throws MonitorCanceledException {
        this.worked(1, msg);
    }

    public void worked() throws MonitorCanceledException {
        this.worked(1, null);
    }

    public void fork(int workFromParent, Runnable runnable, String msg) throws MonitorCanceledException {
        MON.checkMonitor(this);
        this.checkWork(workFromParent);
        this.child = this.subMonitor(workFromParent);
        MON.setMonitor(this.child);
        try {
            runnable.run();
        }
        finally {
            MON.checkMonitor(this.child);
            MON.setMonitor(this);
            this.child.done();
            this.child = null;
        }
        this.work += workFromParent;
        this.message(msg);
    }

    public void fork(int workFromParent, Runnable runnable) throws MonitorCanceledException {
        this.fork(workFromParent, runnable, null);
    }

    public void fork(Runnable runnable, String msg) throws MonitorCanceledException {
        this.fork(1, runnable, msg);
    }

    public void fork(Runnable runnable) throws MonitorCanceledException {
        this.fork(1, runnable, null);
    }

    public OMSubMonitor fork(int workFromParent) throws MonitorCanceledException {
        MON.checkMonitor(this);
        this.checkWork(workFromParent);
        this.child = this.subMonitor(workFromParent);
        MON.setMonitor(this.child);
        return this.child;
    }

    public OMSubMonitor fork() throws MonitorCanceledException {
        return this.fork(1);
    }

    public void join(String msg) throws MonitorCanceledException {
        MON.checkMonitor(this);
        MON.setMonitor(this.parent);
        this.parent.setChild(null);
        this.parent.message(msg);
        this.done();
    }

    public void join() throws MonitorCanceledException {
        this.join(null);
    }

    protected Monitor getChild() {
        return this.child;
    }

    protected void setChild(Monitor child) {
        this.child = child;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.child != null) {
            this.child.setCanceled(canceled);
        }
    }

    protected Monitor getParent() {
        return this.parent;
    }

    protected int getWorkFromParent() {
        return this.workFromParent;
    }

    protected String dump() {
        StringBuilder builder = new StringBuilder();
        this.dump(builder);
        return builder.toString();
    }

    protected void begin(int totalWork, String task) throws MonitorCanceledException {
        this.checkCanceled();
        this.totalWork = totalWork;
        if (task != null) {
            this.setTask(task);
        }
    }

    protected void done() {
    }

    protected void taskChanged(String task, int level) {
        if (this.parent != null) {
            this.parent.taskChanged(task, level + 1);
        } else {
            this.trace(task, level, true);
        }
    }

    protected void message(String msg, int level) {
        if (this.parent != null) {
            this.parent.message(msg, level + 1);
        } else {
            this.trace(msg, level, false);
        }
    }

    protected void trace(String msg, int level, boolean isTask) {
        if (TRACER.isEnabled()) {
            TRACER.trace(msg);
        }
    }

    protected void checkWork(int work) {
        if (!this.hasBegun()) {
            throw new MonitorNotBegunException("Monitor has not begun");
        }
        if (this.totalWork != -1 && this.work + work > this.totalWork) {
            throw new TotalWorkExceededException("Work of " + work + " exceeded total work of " + this.totalWork);
        }
    }

    protected void dump(StringBuilder builder) {
        builder.append("  ");
        builder.append(this.task);
        builder.append("\n");
        if (this.parent != null) {
            this.parent.dump(builder);
        }
    }

    protected abstract Monitor subMonitor(int var1);
}

