/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.http.common.IHTTPConnector;
import org.eclipse.net4j.http.internal.server.HTTPAcceptor;
import org.eclipse.net4j.http.internal.server.HTTPServerConnector;
import org.eclipse.net4j.http.internal.server.bundle.OM;
import org.eclipse.net4j.http.server.INet4jTransportServlet;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class Net4jTransportServlet
extends HttpServlet
implements INet4jTransportServlet {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, Net4jTransportServlet.class);
    private static final long serialVersionUID = 1L;
    private INet4jTransportServlet.RequestHandler requestHandler;

    public Net4jTransportServlet() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating " + this.getClass().getName());
        }
    }

    public INet4jTransportServlet.RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(INet4jTransportServlet.RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    protected void doRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.requestHandler == null) {
            throw new ServletException("No request handler installed");
        }
        String connectorID = req.getParameter("list");
        if (connectorID != null) {
            this.doList(connectorID, resp);
            return;
        }
        ServletInputStream servletInputStream = req.getInputStream();
        ExtendedDataInputStream in = new ExtendedDataInputStream((InputStream)servletInputStream);
        ServletOutputStream servletOutputStream = resp.getOutputStream();
        ExtendedDataOutputStream out = new ExtendedDataOutputStream((OutputStream)servletOutputStream);
        int opcode = servletInputStream.read();
        switch (opcode) {
            case 1: {
                this.doConnect(in, out);
                break;
            }
            case 2: {
                this.doDisconnect(in, out);
                break;
            }
            case 3: {
                this.doOperations(in, out);
                break;
            }
            default: {
                throw new IOException("Invalid opcaode: " + opcode);
            }
        }
        out.flush();
    }

    protected void doList(String connectorID, HttpServletResponse resp) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Received List request: {0}", new Object[]{connectorID});
        }
        IHTTPConnector[] connectors = this.requestHandler.handleList(connectorID);
        PrintWriter writer = resp.getWriter();
        IHTTPConnector[] iHTTPConnectorArray = connectors;
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IHTTPConnector connector = iHTTPConnectorArray[n2];
            writer.write(connector.getConnectorID());
            writer.write(":");
            String userID = connector.getUserID();
            if (userID != null) {
                writer.write(" userID=" + userID);
            }
            if (connector instanceof HTTPServerConnector) {
                long idleTime = System.currentTimeMillis() - ((HTTPServerConnector)connector).getLastTraffic();
                writer.write(" idleTime=" + idleTime);
            }
            writer.write("\n");
            IChannel[] iChannelArray = connector.getChannels();
            int n3 = iChannelArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IChannel channel = iChannelArray[n4];
                writer.write("    ");
                writer.write(String.valueOf(channel.getChannelIndex()));
                writer.write(": ");
                IBufferHandler receiveHandler = channel.getReceiveHandler();
                if (receiveHandler instanceof IProtocol) {
                    writer.write(((IProtocol)receiveHandler).getType());
                } else {
                    String string = receiveHandler.toString();
                    if (string.length() > 256) {
                        string = string.substring(0, 256);
                    }
                    writer.write(string);
                }
                writer.write(" (");
                writer.write(String.valueOf(channel.getChannelID()));
                writer.write(")\n");
                ++n4;
            }
            ++n2;
        }
    }

    protected void doConnect(ExtendedDataInputStream in, ExtendedDataOutputStream out) throws ServletException, IOException {
        try {
            String userID = in.readString();
            if (TRACER.isEnabled()) {
                TRACER.format("Received Connect request: {0}", new Object[]{userID});
            }
            IHTTPConnector connector = this.requestHandler.handleConnect(userID);
            out.writeString(connector.getConnectorID());
            out.writeInt(connector.getMaxIdleTime());
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            out.writeString(null);
        }
    }

    protected void doDisconnect(ExtendedDataInputStream in, ExtendedDataOutputStream out) throws ServletException, IOException {
        try {
            String connectorID = in.readString();
            if (TRACER.isEnabled()) {
                TRACER.format("Received Disconnect request: {0}", new Object[]{connectorID});
            }
            this.requestHandler.handleDisonnect(connectorID);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    protected void doOperations(ExtendedDataInputStream in, ExtendedDataOutputStream out) throws ServletException, IOException {
        String connectorID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Received Operations request: {0}", new Object[]{connectorID});
        }
        this.requestHandler.handleOperations(connectorID, in, out);
    }

    public static class ContainerAware
    extends Net4jTransportServlet {
        private static final String ACCEPTORS_GROUP = "org.eclipse.net4j.acceptors";
        private static final String HTTP_TYPE = "http";
        private static final long serialVersionUID = 1L;
        private HTTPAcceptor acceptor;

        public void init() throws ServletException {
            super.init();
            this.acceptor = (HTTPAcceptor)IPluginContainer.INSTANCE.getElement(ACCEPTORS_GROUP, HTTP_TYPE, null);
            if (this.acceptor == null) {
                throw new ServletException("Acceptor not found");
            }
            this.acceptor.setServlet(this);
            this.setRequestHandler(this.acceptor);
        }

        public void destroy() {
            this.setRequestHandler(null);
            this.acceptor.setServlet(null);
            this.acceptor = null;
            super.destroy();
        }
    }
}

