/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui.views;

import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.net4j.buddies.common.IFacility;
import org.eclipse.net4j.buddies.internal.ui.bundle.OM;
import org.eclipse.net4j.buddies.internal.ui.views.CollaborationsPane;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Layout;

public abstract class FacilityPane
extends Composite
implements IListener {
    private IFacility facility;
    private CollaborationsPane collaborationsPane;
    private CoolBarManager coolBarManager;
    private Control control;

    public FacilityPane(CollaborationsPane collaborationsPane, int style) {
        super((Composite)collaborationsPane, style);
        this.collaborationsPane = collaborationsPane;
        this.setLayout(new FacilityPaneLayout());
        ToolBarManager toolBarManager = new ToolBarManager(8519744);
        this.fillCoolBar((IContributionManager)toolBarManager);
        this.coolBarManager = new CoolBarManager(8519744);
        this.coolBarManager.add((IToolBarManager)toolBarManager);
        this.coolBarManager.setLockLayout(true);
        this.coolBarManager.createControl((Composite)this);
        this.coolBarManager.update(true);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        this.control = this.createUI(composite);
        this.control.setLayoutData((Object)UIUtil.createGridData());
    }

    public void dispose() {
        this.facility.removeListener((IListener)this);
        this.coolBarManager.dispose();
        super.dispose();
    }

    public IFacility getFacility() {
        return this.facility;
    }

    public void setFacility(IFacility facility) {
        this.facility = facility;
        facility.addListener((IListener)this);
    }

    public CollaborationsPane getCollaborationsPane() {
        return this.collaborationsPane;
    }

    public ICoolBarManager getCoolBarManager() {
        return this.coolBarManager;
    }

    public Control getControl() {
        return this.control;
    }

    public final void notifyEvent(final IEvent event) {
        try {
            this.control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        FacilityPane.this.handleEvent(event);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    protected abstract void handleEvent(IEvent var1) throws Exception;

    public void hidden(FacilityPane newPane) {
    }

    public void showed(FacilityPane oldPane) {
    }

    protected abstract Control createUI(Composite var1);

    protected CoolBar getCoolBarControl() {
        if (this.coolBarManager != null) {
            return this.coolBarManager.getControl();
        }
        return null;
    }

    protected void fillCoolBar(IContributionManager manager) {
    }

    public class FacilityPaneLayout
    extends Layout {
        static final int BAR_SIZE = 23;

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = new Point(0, 0);
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Control w = ws[i];
                boolean hide = false;
                if (w == FacilityPane.this.getCoolBarControl()) {
                    if (!this.coolBarChildrenExist()) {
                        hide = true;
                        result.y += 23;
                    }
                } else if (i > 0) {
                    hide = false;
                }
                if (!hide) {
                    Point e = w.computeSize(wHint, hHint, flushCache);
                    result.x = Math.max(result.x, e.x);
                    result.y += e.y;
                }
                ++i;
            }
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Control w = ws[i];
                if (w == FacilityPane.this.getCoolBarControl()) {
                    if (this.coolBarChildrenExist()) {
                        Point e = w.computeSize(clientArea.width, -1, flushCache);
                        w.setBounds(clientArea.x, clientArea.y, clientArea.width, e.y);
                        clientArea.y += e.y;
                        clientArea.height -= e.y;
                    }
                } else {
                    w.setBounds(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                }
                ++i;
            }
        }

        protected boolean coolBarChildrenExist() {
            CoolBar coolBarControl = FacilityPane.this.getCoolBarControl();
            if (coolBarControl != null) {
                return coolBarControl.getItemCount() > 0;
            }
            return false;
        }
    }
}

