/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.mapping.elist.PersistableFeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EContainerRepairControl {
    private static Log log = LogFactory.getLog(EContainerRepairControl.class);
    private static final Hashtable<Class<?>, Class<?>> norepairRequired = new Hashtable();
    private static final Hashtable<Class<?>, List<RepairControl>> repair = new Hashtable();

    public static void setEResourceToAlLContent(InternalEObject start, Resource res) {
        for (EStructuralFeature estruct : start.eClass().getEAllStructuralFeatures()) {
            if (!(estruct instanceof EReference)) continue;
            EReference eref = (EReference)estruct;
            if (eref.isMany()) {
                EList list = (EList)start.eGet((EStructuralFeature)eref);
                if (list == null || list instanceof PersistableEList && !((PersistableEList)list).isLoaded() || list instanceof PersistableFeatureMap && !((PersistableFeatureMap)list).isLoaded()) continue;
                int i = 0;
                while (i < list.size()) {
                    InternalEObject child = (InternalEObject)list.get(i);
                    if (child.eResource() == null) {
                        EContainerRepairControl.setResource(child, new ArrayList<EObject>(), (Resource.Internal)res);
                    }
                    ++i;
                }
                continue;
            }
            InternalEObject child = (InternalEObject)start.eGet((EStructuralFeature)eref);
            if (child == null || child.eResource() != null) continue;
            EContainerRepairControl.setResource(child, new ArrayList<EObject>(), (Resource.Internal)res);
        }
    }

    private static void setResource(InternalEObject eobj, ArrayList<EObject> objs, Resource.Internal res) {
        if (objs.contains(eobj)) {
            return;
        }
        if (eobj.eResource() == null) {
            if (eobj.eContainer() == null) {
                eobj.eSetResource(res, null);
            } else {
                objs.add((EObject)eobj);
                EContainerRepairControl.setResource((InternalEObject)eobj.eContainer(), objs, res);
            }
        }
    }

    public static void repair(Object owner) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Repairing container relations of children of: " + owner.getClass().getName()));
        }
        if (!(owner instanceof InternalEObject)) {
            return;
        }
        if (norepairRequired.get(owner.getClass()) != null) {
            return;
        }
        List<RepairControl> repairList = repair.get(owner.getClass());
        if (repairList == null) {
            repairList = EContainerRepairControl.buildRepairList((InternalEObject)owner);
        }
        if (log.isDebugEnabled() && repairList.size() > 0) {
            log.debug((Object)("Repairing container relations of children of: " + owner.getClass().getName()));
        }
        int i = 0;
        while (i < repairList.size()) {
            RepairControl repairControl = repairList.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Repairing reference " + repairControl.container.getName() + " to child " + repairControl.childClass.getName()));
            }
            repairControl.repair((InternalEObject)owner);
            ++i;
        }
    }

    public static void setContainer(InternalEObject owner, InternalEObject child, EStructuralFeature estruct) {
        if (child.eContainer() == owner) {
            return;
        }
        int featureID = estruct instanceof EReference && ((EReference)estruct).getEOpposite() != null ? ((EReference)estruct).getEOpposite().getFeatureID() : -1 - estruct.getFeatureID();
        child.eBasicSetContainer(owner, featureID, null);
    }

    public static void repair(Object owner, Object child, EStructuralFeature estruct) {
        int correctedFeatureID = estruct instanceof EReference && ((EReference)estruct).getEOpposite() != null ? ((EReference)estruct).getEOpposite().getFeatureID() : -1 - estruct.getFeatureID();
        if (!(owner instanceof InternalEObject)) {
            return;
        }
        if (!(child instanceof InternalEObject)) {
            return;
        }
        if (norepairRequired.get(owner.getClass()) != null) {
            return;
        }
        List<RepairControl> repairList = repair.get(owner.getClass());
        if (repairList == null) {
            repairList = EContainerRepairControl.buildRepairList((InternalEObject)owner);
        }
        if (log.isDebugEnabled() && repairList.size() > 0) {
            log.debug((Object)("Repairing container relations of children of: " + owner.getClass().getName()));
        }
        int i = 0;
        while (i < repairList.size()) {
            RepairControl repairControl = repairList.get(i);
            if (repairControl.getFeatureID() == correctedFeatureID && repairControl.childClass.isAssignableFrom(child.getClass())) {
                repairControl.repair((InternalEObject)owner, (InternalEObject)child);
                return;
            }
            ++i;
        }
    }

    private static List<RepairControl> buildRepairList(InternalEObject owner) {
        ArrayList<RepairControl> result = new ArrayList<RepairControl>();
        for (EStructuralFeature estruct : owner.eClass().getEAllStructuralFeatures()) {
            EReference eref;
            if (!(estruct instanceof EReference) || !(eref = (EReference)estruct).isContainment()) continue;
            if (eref.getEOpposite() != null) {
                result.add(new TwoWayContainer(eref, eref.getEOpposite()));
                continue;
            }
            result.add(new OneWayContainer(eref));
        }
        if (result.size() == 0) {
            norepairRequired.put(owner.getClass(), owner.getClass());
        } else {
            repair.put(owner.getClass(), result);
        }
        return result;
    }

    private static class OneWayContainer
    extends RepairControl {
        OneWayContainer(EReference containerReference) {
            super(containerReference, -1 - containerReference.getFeatureID());
        }
    }

    private static abstract class RepairControl {
        private final EReference container;
        private final Class<?> childClass;
        private final int featureID;

        RepairControl(EReference containerReference, int myFeatureID) {
            this.container = containerReference;
            this.childClass = this.container.getEType().getInstanceClass();
            this.featureID = myFeatureID;
        }

        public int getFeatureID() {
            return this.featureID;
        }

        void repair(InternalEObject owner) {
            if (this.container.isMany()) {
                return;
            }
            Object containedObject = owner.eGet((EStructuralFeature)this.container);
            if (containedObject == null) {
                return;
            }
            assert (!(containedObject instanceof PersistableDelegateList));
            if (!(containedObject instanceof InternalEObject)) {
                return;
            }
            InternalEObject containedEObject = (InternalEObject)containedObject;
            if (containedEObject.eContainer() == owner) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set container of child " + containedObject.getClass().getName() + " containerfield " + this.container.getName()));
            }
            containedEObject.eBasicSetContainer(owner, this.featureID, null);
            EContainerRepairControl.repair(containedEObject);
        }

        void repair(InternalEObject owner, InternalEObject child) {
            if (!this.childClass.isAssignableFrom(child.getClass())) {
                return;
            }
            if (child.eContainer() == owner) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set container of child " + child.getClass().getName() + " containerfield " + this.container.getName()));
            }
            child.eBasicSetContainer(owner, this.featureID, null);
            EContainerRepairControl.repair(child);
        }
    }

    private static class TwoWayContainer
    extends RepairControl {
        TwoWayContainer(EReference containerReference, EReference toContainer) {
            super(containerReference, toContainer.getFeatureID());
        }
    }
}

