/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.ocl.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractQueryDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    private Shell shell = null;
    private EXTLibraryEditor editor = null;
    private Collection<EObject> selectedEObjects = Collections.emptySet();

    protected AbstractQueryDelegate() {
    }

    protected Collection<EObject> getSelectedObjects() {
        Collection<EObject> result = this.selectedEObjects;
        if (this.editor != null && (result == null || result.isEmpty())) {
            result = new ArrayList<EObject>();
            ResourceSet rset = this.editor.getEditingDomain().getResourceSet();
            for (Resource res : rset.getResources()) {
                if (!res.isLoaded()) continue;
                result.addAll((Collection<EObject>)res.getContents());
            }
        }
        return result;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void selectInEditor(Collection<?> objects) {
        this.editor.setSelectionToViewer(objects);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedEObjects = Collections.emptySet();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selectedEObjects = new ArrayList<EObject>();
            for (Object next : structuredSelection) {
                if (!(next instanceof EObject)) continue;
                this.selectedEObjects.add((EObject)next);
            }
        }
        action.setEnabled(!this.selectedEObjects.isEmpty());
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (EXTLibraryEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }
}

