/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ModelImporterApplication;
import org.eclipse.emf.importer.rose.RoseImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoseImporterApplication
extends ModelImporterApplication {
    protected boolean noQualify;
    protected boolean unsettablePrimitive;
    protected Map<String, String> pathMap;
    protected Map<String, PackageInfo> nameToPackageInfo;
    protected Map<String, PackageInfo> nameToReferencedPackageInfo;

    public RoseImporter getRoseImporter() {
        return (RoseImporter)this.getModelImporter();
    }

    protected ModelImporter createModelImporter() {
        return new RoseImporter();
    }

    protected StringBuffer getUsage() {
        StringBuffer result = new StringBuffer();
        this.appendLine(result, "Usage: <model.mdl> [ <model.genmodel> [ -reload ] ] <OPTION>");
        this.appendLine(result, "<OPTION>          ::= [ <PROJECT-OPTION> ]  [ <PATHMAP> ]");
        this.appendLine(result, "                      { <PACKAGE> }+  { <REF-PACKAGE> }* { <REF-GEN-MODEL> }*");
        this.appendLine(result, "                      [ <TEMPLATE-PATH> ] [ <MODEL-PLUGIN-ID> ] [ <COPYRIGHT> ]");
        this.appendLine(result, "                      [ <SDO> ] [ <QUIET> ]");
        this.appendLine(result, "<PROJECT-OPTION>  ::= <MODEL-PROJECT> [ <EDIT-PROJECT> ] [ <EDITOR-PROJECT> ]");
        this.appendLine(result, "                      [ <TESTS-PROJECT> ]");
        this.appendLine(result, "<MODEL-PROJECT>   ::= -modelProject <model-directory> <fragment-path>");
        this.appendLine(result, "<EDIT-PROJECT>    ::= -editProject <edit-directory> <fragment-path>");
        this.appendLine(result, "<EDITOR-PROJECT>  ::= -editorProject <editor-directory> <fragment-path>");
        this.appendLine(result, "<TESTS-PROJECT>   ::= -testsProject <tests-directory> <fragment-path>");
        this.appendLine(result, "<PATHMAP>         ::= -pathMap { <symbol> <directory> }+");
        this.appendLine(result, "<PACKAGE>         ::= -package <name> [ <nsPrefix> <nsURI> <base> <prefix> ]");
        this.appendLine(result, "<REF-PACKAGE>     ::= <deprecated - use -refGenModel instead> -refPackage <name> [ <nsPrefix> <nsURI> <base> <prefix> ]");
        this.appendLine(result, "<REF-GEN-MODEL>   ::= -refGenModel <model.genmodel> { <nsURI> }+");
        this.appendLine(result, "<TEMPLATE-PATH>   ::= -templatePath <template-directory>");
        this.appendLine(result, "<MODEL-PLUGIN-ID> ::= -modelPluginID <plugin-ID>");
        this.appendLine(result, "<COPYRIGHT>       ::= -copyright <copyright-string>");
        this.appendLine(result, "<JDK-LEVEL>       ::= -jdkLevel <jdk level: 1.4 5.0 6.0>");
        this.appendLine(result, "<VALIDATE-MODEL>  ::= -validateModel <true|false>");
        this.appendLine(result, "<SDO>             ::= -sdo");
        this.appendLine(result, "<QUIET>           ::= -quiet");
        this.appendLine(result, "");
        this.appendLine(result, "For example:");
        this.appendLine(result, "");
        this.appendLine(result, "");
        this.appendLine(result, "  rose2genmodel");
        this.appendLine(result, "    ../../etools.company/src/rose/model.mdl");
        this.appendLine(result, "    result/model/Extended.genmodel");
        this.appendLine(result, "    -modelProject result src");
        this.appendLine(result, "    -editProject result.edit src");
        this.appendLine(result, "    -editorProject result.editor src");
        this.appendLine(result, "    -pathMap VABASE_PLUGINS_PATH C:/sandbox/unpackage2/eclipse/plugins");
        this.appendLine(result, "    -package extended Extended Extended.ecore org.example Extended");
        this.appendLine(result, "    -refPackage company Company Company.ecore org.sample Company");
        return result;
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-pathmap")) {
            if (this.pathMap == null) {
                this.pathMap = new HashMap<String, String>();
            }
            do {
                String variable = arguments[++index];
                String directory = arguments[++index];
                this.pathMap.put(variable, directory);
            } while (index + 1 < arguments.length && !arguments[index + 1].startsWith("-"));
        } else if (arguments[index].equalsIgnoreCase("-package")) {
            if (this.nameToPackageInfo == null) {
                this.nameToPackageInfo = new HashMap<String, PackageInfo>();
            }
            index = this.processPackageInformation(arguments, index, this.nameToPackageInfo);
        } else if (arguments[index].equalsIgnoreCase("-refPackage")) {
            System.out.println("**** Instead of -refPackage you should be using -refGenModel");
            if (this.nameToReferencedPackageInfo == null) {
                this.nameToReferencedPackageInfo = new HashMap<String, PackageInfo>();
            }
            index = this.processPackageInformation(arguments, index, this.nameToReferencedPackageInfo);
        } else if (arguments[index].equalsIgnoreCase("-unsettablePrimitive")) {
            this.unsettablePrimitive = true;
        } else if (arguments[index].equalsIgnoreCase("-noQualify")) {
            this.noQualify = true;
        } else {
            return super.processArgument(arguments, index);
        }
        return index + 1;
    }

    protected int processPackageInformation(String[] arguments, int index, Map<String, PackageInfo> nameToPackageInfo) {
        int start = index;
        PackageInfo packageInfo = new PackageInfo();
        if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
            packageInfo.name = arguments[++index];
            if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                packageInfo.nsPrefix = arguments[++index];
                if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                    packageInfo.nsURI = arguments[++index];
                    if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                        packageInfo.base = arguments[++index];
                        if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                            packageInfo.prefix = arguments[++index];
                        }
                    }
                }
            }
            if (index - start != 1 && index - start != 5) {
                throw new IllegalArgumentException("Error: Expecting either 1 or 5 arguments for " + arguments[start]);
            }
            nameToPackageInfo.put(packageInfo.name, packageInfo);
            nameToPackageInfo.put(packageInfo.name.toLowerCase(), packageInfo);
            return index;
        }
        throw new IllegalArgumentException("Error: No package name was specified for " + arguments[start]);
    }

    protected void adjustModelImporter(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustModelImporter(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            RoseImporter roseImporter = this.getRoseImporter();
            if (this.pathMap != null) {
                roseImporter.getPathMap().putAll(this.pathMap);
            }
            roseImporter.setNoQualify(this.noQualify);
            roseImporter.setUnsettablePrimitive(this.unsettablePrimitive);
        }
        finally {
            monitor.done();
        }
    }

    protected void adjustEPackages(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            List ePackages = this.getRoseImporter().getEPackages();
            this.traverseEPackages(ePackages);
            this.getRoseImporter().adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    protected void traverseEPackages(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            PackageInfo packageInfo;
            String packageName = ePackage.getName();
            boolean isReferencedEPackage = false;
            PackageInfo packageInfo2 = packageInfo = this.nameToPackageInfo == null ? null : this.nameToPackageInfo.get(packageName);
            if (packageInfo == null && this.nameToReferencedPackageInfo != null) {
                packageInfo = this.nameToReferencedPackageInfo.get(packageName);
                boolean bl = isReferencedEPackage = packageInfo != null;
            }
            if (packageInfo != null || this.nameToPackageInfo == null) {
                this.handleEPackage(ePackage, !isReferencedEPackage);
            }
            if (packageInfo != null) {
                ModelImporter.EPackageImportInfo ePackageInfo;
                if (!this.getRoseImporter().hasRoseGenPackageProperties(ePackage)) {
                    ePackage.setNsPrefix(packageInfo.nsPrefix);
                    ePackage.setNsURI(packageInfo.nsURI);
                }
                if ((ePackageInfo = this.getRoseImporter().getEPackageImportInfo(ePackage)).getBasePackage() == null) {
                    ePackageInfo.setBasePackage(packageInfo.base);
                }
                if (ePackageInfo.getPrefix() == null) {
                    ePackageInfo.setPrefix(packageInfo.prefix);
                }
            }
            this.handleQualifiedEPackageName(ePackage);
            this.traverseEPackages((List<EPackage>)ePackage.getESubpackages());
        }
    }

    public static class PackageInfo {
        public String name;
        public String nsPrefix;
        public String nsURI;
        public String base;
        public String prefix;
    }
}

