/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.List;
import org.eclipse.emf.compare.match.engine.GenericMatchScope;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.match.engine.IMatchScopeProvider;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatchScopeProvider
implements IMatchScopeProvider {
    private IMatchScope leftScope;
    private IMatchScope rightScope;
    private IMatchScope ancestorScope;

    public GenericMatchScopeProvider(EObject leftObject, EObject rightObject) {
        this.leftScope = new GenericMatchScope(leftObject);
        this.rightScope = new GenericMatchScope(rightObject);
    }

    public GenericMatchScopeProvider(EObject leftObject, EObject rightObject, EObject ancestorObject) {
        this(leftObject, rightObject);
        this.ancestorScope = new GenericMatchScope(ancestorObject);
    }

    public GenericMatchScopeProvider(Resource leftResource, Resource rightResource) {
        this.leftScope = new GenericMatchScope(leftResource);
        this.rightScope = new GenericMatchScope(rightResource);
    }

    public GenericMatchScopeProvider(Resource leftResource, Resource rightResource, Resource ancestorResource) {
        this(leftResource, rightResource);
        this.ancestorScope = new GenericMatchScope(ancestorResource);
    }

    public GenericMatchScopeProvider(ResourceSet leftResourceSet, ResourceSet rightResourceSet) {
        this.leftScope = new GenericMatchScope(leftResourceSet);
        this.rightScope = new GenericMatchScope(rightResourceSet);
    }

    public GenericMatchScopeProvider(ResourceSet leftResourceSet, ResourceSet rightResourceSet, ResourceSet ancestorResourceSet) {
        this(leftResourceSet, rightResourceSet);
        this.ancestorScope = new GenericMatchScope(ancestorResourceSet);
    }

    @Override
    public IMatchScope getAncestorScope() {
        return this.ancestorScope;
    }

    @Override
    public IMatchScope getLeftScope() {
        return this.leftScope;
    }

    @Override
    public IMatchScope getRightScope() {
        return this.rightScope;
    }

    @Override
    public void applyResourceFilter(IResourceFilter filter) {
        if (this.ancestorScope != null) {
            GenericMatchScopeProvider.applyExternalFilter(filter, ((GenericMatchScope)this.leftScope).getResourcesInScope(), ((GenericMatchScope)this.rightScope).getResourcesInScope(), ((GenericMatchScope)this.ancestorScope).getResourcesInScope());
        } else {
            GenericMatchScopeProvider.applyExternalFilter(filter, ((GenericMatchScope)this.leftScope).getResourcesInScope(), ((GenericMatchScope)this.rightScope).getResourcesInScope());
        }
    }

    private static void applyExternalFilter(IResourceFilter filter, List<Resource> ... resources) {
        if (resources.length == 2) {
            filter.filter(resources[0], resources[1]);
        } else {
            filter.filter(resources[0], resources[1], resources[2]);
        }
    }
}

